#include "salem.h"

static object_t		*RootOfSearch;
static char			PathName[MAXLINE],*Match[MAXARGS];
static int			N_match;

static accept(p)
pstate_t	*p;
{
	int		len;
	len = strlen(PathName);
	if (len + p->bp > p->buf + sizeof(p->buf)) return FALSE;
	strcpy(p->bp,PathName);
	Match[N_match++] = p->bp;
	p->bp += len + 1;
	return TRUE;
}

globsearch(obj,pat,p)
object_t	*obj;			/* object to visit */
char		**pat;			/* array of regular expressions */
pstate_t	*p;				/* command line being globbed */
{
	objlink_t	*link;
	char		*child_name,*end_ptr;

	for (end_ptr = PathName; *end_ptr; end_ptr++);
	for (link = obj->child_list; link; link = link->c_next) {
		child_name = link->child->name;
		if (regex_advance(child_name,pat[0])) {
			if (obj != RootOfSearch) strcat(end_ptr,"/");
			strcat(end_ptr,child_name);
			if (pat[1] == 0)  {
				if (accept(p) == FALSE) return FALSE;
			}
			else {
				if (globsearch(link->child,pat+1,p) == FALSE)
					return FALSE;
			}
			*end_ptr = 0;
		}
	}
	return TRUE;
}

/* glob the k-th arg of p.  store result in p.
 */
glob(p,k)
pstate_t	*p;
int			k;
{
	int		i,nc;
	char	*pattern,*elt[MAXARGS];

	N_match = 0;
	pattern = p->argv[k];
	nc = parse_path(pattern,elt);
	for (i = 0; i < nc; i++)
		if ((elt[i] = regex_compile(elt[i])) == NULL) return;
	elt[i] = 0;
	if (pattern[0] == '/') { RootOfSearch = Root; strcpy(PathName,"/"); }
	else { RootOfSearch = World; PathName[0] = 0; }
	if (globsearch(RootOfSearch,elt,p) == FALSE) {
		fprintf(stderr,"glob too big\n");
		p->argc = 0;
	}
	else if (N_match > 0) {
		qsort(Match,N_match,sizeof(Match[0]),strptrcmp);
		for (i = k + 1; i < p->argc; i++) p->argv[i + N_match - 1] = p->argv[i];
		for (i = 0; i < N_match; i++) p->argv[k + i] = Match[i];
		p->argc += N_match - 1;
	}
	for (i = 0; i < nc; i++) free(elt[i]);
}
