#include "salem.h"

int set_quantum();
int wait_drawn();
int wait_n_ticks();

initialize_timing() {
	register_client("timing", set_quantum,  "timing value" );
	register_client("draw", wait_drawn, "draw (causes a pause)");
	register_client("wait",   wait_n_ticks, "wait number_of_ticks" ); 
	notranscribe_last_client();
}

salem_timing() 
{
	static int	last_tick = 0;
	int		cur_tick;

	do {
		cur_tick = getvaluator(TIMER0);
		if (cur_tick < last_tick) last_tick = cur_tick; /* wrap */
	} while (cur_tick - last_tick < Time_quantum);
	last_tick = cur_tick;
}

set_quantum(argc,argv)
int	argc;
char	**argv;
{
	if (argc != 2) ERR_RET(" Usage: quantum value")
	Time_quantum = atoi(argv[1]);
	if (Time_quantum < 1) Time_quantum = 1;
}

wait_n_ticks(argc,argv)
int	argc;
char	**argv;
{
	if (argc != 2) ERR_RET("Usage: wait number_of_ticks")
	Ticks_to_wait = atoi(argv[1]);
	if (Ticks_to_wait < 0) Ticks_to_wait = 0;
}

wait_drawn()
{
	sginap(Time_quantum);
}
