/*ScianFields.h
  Eric Pepke
  July 15, 1991
  External stuff for fields in SciAn
*/

#if 0
#define FORMFIELD	0	/*Default number for a data form field*/
#define FIELD1		1
#define FIELD2		2
#define FIELD3		3
#define FIELD4		4
#define MAXNCURFIELDS	5	/*Maximum number of current fields*/

typedef struct
    {
	real *data;		/*Pointer to the data*/
	int nIndices;		/*Number of topological indices*/
	int *indices;		/*Numbers of the indices required*/
	long *dimensions;	/*Dimensions of the component*/
	long *steps;		/*Steps into the indices*/
    } Component;

typedef struct
    {
	int nComponents;	/*Number of components of this field*/
	Component *components;	/*Components in the field*/
    } Field;

extern Field curFields[MAXNCURFIELDS];

#ifdef PROTO
void InitFields(void);
void KillFields(void);
void SetCurField(int, ObjPtr);
real SelectFieldComponent(int, int, long *);
void StuffScalarIJSquare(real dest[2][2], int whichField, long indices[]);
void StuffIJSquare(real dest[2][2], int whichField, int whichComponent, long indices[]);
#else
void InitFields();
void KillFields();
void SetCurField();
real SelectFieldComponent();
void StuffScalarIJSquare();
void StuffIJSquare();
#endif
#endif
