/*ScianColors.h
  Color management info for scian
  Eric Pepke
  March 15, 1990
*/

/*User interface color ID's and indices into palette*/
#define UIBLACK		0		/*Black				*/
#define UIGRAY12	1		/*12.5 % Gray			*/
#define UIGRAY25	2		/*25 % Gray			*/
#define UIGRAY37	3		/*37.5 % Gray			*/
#define UIGRAY50	4		/*50 % Gray			*/
#define UIGRAY62	5		/*62.5 % Gray			*/
#define UIGRAY75	6		/*75 % Gray			*/
#define UIGRAY87	7		/*87.5 % Gray			*/
#define UIWHITE		8		/*White				*/
#define UIRED		9		/*Bright red			*/
#define UIGREEN		10		/*Bright green			*/
#define UIBLUE		11		/*Bright blue			*/
#define UIMAGENTA	12		/*Bright magenta		*/
#define UIYELLOW	13		/*Bright yellow			*/
#define UICYAN		14		/*Bright cyan			*/
#define UIGOLD		15		/*Gold (as in garnet and)	*/

#define NPUREUICOLORS	16		/*16 pure UI colors		*/

#define UIPRED		16		/*Pastel red (pink)		*/
#define UIPINK		16		/*Another name for pink		*/
#define UIPGREEN	17		/*Pastel green			*/
#define UIPBLUE		18		/*Pastel blue			*/
#define UIPMAGENTA	19		/*Pastel magenta		*/
#define UIPYELLOW	20		/*Pastel yellow			*/
#define UIPCYAN		21		/*Pastel cyan			*/
#define NUICOLORS	22		/*Total number of UI colors	*/

/*Do not contrast any of the pastel colors with UIBACKGROUND!*/

/*Derived colors*/
#define UIBACKGROUND	UIGRAY50	/*Panel background*/
#define UIHIBACKGROUND	UIWHITE		/*Hilighted panel background*/
#define UITEXT		UIBLACK		/*Color to draw unhilited text*/
#define UIGREYTEXT	UIGRAY12	/*Color of greyed text*/

#define UITOPEDGE	UIWHITE		/*Top edge of a projection*/
#define UILEFTEDGE	UIGRAY75	/*Left edge of a projection*/
#define UIRIGHTEDGE	UIGRAY25	/*Right edge of a projection*/
#define UIBOTTOMEDGE	UIGRAY12	/*Bottom edge of a projection*/
#define UISHADOW	UIGRAY12	/*Icon shadow*/
#define UIICONBACK	UIGRAY87	/*Unhilighted icon background color*/
#define UIICONGREYFORE	UIGRAY25	/*Grey icon foreground*/
#define UIICONGREYBACK	UIGRAY75	/*Grey icon background*/
#define UIICONFORE	UIBLACK		/*Icon foreground color*/
#define UIICONPIT	UIPCYAN		/*Icon Pit color*/
#define UICONTROLTRACK	UIPGREEN	/*Control track color*/
#define UITEXTPIT	UIPRED		/*Text Pit color*/
#define UIICONHIBACK	UIWHITE		/*Highlighted icon background*/
#define UIICONSELBACK	UIYELLOW	/*Selected icon background*/

#define MAXCDIST	400		/*Maximum distance for color search*/
#define MAXGRAYDIRT	0		/*Maximum dirtiness in gray*/
#define COLORBEG8BITS	56		/*Color beg for 8 bits*/
#define COLORBEGMOREBITS 256		/*Color beg for more bits*/

#define DEFPALSIZE	64		/*Default number of colors in palette*/

extern short curRed, curGreen, curBlue;

typedef short short3[3];

extern short uiColors[NUICOLORS][3];

typedef struct pal
    {
	Thing thing;
	struct pal *next;		/*Next palette in list of active palettes*/
    } Palette, *PPtr;

extern short3 *curColors;		/*The current colors*/
extern int curNColors;			/*Current number of colors*/
extern real curMin, curMax;		/*Current min and max values*/
extern int curBeg;			/*Current beginning*/
extern real diffMult;			/*Amount to multiply to get difference*/

/*Simple palette functions*/
#define PF_RAMP		0		/*Interpolate a ramp*/
#define PF_REVERSE	1		/*Reverse range of colors*/
#define PF_RUFFLE	2		/*Ruffle range of colors*/
#define PF_SMOOTH	3		/*Smooth range of colors*/
#define PF_SHARPEN	4		/*Sharpen range of colors*/
#define NPALETTEFUNCS	5		/*Number of palette functions*/
extern char *spfNames[];

/*Color models*/
#define CM_RGB		0		/*RGB color model*/
#define CM_YIQ		1		/*YIQ color model*/
#define CM_HSV		2		/*HSV color model*/
#define CM_HLS		3		/*HLS color model*/
#define NCOLORMODELS	4		/*Number of models*/
extern char *colorModelNames[];

/*Palette tools*/
#define PT_FREEFORM	0		/*Free form drawing*/
#define PT_SINE		1		/*Sine function*/
#define PT_TRIANGLE	2		/*Triangle function*/
#define PT_SAWTOOTH	3		/*Sawtooth function*/
#define PT_TOOTHSAW	4		/*Toothsaw function*/
#define PT_SQUARE	5		/*Square wave function*/
#define NPALETTETOOLS	6		/*Number of tools*/

#define SetRealColor(c)	/*Sets real color c in current palette*/	\
	if (c == missingData)						\
	{								\
	    if (rgbp)							\
	        c3s(curColors[0]);					\
	    else							\
	        color((int) curBeg - 2);				\
	}								\
	else if (c < curMin)						\
	{								\
	    if (rgbp)							\
	        c3s(curColors[1]);					\
	    else							\
	        color((int) (curBeg - 1));				\
	}								\
	else if (c > curMax)						\
	{								\
	    if (rgbp)							\
	        c3s(curColors[curNColors - 1]);				\
	    else							\
	        color((int) (curBeg + curNColors - 3));			\
	}								\
	else								\
	{								\
	    if (rgbp)							\
		c3s(curColors[2 + (int) (diffMult * (c - curMin))]);	\
	    else							\
		color((int) (curBeg + diffMult * (c - curMin)));	\
	}

#define GetRealColorIndex(c)	/*Gets index or real color for data c in current palette*/\
	c == missingData ?						\
	    -2 :							\
	c < curMin ?							\
	    -1 :							\
	c > curMax ?							\
	    curNColors - 3 :							\
	(int) (diffMult * (c - curMin))				\


#define GREYPAT		1		/*Grey pattern*/
#define SOLIDPAT	0		/*System pattern, solid*/

extern int uiColorIndex[];
#define RGBC(c)					\
	if (rgbp)				\
	{					\
	    c3f(c);				\
	}					\
	else					\
	{					\
	    color(uiColorIndex[ClosestUIColor(c)]);		\
	}


extern Bool rgbp;
extern int overDraw;

/*Method declarations*/
ObjPtr ClonePalette();

/*Passable routines*/
void SimpleFuncFromMenu();

#ifdef PROTO
void InitColors();
void SetUIColor(int);
ObjPtr NewPalette(int);
void DisposePalette(ObjPtr);
void InterpPalette(ObjPtr, int, int, int, int, int, int);
ObjPtr NewColorWheel(int, int, int, int, char *);
void HSV2RGB(real *, real *, real *, real, real, real);
void RGB2HSV(real *, real *, real *, real, real, real);
void HLS2RGB(real *, real *, real *, real, real, real);
void RGB2HLS(real *, real *, real *, real, real, real);
void YIQ2RGB(real *, real *, real *, real, real, real);
void RGB2YIQ(real *, real *, real *, real, real, real);
void SetPalette(ObjPtr);
void SetPaletteMinMax(ObjPtr, real, real);
void CopyPalette(ObjPtr, ObjPtr);
void CopyAttenuatedPalette(ObjPtr, ObjPtr, real);
void BlueToRedPalette(ObjPtr);
void GreenToRedPalette(ObjPtr);
int ClosestUIColor(float clr[3]);
ObjPtr NewColorBar(int, int, int, int, char *);
void ActivateColorWheel(ObjPtr, Bool);
real GetColorValue(ObjPtr, int);
ObjPtr SetFunctionBox(ObjPtr, ObjPtr);
ObjPtr SetColorBarColor(ObjPtr, int, int, int, int);
void LogColorChange(ObjPtr, short3 *colors, int);
ObjPtr ImposeColorFunction(ObjPtr);
void CalcGoodSteps(double, int, int, double *majorWidth, int *nMinorSteps);
void CopyColorsToPalette(ObjPtr, short3 *);
ObjPtr NewPaletteDisplay(int, int, int, int, char *name, ObjPtr palette);
void SetObjectColor(ObjPtr);
void MapPaletteColors(ObjPtr p, int start, int end);
void FieldPaletteName(ObjPtr, ObjPtr);
void OverDraw(Bool);
real PSColor(void);
int ChooseSelectionColor(ObjPtr);
ObjPtr NewAtomicPalette(void);
void TinyDelay(void);
#else
void InitColors();
void SetUIColor();
ObjPtr NewPalette();
void DisposePalette();
void InterpPalette();
ObjPtr NewColorWheel();
void HSV2RGB();
void RGB2HSV();
void HLS2RGB();
void RGB2HLS();
void YIQ2RGB();
void RGB2YIQ();
void SetPalette();
void SetPaletteMinMax();
void CopyPalette();
void CopyAttenuatedPalette();
void BlueToRedPalette();
void GreenToRedPalette();
int ClosestUIColor();
ObjPtr NewColorBar();
void ActivateColorWheel();
real GetColorValue();
ObjPtr SetFunctionBox();
ObjPtr SetColorBarColor();
void LogColorChange();
ObjPtr ImposeColorFunction();
void CalcGoodSteps();
void CopyColorsToPalette();
ObjPtr NewPaletteDisplay();
void SetObjectColor();
void MapPaletteColors();
void FieldPaletteName();
void OverDraw();
real PSColor();
int ChooseSelectionColor();
ObjPtr NewAtomicPalette();
void TinyDelay();
#endif
