/*ScianControls.h
  External stuff for controls
  Eric Pepke
  March 28, 1990
*/

#define ICONXSPACE	100		/*X spacing between icons*/
#define ICONYSPACE	80		/*Y spacing between icons*/
#define ICONLEFTBORDER	50		/*Minimum x for icons*/
#define ICONBOTBORDER	70		/*Bottom border for icons*/
#define ICONTOPBORDER	30		/*Top border for icons*/
#define ICONRIGHTBORDER 50		/*Right border for icons*/
#define ICONXMINSPACE	70		/*Minimum X spacing*/
#define ICONYMINSPACE	70		/*Minimum Y spacing*/

#define BARRIGHT	1		/*Scroll bar on the right*/
#define BARBOTTOM	2		/*Scroll bar on bottom*/
#define BARLEFT		4		/*Scroll bar on the left*/
#define BARTOP		8		/*Scroll bar on the top*/
#define OBJECTSFROMTOP	16		/*Objects are dropped from top*/

extern ObjPtr controlClass, corralClass, panelClass, greyPanelClass;

#ifdef PROTO
void InitControls(void);
ObjPtr NewPanel(ObjPtr, int, int, int, int);
ObjPtr NewIconCorral(ObjPtr, int, int, int, int, int);
ObjPtr NewButton(int, int, int, int, char *);
void DrawPitFrame(int, int, int, int, int);
void DropIconInCorral(ObjPtr, ObjPtr);
ObjPtr NewSwitch(int, int, int, int, int, int, int, char *);
ObjPtr DrawField(ObjPtr);
void StartPanel(int, int, int, int);
real ChooseGoodStep(real min, real max);
void ChooseGoodSliderParams(real *min, real *max, real *bigStep, real *littleStep, real *anchor);
ObjPtr NewGreyCover(int, int, int, int);
ObjPtr NewControlField(int, int, int, int, char *name, int);
void ScrollHome(ObjPtr);
void SelectAllIcons(ObjPtr);
void DeselectAllIcons(ObjPtr);
void DoSelectAllIcons(void);
void DoDeselectAllIcons(void);
#else
void InitControls();
ObjPtr NewPanel();
ObjPtr NewIconCorral();
void DrawPitFrame();
ObjPtr NewButton();
void DropIconInCorral();
ObjPtr NewSwitch();
ObjPtr DrawField();
void StartPanel();
real ChooseGoodStep();
void ChooseGoodSliderParams();
ObjPtr NewGreyCover();
ObjPtr NewControlField();
void ScrollHome();
void SelectAllIcons();
void DeselectAllIcons();
void DoSelectAllIcons();
void DoDeselectAllIcons();
#endif

