
/* ScianMethods.c:	John R. Murray, 3-30-90
		Wrappers for Method calls.
*/
#include "Scian.h"
#include "ScianTypes.h"
#include "ScianIDs.h"
#include "ScianMethods.h"
#include "ScianScripts.h"

/* globals */

/* temporary defs to get something going */
#ifndef SETVAL
#define SETVAL 102
#endif

int SetValue(object, value)
ObjPtr	object, value;	
{
    FuncTyp setter, changer;
    ObjPtr retVal;

    setter = GetMethod(object, SETVAL);
    if (setter)
    {
	retVal = (* setter) (object, value);
    }
    else
    {
	/* all objects SHOULD have a SETVAL method */
	ReportError("SetValue", "Warning: no SETVAL method");
	retVal = SetObjValue(object, value);
    }

    return IsTrue(retVal);
}

ObjPtr GetValue(obj)
ObjPtr obj;
{
    FuncTyp getter;

    getter = GetMethod(obj, GETVAL);
    if (getter)
    {
	return (*getter) (obj);
    }
    else
    {
	/* all objects SHOULD have a GETVAL method */
	ReportError("GetValue", "Warning: no GETVAL method");
	return GetObjValue(obj);
    }
}

int ChangedValue(object)
ObjPtr	object;
{
    FuncTyp	changer;
    int		retVal;

    changer = GetMethod(object, CHANGEDVALUE);
    if(changer)
    {
	InhibitLogging(true);
	retVal = IsTrue((* changer) (object));
	InhibitLogging(false);
	return retVal;
    }
    else
    {
	return false;
    }
}

#if 0
/*EMP obselete*/
int ChangedPalette(object)
ObjPtr	object;
{
    FuncTyp	changer;
    int retVal;

    changer = GetMethod(object, CHANGEDPALETTE);
    if(changer)
    {
	InhibitLogging(true);
	retVal = IsTrue((* changer) (object));
	InhibitLogging(false);
	return retVal;
    }
    else
    {
	return false;
    }
}
#endif

int RecalcScroll(obj)
ObjPtr obj;
{
    FuncTyp	recalcer;

    recalcer = GetMethod(obj, RECALCSCROLL);
    if (recalcer)
    {
	return IsTrue((* recalcer) (obj));
    }
    else
    {
	return false;
    }
}

int ButtonPressed(obj)
ObjPtr obj;
{
    FuncTyp buttpress;

    buttpress = GetMethod(obj, BUTTONPRESSED);
    if (buttpress)	/* I don't get it, what's so funny? */
    {
	return IsTrue((* buttpress) (obj));	/* what're you laughing at? */
    }
    else
    {
	return false;
    }
}

int Mark(obj)
ObjPtr obj;
{
    FuncTyp marker;

    marker = GetMethod(obj, MARK);
    if (marker)
    {
	return IsTrue((* marker) (obj));
    }
    else
    {
	return false;
    }
}

int Select(obj, flag)
ObjPtr obj;
int flag;
{
    FuncTyp selector;

    selector = GetMethod(obj, SELECT);
    if (selector)
    {
	return IsTrue((* selector) (obj, flag));
    }
    else
    {
	return false;
    }
}

int AutoScroll(obj)
ObjPtr obj;
{
    FuncTyp autoScroller;

    autoScroller = GetMethod(obj, AUTOSCROLL);
    if (autoScroller)
    {
	return IsTrue((* autoScroller) (obj));
    }
    else
   {
	return false;
   }
}
