/*
 * Copyright (c) 1991, 1992, 1993 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Silicon Graphics.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF
 * ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */
typedef struct _WINDOW_REC {
    int x, y, w, h;
    GLenum type;
    Window wMain, wOverlay;
    XVisualInfo *vInfoMain, *vInfoOverlay;
    Colormap cMapMain, cMapOverlay;
    GLXContext cMain, cOverlay;
} WINDOW_REC;


extern Display *xDisplay;
extern int xScreen; 
extern Window wRoot;
extern WINDOW_REC w;
extern Atom deleteWindowAtom;

extern void (*ExposeFunc)(int, int);
extern void (*ReshapeFunc)(int, int);
extern void (*DisplayFunc)(void);
extern GLenum (*KeyDownFunc)(int, GLenum);
extern GLenum (*MouseDownFunc)(int, int, GLenum);
extern GLenum (*MouseUpFunc)(int, int, GLenum);
extern GLenum (*MouseMoveFunc)(int, int, GLenum);
extern void (*IdleFunc)(void);

extern int cursorNum;

