/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * tobw.c - Filter to change an RLE file to B&W.
 * 
 * Author:	Spencer W. Thomas
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Tue Feb 25 1986
 * Copyright (c) 1986, University of Utah
 * 
 */
#ifndef lint
static char rcs_ident[] = "$Header: /l/spencer/src/urt/tools/tools/RCS/tobw.c,v 3.0.1.3 1992/02/11 21:37:53 spencer Exp $";
#endif
#if 0
tobw()				/* For tags. */
#endif

#include <stdio.h>
#include <math.h>
#include "rle.h"

/*****************************************************************
 * TAG( main )
 * 
 * Usage: tobw [-t] [-o outfile] [infile]
 * 
 * Inputs:
 *	-t:		If specified, output a 3-channel image (all three
 *			the same).
 * 	infile:		Input (color) RLE file.  Stdin used if not
 *			specified.
 * Outputs:
 * 	outfile:	Output (black & white) RLE file.  Stdout used
 *			if not specified.
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */
void
main( argc, argv )
int argc;
char **argv;
{
    char * infname = NULL, * outfname = NULL;
    FILE * outfile = stdout;
    int oflag = 0, tflag = 0, y, nrow;
    rle_hdr in_hdr, out_hdr;
    unsigned char ** scan, *outscan[4];
    unsigned char * buffer;
    int rle_cnt, rle_err;

    if ( scanargs( argc, argv, "% t%- o%-outfile!s infile%s",
		    &tflag, &oflag, &outfname, &infname ) == 0 )
	exit( 1 );

    in_hdr = *rle_hdr_init( (rle_hdr *)NULL );
    rle_names( &in_hdr, cmd_name( argv ), infname, 0 );
    rle_names( &out_hdr, in_hdr.cmd, outfname, 0 );
    in_hdr.rle_file = rle_open_f(in_hdr.cmd, infname, "r");

    for ( rle_cnt = 0;
	  (rle_err = rle_get_setup( &in_hdr )) == RLE_SUCCESS;
	  rle_cnt++ )
    {
	(void)rle_hdr_cp( &in_hdr, &out_hdr );

	if ( in_hdr.ncolors == 1 )
	{
	    fprintf( stderr, "%s: %s is already black & white\n",
		     in_hdr.cmd, in_hdr.file_name );
	    exit( 1 );
	}
	if ( in_hdr.ncolors < 3 )
	{
	    fprintf( stderr, "%s: %s is not RGB",
		     in_hdr.cmd, in_hdr.file_name );
	    exit( 1 );
	}
	if ( in_hdr.alpha )
	    RLE_SET_BIT( in_hdr, RLE_ALPHA );
	/* Delete colormap, if present. */
	if ( in_hdr.ncmap > 0 )
	{
	    fprintf( stderr, "%s: %s has a colormap, which will be ignored.\n",
		     in_hdr.cmd, in_hdr.file_name );
	    free( out_hdr.cmap );
	    out_hdr.cmap = 0;
	    out_hdr.ncmap = 0;
	    out_hdr.cmaplen = 0;
	    rle_delcom( "color_map_length", &out_hdr );
	}

	if ( rle_cnt == 0 )
	    outfile = rle_open_f(out_hdr.cmd, outfname, "w");
	in_hdr.xmax -= in_hdr.xmin;
	in_hdr.xmin = 0;
	nrow = in_hdr.xmax + 1;
	buffer = (unsigned char *)malloc( nrow );
	RLE_CHECK_ALLOC( cmd_name( argv ), buffer, 0 );
	if ( rle_row_alloc( &in_hdr, &scan ) < 0 )
	    RLE_CHECK_ALLOC( cmd_name( argv ), 0, 0 );
	if ( in_hdr.alpha )
	{
	    outscan[0] = scan[-1];
	}
	outscan[1] = buffer;
	/* If 3 channel output, reference the line 3 times */
	if ( tflag )
	    outscan[2] = outscan[3] = buffer;

	if ( ! tflag )
	    out_hdr.ncolors = 1;
	else
	    out_hdr.ncolors = 3;

	if ( in_hdr.background != NULL )
	{
	    rle_pixel r, g, b, o;

	    out_hdr.bg_color = (int *)malloc( sizeof( int ) );
	    RLE_CHECK_ALLOC( cmd_name( argv ), out_hdr.bg_color, 0 );
	    r = in_hdr.bg_color[0];
	    g = in_hdr.bg_color[1];
	    b = in_hdr.bg_color[2];
	    rgb_to_bw( &r, &g, &b, &o, 1 );
	    out_hdr.bg_color[0] = o;
	}

	rle_addhist( argv, &in_hdr, &out_hdr );

	out_hdr.rle_file = outfile;

	rle_put_setup( &out_hdr );

	while ( (y = rle_getrow( &in_hdr, scan )) <=
		in_hdr.ymax )
	{
	    rgb_to_bw( scan[0], scan[1], scan[2], buffer, nrow );
	    rle_putrow( &outscan[1], nrow, &out_hdr );
	}
	rle_puteof( &out_hdr );

	rle_row_free( &in_hdr, scan );
    }

    /* Check for an error.  EOF or EMPTY is ok if at least one image
     * has been read.  Otherwise, print an error message.
     */
    if ( rle_cnt == 0 || (rle_err != RLE_EOF && rle_err != RLE_EMPTY) )
	rle_get_error( rle_err, cmd_name( argv ), infname );

    exit( 0 );
}
