/* sample Cyberware file operations */

static char SccsId[] = "@(#)sample.c	1.3";

/* Compiler:
 *		Sun & IRIS:	cc -o sample sample.c cyfile.c strings.c -lm
 *		DOS:		cl /AL sample.c cyfile.c strings.c
 */

#include <stdio.h>
#include <fcntl.h>
#include "cyfile.h"

long atol();
void perror();

main(argc, argv)

int argc;
char *argv[];
{
	int fd;			/* target image file */
	GSPEC *gs;		/* database descriptor */
	long scale;		/* scaling factor */
	int lt, lg;		/* latitude/longitude indicies */
	long radius;		/* radius variable */

	if (argc != 3) {
		puts("Usage: sample image_pathname scale");
		exit(-1);
	}
	scale = atol(argv[2]);
	if (scale < 1 || scale > 200) {
		puts("Scale out of range");
		exit(-1);
	}
#ifdef M_I86
	if ((fd = open(argv[1], O_RDWR|O_BINARY)) == -1) {
#else
	if ((fd = open(argv[1], O_RDWR)) == -1) {
#endif
		perror("sample");
		exit(-1);
	}
	gs = cyread((GSPEC *)0, fd);
	printf("name: %.40s\n", gs->name);
	for (lg = gs->lgmin; lg <= gs->lgmax; ++lg) {
		for (lt = gs->lgmin; lt <= gs->ltmax; ++lt) {
			radius = GETR(gs, lt, lg);
			if (radius != VOID) {	/* never operate on VOIDs !!*/
				radius = (radius * scale + 50L) / 100L;
				PUTR(gs, lt, lg, radius);
			}
		}
	}
	cywrite(gs, fd);
	cyfree(gs);
	close(fd);
}
