/*
# proc: build_pi_lists - builds lists of phrase indices referencing segmented
# proc:                  characters sorted into reading order based on
# proc:                  segmentor statistics.
*/

#include <stdio.h>

#define A_LIMIT      300.0
#define PA1            0.375
#define A1            12.0
#define B1             0.1
#define PA2            4.7
#define A2           150.0
#define B2             2.0
#define PREV_MEAN_FACTOR  1.0
#define MEAN_FACTOR    0.25
#define SLOPE_THRESH   0.25
#define MRG_FACTOR     0.75
#define MRG2_FACTOR     0.50
#define RUN_FACTOR     0.1

/*************************************************************/
build_pi_lists(pi_lists, pi_lens, nphrases, xs, ys, ws, hs, n)
int *pi_lists[], *pi_lens;
int *nphrases;
int *xs, *ys, *ws, *hs;
int n;
{
   float hmean, compute_mean();
   int *mxs, *mys;

   if((mxs = (int *)calloc(n, sizeof(int))) == NULL)
      syserr("build_pi_lists", "calloc", "mxs");
   if((mys = (int *)calloc(n, sizeof(int))) == NULL)
      syserr("build_pi_lists", "calloc", "mys");
   compute_mxs_mys(xs, ys, ws, hs, mxs, mys, n);

   *nphrases = 0;
   hmean = compute_mean(hs, n);
   find_pi_lists(pi_lists, pi_lens, nphrases,
                 hmean, PREV_MEAN_FACTOR, MEAN_FACTOR, SLOPE_THRESH,
                 mxs, mys, n, PA1, B1, PA2, B2, A1, A_LIMIT);
   merge_pi_lists(pi_lists, pi_lens, nphrases, mxs, mys, n, hmean,
                 MRG_FACTOR, MRG2_FACTOR, RUN_FACTOR);
   sort_pi_lists_on_y(pi_lists, pi_lens, *nphrases, mys, n);
   free(mxs);
   free(mys);
}
