/*
# proc: current_pi_list - determines if the next blob should be added to the
# proc:                   current phrase index list or be added to a new
# proc:                   phrase index list.
*/

#include <defs.h>

/***************************************************************************/
current_pi_list(na, nb, near_i, curdelta, px, py, 
               prevx, prevy, prevdelta, prevflag, succlimit, 
               pi_lists, pi_lens, nphrases,
               hmean, meanfactor, slopethresh,
               pis, mxs, mys, end, abm, a1, b1, abegin, alimit, ylimit)
float na, nb;
int *pi_lists[], *pi_lens;
int *nphrases;
int near_i, *px, *py, *prevx, *prevy, *prevflag, *pis, *mxs, *mys, *end;
float curdelta, *prevdelta, succlimit, abm, a1, b1;
float hmean, meanfactor, slopethresh, abegin, alimit, ylimit;
{
   int pi;

   if(too_big((*prevdelta), curdelta, succlimit)){
      new_pi_list(&pi, px, py, prevdelta, prevflag,
                  pi_lists, pi_lens, nphrases,
                  pis, mxs, mys, end, abm, a1, b1,
                  abegin, alimit, ylimit);
      (*prevdelta) = 0.0;
      (*prevflag) = FALSE;
   }
   else{
      process_nearest_pi(near_i, px, py, prevx, prevy, prevflag,
                         pi_lists, pi_lens, (*nphrases),
                         hmean, meanfactor, slopethresh,
                         pis, mxs, mys, end);
      (*prevdelta) = curdelta;
   }
}
