/*
# proc: sort_pi_lists_on_y - sorts lists of phrase indices based on the
# proc:                      y coordinate of their first blob's center in
# proc:                      ascending order.
# proc: sort_pi_list_on_x - sorts the elements of a list of phrase indices
# proc:                     based on the x coordinate of each blob's center in
# proc:                     ascending order.
# proc: sort_pi_lists_by_length - sorts lists of phrase indices based on the
# proc:                           number of elements (blobs) in each list in
# proc:                           decending order.
*/

#include <stdio.h>
#include <maxlist.h>

/***************************************************************************/
sort_pi_lists_on_y(pi_lists, pi_lens, nphrases, mys, n)
int *pi_lists[], *pi_lens;
int nphrases, *mys, n;
{
   int i;
   int *tlists[MAX_INDEX], tlens[MAX_INDEX], pi_mys[MAX_INDEX], *pi_list;
   int *spis, *sort_index_on_int();

   if(nphrases > MAX_INDEX)
      fatalerr("sort_pi_lists_on_y", "# of phrases exceeds MAX_INDEX", NULL);

   memcpy(tlens, pi_lens, nphrases * sizeof(int));
   for(i = 0; i < nphrases; i++){
      pi_list = pi_lists[i];
      tlists[i] = pi_list;
      pi_mys[i] = mys[pi_list[0]];
   }

   spis = sort_index_on_int(pi_mys, nphrases);
   for(i = 0; i < nphrases; i++){
      pi_lists[i] = tlists[spis[i]];
      pi_lens[i] = tlens[spis[i]];
   }

   free(spis);
}

/***************************************************************************/
sort_pi_list_on_x(pi_list, pi_len, mxs, n)
int *pi_list, pi_len;
int *mxs, n;
{
   int i, *spis, *sort_index_on_int();
   int tlist[MAX_INDEX], pi_mxs[MAX_INDEX];

   if(pi_len > MAX_INDEX)
      fatalerr("sort_pi_list_on_x",
               "length of phrase exceeds MAX_INDEX", NULL);

   for(i = 0; i < pi_len; i++)
      pi_mxs[i] = mxs[pi_list[i]];

   memcpy(tlist, pi_list, pi_len * sizeof(int));

   spis = sort_index_on_int(pi_mxs, pi_len);

   for(i = 0; i < pi_len; i++){
      pi_list[i] = tlist[spis[i]];
   }
   free(spis);
}

/***************************************************************************/
sort_pi_lists_by_length(pi_lists, pi_lens, nphrases)
int *pi_lists[], *pi_lens;
int nphrases;
{
   int i;
   int *tlists[MAX_INDEX], tlens[MAX_INDEX], *pi_list;
   int *spis, *sort_index_dec_on_int();

   if(nphrases > MAX_INDEX)
      fatalerr("sort_pi_lists_by_length",
               "# of phrases exceeds MAX_INDEX", NULL);

   memcpy(tlens, pi_lens, nphrases * sizeof(int));
   for(i = 0; i < nphrases; i++){
      pi_list = pi_lists[i];
      tlists[i] = pi_list;
   }

   spis = sort_index_dec_on_int(pi_lens, nphrases);
   for(i = 0; i < nphrases; i++){
      pi_lists[i] = tlists[spis[i]];
      pi_lens[i] = tlens[spis[i]];
   }

   free(spis);
}
