#include <forms.h>
#include <malloc.h>
#include <gl/gl.h>
#include <gl/device.h>
#include <math.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

/*#include "muscles.h" */
#include "IPC.h"
#include "lights.h"
#include "standard.h"
#include "master_fl.h"
#include "proto.h" 

static float 	*perm_face;		
static float	*face;		/* The actual vertex values of face points*/
static int	*tconn;		/* Triangular COnnections */
static int	*qconn;		/* Quadralteral connections */
static int	*llip_indx;	/* List of points in lower lip */
static int	*ulip_indx;	/* List of points in upper lip */
static int	*jaw_indx;	/* List of points in jaw */
static int 	*nrml_indx;	/* normal vectors to calc normals from */
static float	*face_nrmls;	/* the actual normal vectors */
static float	*tex_coor;	/* Mapping table for texture map */
static eye_info	iball;
static Object	eye;		/* the GL object ID for the eye */
static long	fgid,mgid;	/* face and muscle chart window IDs */	
static	float 	*sk_pnts;
static	int 	*sk_conn;
static struct	muscle musc[NUM_MUSCLES];
static struct 	sphinctor mouth_sphin;
static param_vals	param[NUM_PARMS];	
static	packet_format	data_pak;


/** !!! gfx_info minfo is the ONLY global variable, the rest are confined
  to alone.c **/


gfx_info  minfo;


main()
{

    int		face_size;
    int		i;





    mallopt(M_DEBUG,TRUE);	/* turn on malloc debugging,
				   this slows down alot */
   

    foreground();		/* bind to window for debugging */
    create_the_forms();		/* Initialize Forms */

      
    face = 	load_face_coor("New-Data/Face");
    tconn = 	load_face_tconn("New-Data/Face");
    qconn = 	load_face_qconn("New-Data/Face");

    setup_muscles("New-Data/Muscle.indx", musc,face);
    init_muscles(face,musc);				
    init_sphinctor(&mouth_sphin);
    init_params(param);

    jaw_indx  = load_jaw("New-Data/Jaw.indx");
    ulip_indx = load_lips("New-Data/ULip.indx");
    llip_indx = load_lips("New-Data/LLip.indx");
    nrml_indx = assign_normals(face[0],qconn);
    face_nrmls= (float *) malloc(sizeof(float) * (face[0]+1) * 3);
    
    
    iball.pupil = 0.30;         	/* pupil size */
    iball.iris  = 0.40;         	/* iris size */
    iball.xpos	= 0.71 	* 	3.0;
    iball.ypos	= 0.92	*	3.0;
    iball.zpos	= 0.6475	*	10.0;
    iball.xrot	= 0.00;
    iball.yrot  = 0.00;
    iball.dist	= 0.83	*	5.0;
    iball.size	= 0.5	*	2.0;
    eye = 	make_eye_object(iball);

    
    minfo.light = 	FALSE;
    minfo.movie = 	FALSE;
    minfo.texture=	FALSE;
    minfo.disp_musc= 	FALSE;


    for (i=0;i<NUM_PARMS;i++)
      data_pak.param[i]=0.0;

    /* Make A Copy of Facial Position while it is at"rest" */
    face_size = (face[0]*3+1) * sizeof(float);
    perm_face = (float *) malloc(face_size);
    bcopy(face,perm_face,face_size);	

    fgid      = init_face_win();	/* Open a Window For the Face */
    init_gl_env();			/* Do misc. GL setup */
   


    load_texture(1,"New-Data/Face");
    tex_coor = bind_texture_coor(face,"New-Data/Face");

    fl_set_form_position(cntrl_menu,10,-1);
    fl_show_form(cntrl_menu,FL_PLACE_POSITION,TRUE,"Renderer");
    

    fl_qdevice(MIDDLEMOUSE);	/* for selecting vertexes */
    fl_qdevice(LEFTMOUSE);	/* switching  polymode to PYM_FILL */
    fl_qdevice(RIGHTMOUSE);	/* switching  polymode to PYM_LINE */
    queue_keypad();
    event_loop();
    redraw_face(); 
    bcopy(perm_face,face,face_size);    

    while(1)
      event_loop();
}



/*** event_loop() ***/
void	event_loop()
{
    short 	int	val;
    register 	long	dev;
    long		curr_win;
    FL_OBJECT		*obj;
    
    while ((obj=fl_do_forms()) !=0) {
	if (obj!=FL_EVENT) {
	    printf("Strange Object returned %d \n",obj);
	}
	if (obj==FL_EVENT) {
	    dev = fl_qread(&val);
	    if (dev == INPUTCHANGE) 	{
		curr_win = val; 
	    }
	    else if (dev == REDRAW) {
		winset(val);
		reshapeviewport();
		redraw_face(); 
		if (mgid >0 ) {
		    draw_msc_chart(mgid,musc);
		    winset(fgid);
		}
	    }	    
	    
	    else if ((dev == MIDDLEMOUSE) &&(val==1) &&(curr_win==fgid)) {
		winset(fgid);
		select_vertex(fgid,face,sk_pnts);
	    }
	    
	    else if ((dev == LEFTMOUSE) &&(val==1) &&(curr_win==fgid)) {
		winset(fgid); polymode(PYM_LINE);
		linewidth(1);
		redraw_face();
	    }
	    
	    else if ((dev == RIGHTMOUSE) &&(val==1) &&(curr_win==fgid)) {
		winset(fgid); polymode(PYM_FILL);
		redraw_face();
	    }
	    else if( keypad_event(dev,val)==TRUE) {
	    }
	    
	    else {
		/* 
	      printf("Unkown Event:  %d  - %d \n",dev,val);
	      */
	    }

	} /* obj==FL_EVENT */		
	
    }		
}


/*** monitor_loop() - monitor the socket and animate based on input ***/    
void monitor_loop(FL_OBJECT *a,long b)
{
    /** The priority is checking the communcation socket, however
       after every frame is rendered the FORMS gui is checked to
       see if the user wants to change any parameters **/

     
    fd_set		tmp_mask,mask;
    int			nfound,frame;
    int			nfds;
    int			st,skt;
    struct timeval	timeout;
    

    skt= setup_server_IPC();
    printf("Server/Client Connection Complete (%d)... \n",skt);

#define TO_SEC 0
#define TO_USEC 8500

    FD_ZERO(&mask);
    FD_SET(skt,&mask);
    nfds = skt+1;
    

    nfound = 666;
    printf("Monitor Loop skt = %d \n",skt);
    while (1) { 
	/* Wait up to 1/2 for new frameinfo on Unix Socket */
	timeout.tv_sec = TO_SEC;		
	timeout.tv_usec= TO_USEC;
	tmp_mask = mask;
	nfound = select(nfds,&tmp_mask,(fd_set *)NULL,(fd_set *)NULL,&timeout);
	
	if (nfound !=0) {	/* If there was any data, animate it */
	    st=receive_data_packet(skt,&data_pak,sizeof(packet_format));
	    if (st==NULL)	{ /* connection closed */
		printf("Internet Socket Connection Closed \n");
		close(skt);
		break;
	    }

	    
	    iball.xrot = (data_pak.param[I_XDIR]-0.5)*600; 
	    iball.yrot = (data_pak.param[I_YDIR]-0.5)*900;
	    minfo.xrot  = (data_pak.param[XROT]-0.5)*600;
	    minfo.yrot  = (data_pak.param[YROT]-0.5)*900;
	    
	    /* need a special signal to know when to regenrate the
	       eye object for different iris/pupil size */
	    
	    redraw_face();
	}
	else if (nfound == -1) {
	    perror("select error");
	    printf("errno = %d -- %s \n",errno,strerror(errno));
	    printf("oserrornum %d \n",oserror());
	}
	else {  /* a timeout has occured */	
	}
    }
}



/*** play_file() - read muscle controls from a disk file ***/    
void play_file(FL_OBJECT *a,long b)
{
    /** The priority is checking the communcation socket, however
       after every frame is rendered the FORMS gui is checked to
       see if the user wants to change any parameters **/

 
    static	char	dir[30];
    char	*file_path;
    struct timeval	new_time,old_time;
    struct timezone	time_zone;
    float		delta_time;
    register unsigned int	frame,st;
    
    FILE 		*skt;


    file_path=fl_show_file_selector("Select Script Data File",dir,"*.scrpt","");
 
    if (file_path== NULL) {
	printf("Play File Canceled \n");
	return;
    }

    sprintf(dir,"%s",fl_get_directory());
    
    printf("Opening up disk file for reading\n");
    if ((int)(skt = open_disk_read(file_path))== -1)
      return;
    
    gettimeofday(&old_time,&time_zone);
    frame = 0 ; 
    st =1;
    while (st>0) { 
	
	st=receive_disk_packet((int)skt,&data_pak,sizeof(packet_format));
	frame++;
	
	iball.xrot = (data_pak.param[I_XDIR]-0.5)*600; 
	iball.yrot = (data_pak.param[I_YDIR]-0.5)*900;
	minfo.xrot  = (data_pak.param[XROT]-0.5)*600;
	minfo.yrot  = (data_pak.param[YROT]-0.5)*900;
	
	redraw_face();
	
	
    }
    gettimeofday(&new_time,&time_zone);
    delta_time = (float)((new_time.tv_sec -old_time.tv_sec)+
			 ((new_time.tv_usec-old_time.tv_usec)
			  /1000000.0));
    
    printf("%d Frames rendered in %5.4f seconds \n",frame,delta_time); 
    printf("Frame Rate = %5.4f \n",frame/delta_time);

    fclose((FILE *)skt);
}


/*** redraw_face - recalculate face position and refresh display ***/
void redraw_face()
{
    register int	i;

    bcopy(perm_face,face,(int)((face[0]*3+1)*sizeof(float)));
    rot_jaw(face,jaw_indx,(data_pak.param[JAW] * param[JAW].scale));
    
    lip_sep(face,llip_indx,ulip_indx,
	    (data_pak.param[LIP_Y]*param[LIP_Y].scale),
	    (data_pak.param[LIP_Z]*param[LIP_Z].scale));
   

    /*printf("musc[2] = %d  &musc[2] = %d \n",musc[2],&musc[2]);
*/
    for (i=0;i<14;i ++)		/* The 14 main 3-Dimensional Muscles */
      if (data_pak.param[i] !=0)
	pull3d(face,(musc[i]),(data_pak.param[i]*param[i].scale));

/*
    printf("Left Front = %5.4f \n", data_pak.param[ML_FRONT]);
    printf("Right Front = %5.4f \n", data_pak.param[MR_FRONT]);
  */  
   if (data_pak.param[ML_FRONT] != 0)
      pull1d(face,musc[14],(data_pak.param[ML_FRONT]*param[ML_FRONT].scale));
     
    if (data_pak.param[MR_FRONT]!= 0)
      pull1d(face,musc[15],(data_pak.param[MR_FRONT]*param[MR_FRONT].scale));
      

    /*sphincter(face,data_pak.param[KISS]);
      parameters aren't matched up yet 
      This data parameter isn;'t defined yet!*/

    refresh_face((FL_OBJECT *)NULL,(long) NULL);

}



void refresh_face(FL_OBJECT *obj,long val)
{
   
    plot_face(fgid,face,qconn,tconn,nrml_indx,face_nrmls,tex_coor);
    plot_eyes(iball,eye);
/*    display_skull(fgid,sk_pnts,sk_conn); 
  */
    if (minfo.disp_musc) 
      plot_dynamic_muscles(fgid,face,musc);
       
    swapbuffers();
   
    if (minfo.movie) {
	winset(fgid);
	savemovieframe();	/* add a frame rate variable */
 	printf("Done Saving Frame \n");  
	 }
}




/*** void exit_session(FL_OBJECT *,long) ***/
void	exit_session(FL_OBJECT *a,long b)
{
    printf("Exiting Gracefully..\n");
    printf("Closing IPC Port \n");
    close_server_IPC();
    exit(0);
}


/*** void option_param(FL_OBJECT *,long) ***/
void	option_param(FL_OBJECT *obj, long val)
{

    int	new_val;
/* Note: The new method of binding texture and lighting only
       when changed might screw things up for other debugging graphics!*/
    new_val = fl_get_button(obj);
    switch ((int)val) {
      case 1:
	minfo.movie = new_val;
	break;

      case 2:
	winset(fgid);
	minfo.texture = new_val;
	break;

      case 3:
	winset(fgid);
	minfo.light = new_val;
	break;

      case 5:			/* show muscle position */
	printf("Toggling Muscle Position \n");
	minfo.disp_musc = new_val;
	break;
    }
    refresh_face(NULL,NULL);
}



void	show_form(FL_OBJECT *obj,long val)
{
    int	new_val;
    new_val = fl_get_button(obj);	/* is is on or off now ? */

    if (new_val ==1) { /* Turn on/show the form */
	switch ((int) val) {
	  case 1:
	printf("show_form::Showing Muscle Chart \n");
	    mgid = init_msc_chart(musc);
	    winset(fgid);
	    break;
	    
	  case 2:
	    break;
	    
	  case 3:

	    break;
	    
	    
	}
    }

    if (new_val==0) { /* turn off or hide the form */
	
	switch ((int) val) {
	  case 1:
	    winclose(mgid);
	    mgid = -3 ;
	    break;
	    
	  case 2:

	    break;
	    
	  case 3:

	    break;
	}
    }

}












