/******
  
  graphics.c: These are *most* of the graphics, written on a SGI Iris vgx
    The texture mapping can be disabled, it doesn't use alpha or any
    other special things besides TMAPs.

    This certainly isn't the most efficient code, but I use quads and triagles
    here becuase another program *has* to use them and its easier keeping
    the code the same. You could speed it up some ....


This code was written with time and equipment provided by Sony Computer
Science Lab. It is freely distributable for research purposes. 

It is hoped making this available will facilitate research on facial
animation. If you make significant changes/extensions to this, or have
a different system I would appreciate hearing about it.


The latest versions of this and other animation systems are
available by anonymous FTP from:
     
        scslwide.sony.co.jp
	ftp2/SGI/Facial-Animation

  Copyright 1992	

  Written:	Steve Franks
                Sony Computer Science Labs
		Tokyo, Japan	
		Febuary 1992
		stevef@csl.sony.co.jp


*******/


#define LOOKIE  \
  window(P_WINXS,P_WINXE,P_WINYS,P_WINYE,P_WINZS,P_WINZE); \
	translate(0,0,-35); 	/* to move along z-axis */ \
  lookat(minfo.vx,minfo.vy,minfo.vz,minfo.px,minfo.py,minfo.pz,minfo.twist);\
 scale(2.0,2.0,2.0)


#include <limits.h>
#include <gl/gl.h>
#include <gl/sphere.h>
#include <fmclient.h>
#include <sys/types.h>
#include <malloc.h>
#include <math.h>
#include <stdio.h>
#include <forms.h>
#include "lights.h"
#include "muscles.h"
#include "standard.h"
#include "proto.h"

#define c_white 0xFFFFFF

extern gfx_info	minfo;


/*** init_face_win() ***/
long init_face_win()
{
    long gid;
   
    keepaspect(1,1); /* */
   /* prefsize(646,486); /* NTSC Size/scale  */	

    gid = winopen("Face Skin");

    clear();
    zclear();
    return(gid);
}


/*** init_gl_env() ***/
void init_gl_env() 
{
    
    printf("Init_gl_env() called \n");
    polymode(PYM_FILL); 	
    RGBmode();
    mmode(MVIEWING);	
    nmode(NNORMALIZE);		/* normalize normals automatically */
    zbuffer(TRUE);
    backface(TRUE);	 	 /* elimnate backfacing polygons */
    concave(FALSE);	  	/* concave polygons (I think not but...) */
    shademodel(GOURAUD); 	/* (GOURAUD);	*/
    drawmode(NORMALDRAW);

 /*   swapinterval(2);		/* for constant frame  advancement, */
    subpixel(TRUE);		/* Does this slow things down ?*/
    doublebuffer(); 			/* */
			  
    linewidth(1);
    gconfig();

    lmdef(DEFMATERIAL, MYSKIN,0,mat);     /* Data from lights.h */
    lmdef(DEFMATERIAL, SKIN,0,flesh);
    lmdef(DEFMATERIAL, BSKIN,0,mat3);
    lmdef(DEFMATERIAL, 4,0,mat4);
    lmdef(DEFMATERIAL, IRIS_MAT,0,iris);
    lmdef(DEFMATERIAL, PUPIL_MAT,0,pupil);
    lmdef(DEFMATERIAL, EYEW_MAT,0,eyewhite);
    lmdef(DEFMATERIAL, JAW_MAT,0,beard);
    lmdef(DEFMATERIAL, WHITE_MAT,0,white_mat);
    lmdef(DEFLIGHT,1,0,lt);
    lmdef(DEFLMODEL,1,0,lm);
    
    ortho(-1,1,-1,1,-1,1);	/* make a unit cube for lighting coords */
    lmdef(DEFLMODEL,1,0,lm); 	/* one sided lighting model */
    lmdef(DEFLMODEL,2,0,lm2);	/* two sided lighting model */
    lmbind(LIGHT0, 1);
    lmbind(LMODEL,1);		/* Use the one sided Lighting Model */
/*    lmbind(LMODEL,2);		/* Use the two sided model */

    sphmode(SPH_DEPTH,3);	/* 2levels for faster spheres */
    gconfig();
}   


/*** plot_face() ***/
void plot_face(long gid,float *face,int *q_conn,int *t_conn,int *nrml_indx,
	       float *nrmls,float *tex_coor)
{
    
    int		npoly,conn_indx,i;
    int		tn,qn,vtx[5];
    float	res_nrml[3];
    char	info[30];
    static	int frame=0;
  
    frame++;
    winset(gid);
    cpack(0x6b6d17);
    zclear();
    clear();

    pushmatrix();   
    LOOKIE;

    rotate(minfo.xrot,'x');
    rotate(minfo.yrot,'y');

    if (minfo.light) {
	calc_face_normals(face,nrml_indx,nrmls);
	lmbind(MATERIAL,MYSKIN);	/* The front of skin looks like */
    }
    if (minfo.texture) {
	cpack(0xFFFFFF);
	texbind(TX_TEXTURE_0,FACE_TXT	);
    }


    for (qn=1;qn<=q_conn[0]; qn++ ) {
	vtx[1] =  q_conn[qn*4-3];
	vtx[2] =  q_conn[qn*4-2];
	vtx[3] =  q_conn[qn*4-1];
	vtx[4] =  q_conn[qn*4  ];

	bgnpolygon();
	for (i=1;i<=4;i++) { 
	    if (minfo.light){ 
		n3f(&nrmls[(vtx[i]-1)*3]); 
	    } 
	    if (minfo.texture) {
		t2f(&tex_coor[(vtx[i]-1)*2]); 
	    }

	    v3f(&face[vtx[i]*3-2]);
	}
	endpolygon();
    }

     /* Now plot all the triangles to fill in the blank spaces */
    for (tn=1;tn<=t_conn[0] ; tn++ ) {
	vtx[1] =  t_conn[tn*3-2];
	vtx[2] =  t_conn[tn*3-1];
	vtx[3] =  t_conn[tn*3  ];
	
	bgntmesh(); 
	for (i=1;i<=3;i++) {
	    if (minfo.light) { 
		n3f(&nrmls[(vtx[i]-1)*3]); 
	    }
	    
	    if (minfo.texture) {
		t2f(&tex_coor[(vtx[i]-1)*2]);
	    }
	    
	    v3f(&face[vtx[i]*3-2]);
	}
	endtmesh();
    }
    /* I am not sure which is faster */
	texbind(TX_TEXTURE_0,0	);
/*	  tevbind(TV_ENV0,0);		/* turn off texture mapping */

popmatrix();
}




/** Maybe use a libblas library routine for better speed ! **/
void cross_product(float *face,int i,int j,int k,float *dest)
{
    float	v[3],w[3];
    int	vtx1,vtx2,vtx3;
   
    /* These vertexes are in the conn space [1...N] */
    /* optmize this alot ! feb swf */

#define XC *3-2
#define YC *3-1
#define ZC *3

    v[0] = face[i XC ] - face[j XC];
    v[1] = face[i YC ] - face[j YC];
    v[2] = face[i ZC ] - face[j ZC];
    
    w[0] = face[i XC]-	face[k XC];
    w[1] = face[i YC]-	face[k YC];
    w[2] = face[i ZC]-	face[k ZC];
    
    dest[0] = v[1]*w[2] - v[2]*w[1];
    dest[1] = v[2]*w[0] - v[0]*w[2];
    dest[2] = v[0]*w[1] - v[1]*w[0];
  /*
	if (dest[2] <0.0) {
	dest[0]= -(dest[0]);
	dest[1]= -(dest[1]);
	dest[2]= -(dest[2]);
}
*/ 
}


/*** assign_normals tells HOW to calculate normal for each vertex ***/
int *assign_normals(int num_pnts,int *q_conn)
{

    /* this might be messed up because of the 0/1 thing */
    int	*nrml_indx;
    int	i,j,npts;
    int 	*test;

    /* This assumes that the wuads have already been ordered
       in LL LR UR UL order */

    /* This assigns for the quadralaterals...also *should* check for triangles
       with no normals and assign somethign */

    npts = num_pnts; 
    nrml_indx = (int *) malloc(sizeof(int)*(2*npts+1));
    printf("Assinging normals to %d points \n",num_pnts);

    for (i=1;i<=npts;i++) {
	nrml_indx[i*2-1] = 666;
	nrml_indx[i*2]   = 666;
    }

    
    /* First add normal to LL corners only LR (.)UL */
    for (i=1; i<=q_conn[0]; i++) 	{ /* for all quads */
	if (q_conn[i*4-3] > npts) {
	    printf("ERROR - Quad # %d , Index: %d \n",i,q_conn[i*4-3]);
	}
	nrml_indx[q_conn[i*4-3]*2-1] = q_conn[i*4-2];	
	nrml_indx[q_conn[i*4-3]*2]   = q_conn[i*4]; 
    }

    /* Now add to UR corners which aren't LL of another quad */
    /* UR = UL (.) LR */
    for (i=1; i<=q_conn[0]; i++) 	{
	if (nrml_indx[q_conn[i*4-1]*2-1] == 666) {
	    nrml_indx[q_conn[i*4-1]*2-1] = q_conn[i*4];	
	    nrml_indx[q_conn[i*4-1]*2]   = q_conn[i*4-2]; 
	}  
    }

    /* Now add for Lower Right Corners */
    for (i=1; i<=q_conn[0]; i++) 	{
	  if (nrml_indx[q_conn[i*4-2]*2-1] == 666) {
	      nrml_indx[q_conn[i*4-2]*2-1] = q_conn[i*4-1];	
	      nrml_indx[q_conn[i*4-2]*2]   = q_conn[i*4-3]; 
	  }  
      }

    /* Now add for Upper Left Corners */
    for (i=1; i<=q_conn[0]; i++) 	{
	  if (nrml_indx[q_conn[i*4]*2-1] == 666) {
	      nrml_indx[q_conn[i*4]*2-1] = q_conn[i*4-3];	
	      nrml_indx[q_conn[i*4]*2]   = q_conn[i*4-1]; 
	  }  
      }

    printf("Done Assigning Normals \n");
    return(nrml_indx);
}


/*** long init_msc_chart(struct muscle *) ***/
long init_msc_chart(struct muscle *musc)
{
    long gid;
    
    /* Open the Muscle Line Window in the Upper Left */
    prefposition(220,600,580,1000);
    gid = winopen("Muscle Menu");
    doublebuffer();
    RGBmode();	 
    gconfig();
    draw_msc_chart(gid,musc);
    return(gid);
    
}


/*** void draw_msc_chart(long,struct muscle *) ***/
void draw_msc_chart(long gid,struct muscle *musc)
{
    
    float       inc, pnt1[3], pnt2[3];
    int x,y,i;

    
    
    printf("Plotting Muscle Chart info in %d \n",gid);
    winset(gid);
    pushattributes();
    ortho(-10,100,-10,100,-10,100);
    RGBmode();
    linewidth(3);
    gconfig();
    cpack(0x222222);
    clear();
    zclear();
    
    pnt1[0] = 0;
    pnt1[1] = 98;
    pnt1[2] = 0;
    
    pnt2[0] = pnt1[0] + 30;
    pnt2[1] = pnt1[1];
    pnt2[2] = 0;
    
    inc = -7;
    /*    fmsetfont(menu_font);  FIX THIS */
    printf("Plotting circles and lines for mmenu \n");
    for (i=0; i<14; i++) {
	loadname(i);
	pnt1[1] += inc;
	pnt2[1] += inc;
	cpack(musc[i].color);
	bgnline();
	v3f(pnt1);
	v3f(pnt2);
	endline();
	cpack(c_white);
	circf(pnt1[0],pnt1[1],2);
	circf(pnt2[0],pnt2[1],2);
	
	cpack(musc[i].color);
	cmov2i(pnt2[0]+5,pnt2[1]);
	fmprstr((char *) musc[i].title);
	
    }
    popattributes();
    swapbuffers();
}



/*** plot_dynamic_muscles() ***/
void plot_dynamic_muscles(long gid,float *face,struct muscle *musc) 
{


    float 	circ_param[4];
    int 	indx,i;
   
    winset(gid);
    pushmatrix();
    pushattributes();
    LOOKIE;
    rotate(minfo.xrot,'x');
    rotate(minfo.yrot,'y');

    linewidth(4);
    circ_param[3] = .25;	/* SphereRadius */
       
    lmbind(MATERIAL,0);
    /** a a loop to draw muscle lines **/
    for (i=0; i<14; i++) {
	if (musc[i].start_vrtx != -666) {
	    cpack(musc[i].color);
	    bgnline();
	    indx = musc[i].start_vrtx;
	    indx = (indx-1)*3+1;
	    v3f(&face[indx]);
	    
	    indx = musc[i].end_vrtx;
	    indx = (indx-1)*3+1;
	    v3f(&face[indx]);
	    
	    endline();
	}
    }
    popattributes();
    popmatrix();
}



/*** plot_eyes() -- later let eyes point in different directions ***/
void    plot_eyes(eye_info iball,Object eye)
{
    
    
   
    pushmatrix();
 
    LOOKIE;

    rotate(minfo.xrot,'x');
    rotate(minfo.yrot,'y');

 
    pushmatrix();
    translate(iball.xpos,iball.ypos,iball.zpos);
    rotate(iball.yrot,'x');
    rotate(iball.xrot,'y'); 
    
   
    scale(iball.size,iball.size,iball.size);
    callobj(eye);
    popmatrix();
    
    translate(iball.xpos-iball.dist,iball.ypos,iball.zpos);
    rotate(iball.yrot,'x');
    rotate(iball.xrot,'y');
    scale(iball.size,iball.size,iball.size);
    callobj(eye);
 
    popmatrix();
    return;
}



/*** void calc_face_normals(float *,int *,float *
  -- calculate all the normals for the face ***/
void calc_face_normals(float *face,int *nrml_indx, float *nrmls)

{
    int		indx,pnt;
 

    /* First Compute all the normals once for this facial position */
    indx = 0;
    for (pnt=1;pnt<=face[0]; pnt++) { /* do for all face points */
	cross_product(face,pnt,nrml_indx[pnt*2-1],
		      nrml_indx[pnt*2],&nrmls[indx]);
	indx+=3;		
    }


}




/*** void plot_face_normals(long, float *,float *) ***/
void plot_face_normals(long gid,float *face,int *nrml_indx,float *nrmls)
{
    
    int		qn,i;
    float	ball[4];
    char	info[30];

    calc_face_normals(face,nrml_indx,nrmls);
    winset(gid);
    
    for (qn=1;qn<=face[0]; qn++ ) {
	ball[0] = face[qn*3-2] + nrmls[qn*3-3] ;
	ball[1] = face[qn*3-1] + nrmls[qn*3-2];
	ball[2] = face[qn*3  ] + nrmls[qn*3-1];
	
/* only plot 1/2 the face */
	if ((face[qn*3-2] <=0.0) ){ 
	    bgnline();
	    cpack(0xFFFFFF);
	    v3f(&face[qn*3-2]);
	    cpack(0x00FF00); 
	    v3f(&ball[0]);
	    endline();
	    
	}	
	
/* only plot 1/2 the face */
	if ( (face[qn*3-2]>=0.0)){ 
	    bgnline();
	    cpack(0xFFFFFF);
	    v3f(&face[qn*3-2]);
	   cpack(0x00FF00);
	    v3f(&ball[0]);
	    endline();
	    
	}	
	
    }
    popmatrix();
}

/*** void display_skull(long,float *pnts,int *conn) ***/
void display_skull(long fgid,float *skull_pnts,int *skull_conn)
{

    int	pntr,i;
return;
    printf("Displaying skull\n\n");
    winset(fgid);
    cpack(0x0000FF);
   
    
    /** OK - now loaded so plot them **/
    
    pushmatrix();
    LOOKIE;		/* align with rest of the head */
    
    pntr = 1;
    for (i=0;i<skull_conn[0]; i++) {
	
	bgnpolygon();	/* for now don't worry about making a mesh */
	v3f(&skull_pnts[skull_conn[pntr]*3-2]);
	pntr++;
	v3f(&skull_pnts[skull_conn[pntr]*3-2]);
	pntr++;
	v3f(&skull_pnts[skull_conn[pntr]*3-2]);
	pntr++;
	v3f(&skull_pnts[skull_conn[pntr]*3-2]);
	pntr++;
	endpolygon();
	
    }
    popmatrix();

}








