/****************************************************************************\
*                                                                            *
*  THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE  *
*     WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR     *
*   PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.   *
*                                                                            *
*     In no event will the supplier be liable for any lost revenue           *
*   or profits or other special, indirect and consequential damages, even    *
*    if the supplier has been advised of the possibility of such damages.    *
*                                                                            *
*             Users may copy or modify this file without charge,             *
*       but are NOT authorized to license or sell it to anyone.              *
*                                                                            *
\****************************************************************************/

/****************************************************************************\
*                                                                            *
*    If you modify this software, you should include a notice giving the     *
* name of the person performing the modification, the date of modification,  *
* and the reason for such modification.  Bug reports or fixes should be sent *
*        to the author, who may or may not act on them as he desires:        *
*                                                                            *
* Internet: raytrace@cutmcvax.cs.curtin.edu.au                               *
*                                                                            *
* Mail   : School of Computer Science         | Tel: 619 351 7680            *
*          Curtin University of Technology    | Fax: 619 351 2819            *
*          Kent Street, Bentley                                              *
*          Western Australia, 6102                                           *
*                                                                            *
\****************************************************************************/

/*
 Copyright (c) 1991 Andrew Marriott.
 */

#include <stdio.h>
int wire ;
int forkflg ;			/* Set if not to run in background. */
int displaying;
int axis_required;
int debug;
#ifdef FORMS
int forms_required;
#endif

static void usage()
{
	fprintf(stdout,"interface [-w] [-f] [-F] [-d][-D]\n");
	fprintf(stdout,"  -w : use wire frame.\n");
	fprintf(stdout,"  -f : Window is in foreground.\n");
	fprintf(stdout,"  -F : No forms support - menu only.\n");
	fprintf(stdout,"  -d : No displaying - check only.\n");
	fprintf(stdout,"  -D : Debug info printed out.\n");
	fprintf(stdout,"  -a : Include 3-d axis.\n");
}

static void parse_command_line(argc,argv)
int argc;
char *argv[];
{
	wire=0;
	forkflg=1;
	displaying=1;
	axis_required=0;
	debug=0;
#ifdef FORMS
	forms_required=1;
#endif
	/* Handle arguments. */
	argv++;
	while(*argv && argv[0][0]=='-')
	  switch(argv[0][1])
	  {
/* whatever switches are required and whatever actions for those switches. */
	  case 'a':
		argv++;
		axis_required=1;
	    	break;
	  case 'd':
		argv++;
		displaying=0;
	    	break;
	  case 'D':
		argv++;
		debug=1;
	    	break;
	  case 'f':
		argv++;
		forkflg=0;
	    	break;
#ifdef FORMS
	  case 'F':
		argv++;
		forms_required=0;
		forkflg=0;		/* as well for interaction. */
	    	break;
#endif
	  case 'w':
		argv++;
		wire=1;
	    	break;
	  default:
		usage();
		exit(-1);
		break;
	  }
}

main(argc,argv)
int argc;
char *argv[];
{
	parse_command_line(argc,argv);

	make_face(); /* read data, topology and parameters. */

#ifdef FORMS
	if(forms_required)
	{
		make_form();
		if(displaying)draw_form();
	}
#endif

	if(displaying)draw_face();

	if(displaying)
	{
#ifdef FORMS
		if(forms_required)
			fl_do_forms();		/* Never returns - Uses call_back. */
		else
#endif
			update_pic();		/* Never returns - Uses menu. */
	}

	exit(0);
}
