
/****************************************************************************\
*                                                                            *
*  THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE  *
*     WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR     *
*   PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.   *
*                                                                            *
*     In no event will the supplier be liable for any lost revenue           *
*   or profits or other special, indirect and consequential damages, even    *
*    if the supplier has been advised of the possibility of such damages.    *
*                                                                            *
*             Users may copy or modify this file without charge,             *
*       but are NOT authorized to license or sell it to anyone.              *
*                                                                            *
\****************************************************************************/

/****************************************************************************\
*                                                                            *
*    If you modify this software, you should include a notice giving the     *
* name of the person performing the modification, the date of modification,  *
* and the reason for such modification.  Bug reports or fixes should be sent *
*        to the author, who may or may not act on them as he desires:        *
*                                                                            *
* Internet: raytrace@cutmcvax.cs.curtin.edu.au                               *
*                                                                            *
* Mail   : School of Computer Science         | Tel: 619 351 7680            *
*          Curtin University of Technology    | Fax: 619 351 2819            *
*          Kent Street, Bentley                                              *
*          Western Australia, 6102                                           *
*                                                                            *
\****************************************************************************/

/*
 Copyright (c) Paul Haerbli
 */

#include "gl.h"
#include <stdio.h>
#include "gl/image.h"
#define MIN(a, b)	(((a) < (b)) ? (a) : (b))
#define MAX(a, b)	(((a) > (b)) ? (a) : (b))
#define ABS(a)		(((a) > 0) ? (a) : -(a))

char rbuf[2048];
char gbuf[2048];
char bbuf[2048];
short rs[2048];
short gs[2048];
short bs[2048];


savescreen(name,x1,x2,y1,y2)
char *name;
int x1, x2, y1, y2;
{
    IMAGE *oimage;
    int xsize, ysize;
    int xorg, yorg;
    int temp, y, i;

    xorg = MIN(x1,x2);
    yorg = MIN(y1,y2);
    if(xorg<0)
       xorg = 0;
    if(yorg<0)
       yorg = 0;
    xsize = ABS(x2-x1);
    ysize = ABS(y2-y1);
    if((xorg+xsize)>XMAXSCREEN)
	xsize = XMAXSCREEN-xorg;
    if((yorg+ysize)>YMAXSCREEN)
	ysize = YMAXSCREEN-yorg;
    xsize++;
    ysize++;
    oimage = iopen(name,"w",RLE(1),3,xsize,ysize,3);
    wmplanes();
    screenspace();
    for(y=0; y<ysize; y++) {
	cmov2i(xorg,yorg+y);
	gl_readscreen(xsize,rbuf,gbuf,bbuf);
	ctos(rbuf,rs,xsize);
	ctos(gbuf,gs,xsize);
	ctos(bbuf,bs,xsize);
	putrow(oimage,rs,y,0);
	putrow(oimage,gs,y,1);
	putrow(oimage,bs,y,2);
    }
    iclose(oimage);
}
