/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */


/* Generated by Interface Builder */

#import <appkit/View.h>

extern id NXApp;
@interface EditView:View

{
  id linkObj;           /* Link object it's for */
  id prefObj;
  char mode;

  /*** Enter mode ***/
  id enterCursor, anchorCursor, translateCursor, zoomCursor;
  float lastx, lasty;   /* Point (device coordinates) from which next
			   segment originates.  -1 if it hasn't been
			   clicked out yet */
  BOOL isOut;           /* YES if currently drawing instance lines for ENTER
			   but is now out of the window */
  LinkPointList *currentPnt, *currentEdge;
  LinkList *selectedLnk;

  /*** Select mode ***/
  float origx, origy;   /* Remembered while dragging */

  BOOL isDragging;
}

/* Mode types */
#define SELECT    0
#define ENTER     1
#define FLIP      2
#define ZOOM      3
#define TRANSLATE 4
#define ANCHORM   5

- (BOOL) acceptsFirstResponder;
- resetCursorRects;
- cut:sender;
- hideStrand;
- reverseArrows;
- eraseWindow;
- keyDown:(NXEvent *) event;
- makeNoCurrentPoint;
- setModeSelect;
- (BOOL) isEnterMode;
- setModeEnter;
- unsetModeEnter;
- setModeFlip;
- setModeZoom;
- setModeTranslate;
- setModeAnchor;
/*******  Handling Events ********/
/*** Mouse entering and exiting EditView ***/
- mouseEntered: (NXEvent *) event;
- mouseExited: (NXEvent *) event;

/*** Mouse down ***/
- mouseDown: (NXEvent *) event;
- enterMD:(NXEvent *) event;
- selectMD:(NXEvent *) event;
- flipMD:(NXEvent *) event;
- anchorMD:(NXEvent *) event;
- translateMD:(NXEvent *) event;
- zoomMD:(NXEvent *) event;

/*** Mouse moved or dragged ***/
- mouseMoved: (NXEvent *) event;
- mouseDragged: (NXEvent *) event;
- selectMDr:(NXEvent *) event;
- translateMDr:(NXEvent *) event;
- zoomMDr:(NXEvent *) event;

/*** Mouse up ****/
- mouseUp: (NXEvent *) event;
- selectMU:(NXEvent *) event;
- translateMU:(NXEvent *) event;
- zoomMU:(NXEvent *) event;
- selectMDold:(NXEvent *) event;
- ReDrawLinkTopWindow :(LinkStatus *)gnrc;
- linkDrawLink :(LinkStatus *)gnrc :(LinkList *)lnk;
- linkDrawEdge :(LinkStatus *)gnrc :(LinkList *)lnk :(LinkPointList *)pnt;
- linkDrawPoint :(LinkStatus *)gnrc :(LinkList *)lnk :(LinkPointList *)pnt;
- linkDrawArrow :(LinkStatus *)gnrc :(float) color :(int) x :(int)y :(int)dx :(int)dy;
- clearScreen;
- drawInstanceLine :(float) x1 :(float) y1 :(float) x2 :(float) y2;
- drawLine :(float) x1 :(float) y1 :(float) x2 :(float) y2 :(float) c;
- drawInstanceRec :(float) x :(float) y :(float) w :(float) h;
- drawRectangle :(float) x :(float) y :(float) w :(float) h :(float) c;
- drawSelf: (NXRect *)dRects:(int)dCount;
- fillPolygon :(float) x1 :(float) y1 :(float) x2 :(float) y2
  :(float) x3 :(float) y3 :(float) color;
- fillRectangle :(float) x :(float) y :(float) w :(float) h :(float) c;
- drawAnchor :(float) x :(float) y :(float) size :(float) c;
- setCurrentPoint : (LinkPointList *) pnt fromLink:(LinkList *) lnk;
- getBounds :(double *) w :(double *) h;
- printText: (float) x :(float) y :(char *) s;
- initFrame:(const NXRect *)frameRect;
- flushItsWindow;
- setLink:(id) linkO;
- processBraid: (const char *) name :(int) isClosed;
- (int) get_editMode;

@end
