/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#import <objc/objc.h>
#include "link_types.h"
#include "link_edit_types.h"
#include "link_edit_global.h"
#include "link.h"
#import "EditView.h"
#import "Link.h"

/* This is an abbreviated version of the original LinkInitialize */
void LinkInitialize(id linkObj)
{
  float width,height;
  LinkStatus *gnrc;
  LinkData *data;
  gnrc = [linkObj get_status];
  data = [linkObj get_data];

  gnrc->color_ok = 1;    /* Because I said so.  */

  width =  data->width /* xppmm)*/;
  height = data->height /* yppmm)*/;
  
  
  /* Initialize data */
  gnrc->width = width; gnrc->height = height;

  gnrc->hash_space = LINK_HASH_SPACE * xppmm;
  gnrc->hash_height = LINK_HASH_HEIGHT * yppmm;

  gnrc->axes = LINK_SHOW;
  if(data->xruler == LINK_YES) gnrc->xruler = LINK_SHOW;
  else  gnrc->xruler = LINK_HIDE;
  if(data->yruler == LINK_YES) gnrc->yruler = LINK_SHOW;
  else gnrc->yruler = LINK_HIDE;
  gnrc->vertices = LINK_SHOW;
  gnrc->fth = 0;
  gnrc->arrows = LINK_SHOW;
  gnrc->anchors = LINK_SHOW;

  gnrc->origin.x = data->width/2.0; gnrc->origin.y = data->height/2.0;
  gnrc->origin.dcx = width/2; gnrc->origin.dcy = height/2;

  gnrc->xscale = data->xscale;
  gnrc->yscale = data->yscale;

  gnrc->link.next = NULL;
  gnrc->num = 0;
  gnrc->choice[0] = LINK_NO_CHOICE;
}
