/* automata.d/src file mult.c */
#include <stdio.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "input.h"
#include "lg.h"
# define DIFF2OP ".diff2"
# define WAOP ".wa"
# define MULTOP ".mult"
FILE * rfile=stdin;
FILE * wfile=stdout;


static void mk_Mg PARMS ((gen g, lg * MULT));


lg * WA=0;
lg * DIFF=0;
lg * Mg=0;
extern word * user_gen_name;
extern gen * inv_of;
extern int num_gens;
extern int gen_array_size;

main(argc,argv)
	int argc;
	char * argv[];
{
	int exit_code=0;
	int i;
	gen g;
	lg * MULT;
	char gpname[100];
	char prefix[100];
	char filename[100];
	char generator[100];
	char * label;
	int readfile=0;

	if (argc>2){
		fprintf(stderr,"Usage: wa [gpname]\n");
		exit(2);
	}
	else if (argc==2){
/* the input and output files are being specified as gpname.diff1 and 
gpname.wa respectively */
		strcpy(gpname,argv[1]);
		strcpy(filename,gpname);
		strcat(filename,DIFF2OP);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		readfile=1;
		strcpy(prefix,gpname);
		strcat(prefix,MULTOP);
/* this is the file we're going to put the identity multiplier in */
	}


	setbuf(stdout, (char*)0);
	setbuf(stderr,(char*)0);
	setbuf(wfile,(char*)0);


	label=vzalloc2(char,9);
	while (read_next_string(label,8,rfile) || readfile==1){
		if (strcmp(label,"Format  ")==0)
			format_check("2.2",rfile);
		else if (strcmp(label,"fsa     ")==0){
			if (DIFF==0)
				DIFF=lg_read(GENERIC,BASIC_FSA,rfile);
/* |num_gens| is set now */
			else if (WA==0)
				WA=lg_read(GENERIC,BASIC_FSA,rfile);
		}
		else if (strcmp(label,"inverses")==0)
			read_inverse_array(rfile);
		else if (readfile==1) {
			strcpy(filename,gpname);
			strcat(filename,WAOP);
			if ((rfile=fopen(filename,"r"))==0)
  				{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
			readfile=2;
		}
	}
	Free_dp((dp)label); label=0;
	if (inv_of==0)
		default_inverse_array();
	MULT=fsa_doubleprod(WA,DIFF);

	Mg=vzalloc1(lg);
	lg_init(Mg,GENERIC,BASIC_FSA,(num_gens+1)*(num_gens+1));
	mk_Mg(0,MULT);
	if (rfile!=stdin){
		strcpy(filename,prefix);
		genstring(generator,0);
		strcat(filename,generator);
		wfile=fopen(filename,"w");
		setbuf(wfile,(char*)0);
	}
	fprintf(wfile,"Format 2.2\n");
	if (fsa_is_diag(Mg)==FALSE){
		fprintf(wfile,"\t# M(0) is not diagonal\n");
		exit_code=1;
		lg_print(wfile,Mg);
		lg_clear(Mg);
	}
	else {
		fprintf(wfile,"\t# Multiplier M(0) (diagonal).\n");
		lg_print(wfile,Mg);
		lg_clear(Mg);
		for (g=1;g<=num_gens;g++){
			lg_init(Mg,GENERIC,BASIC_FSA,(num_gens+1)*(num_gens+1));
			if (rfile!=stdin){
				strcpy(filename,prefix);
				genstring(generator,g);
				strcat(filename,generator);
				wfile=fopen(filename,"w");
				setbuf(wfile,(char*)0);
				fprintf(wfile,"Format 2.2\n");
			}
			if (get(basept(WA),g)==UNDEFINED){ 
	/* g is represented by the identity or a lower ordered generator */
				int cat = get_category(get(basept(DIFF),(num_gens+1)*inv(g)));
	/* In its reduced form g should be a word difference, found as the 
	the (inv(g),$) neighbour of the basepoint of DIFF. The category of this 
state tells us what that word difference actually is. */
				fprintf(wfile,"\t# Multiplier for generator ");
				gen_print(wfile,g);
				fprintf(wfile," is equal to the multiplier for ");
				gen_print(wfile,cat-2);
				fprintf(wfile,".\n");
				if (rfile==stdin){
/* It's seeems a waste of time to calculate this again, but we're unlikely
to be doing this anyway, since anyone with any sense outputs to files and
not standard output */
					mk_Mg(cat-2,MULT);
					lg_print(wfile,Mg);
					lg_clear(Mg);
				}
				else {
					int c;
					strcpy(filename,prefix);
					genstring(generator,cat-2);
					strcat(filename,generator);
					fclose(rfile);
					rfile=fopen(filename,"r");
					while ((c=getc(rfile))!=EOF)
						fprintf(wfile,"%c",c);
					lg_clear(Mg);
				}
			}
			else {
				mk_Mg(g,MULT);
				fprintf(wfile,"\t# Multiplier for generator ");
				gen_print(wfile,g);
				fprintf(wfile,".\n");
				lg_print(wfile,Mg);
				lg_clear(Mg);
			}
		}
	}
	Free_dp((dp)Mg); Mg=0;
	lg_clear(MULT);
	Free_dp((dp)MULT); MULT=0;
	lg_clear(DIFF);
	Free_dp((dp)DIFF); DIFF=0;
	lg_clear(WA);
	Free_dp((dp)WA); WA=0;
	for (i=0;i<gen_array_size;++i)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name); user_gen_name=0;
	Free_dp((dp)inv_of); inv_of=0;
	assert(store_ptrs==0);
	exit(exit_code);
}


static void
mk_Mg(g,MULT)
	gen g;
	lg * MULT;
{
	vindex v;
	int cat;
	list vertices;
	bfs_traverser  Mgt;
	lg_cpy(MULT,Mg);
	set_type(Mg,BASIC_FSA);
/* more optimisation may be possible later */
	list_init(&vertices,VINDEX,FIFO);
	bfs_init(&Mgt,Mg);
	while (bfs_next(&Mgt,&v))
		list_insert(&vertices,(dp)&v);
	bfs_clear(&Mgt);
	while (list_delget_first(&vertices,(dp)&v)){
		cat=get_category(v);
		if (cat==2+g)
			set_category(v,ACCEPTSTATE);
		else
			set_category(v,NONACCEPTSTATE);
	}
	list_clear(&vertices);
	fsa_opt(3,Mg); 
}
	

