/* automata.d/src file newdiff.c */
#include <stdio.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "reduce.h"
#include "lg.h"
#include "afsa.h"
#include "reduce.h"
#include "input.h"
# define DIFF1OP ".diff1"
# define WAOP ".wa"
# define MULTOP ".mult"
# define NEWDIFFOP ".newdiff"
FILE * rfile=stdin;
FILE * wfile=stdout;
lg * WA=0;
lg * Mg=0;
twoafsa * DIFF=0 ;
extern word * user_gen_name;
extern gen * inv_of;
extern int num_gens;
extern int gen_array_size;
list wdiffs;
static int first_new_wdiff PARMS((lg * FSA,gen i));
static boolean new_wdiffs PARMS((lg * FSA,gen i,int s));
static boolean new_wdiffs_from_pair PARMS((word * w1p, word * w2p));

main(argc,argv)
	int argc;
	char * argv[];
{
	int readfile=0;
	char gpname[100];
	char filename[100];
	char prefix[100];
	char generator[100];
	int exit_code=1;
	int i;
	int j;
	char * label;
	word w1, w2;
	lg * exists=0;
	vindex v;
	word_init(&w1);
	word_init(&w2);

	if (argc>2){
		fprintf(stderr,"Usage: newdiff [gpname]\n");
		exit(2);
	}
	else if (argc==2){
		strcpy(gpname,argv[1]);
		strcpy(filename,gpname);
		strcat(filename,DIFF1OP);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		readfile=1;
		strcpy(filename,gpname);
		strcat(filename,NEWDIFFOP);
		wfile=fopen(filename,"w");
		setbuf(wfile,(char*)0);
	}

	setbuf(stdout,(char*)0);
	setbuf(stderr,(char*)0);

	label=vzalloc2(char,9);
	while (read_next_string(label,8,rfile) || readfile==1){
		if (strcmp(label,"Format  ")==0)
			format_echocheck("2.2",rfile,wfile);
/* don't input the multipliers until they're needed */
		else if (strcmp(label,"fsa     ")==0){
			if (DIFF==0){
				DIFF=twoafsa_read(&user_gen_name,rfile);
				num_gens=DIFF->base_symbols - 1;
				twoafsa_print(wfile,DIFF);
			}
			else if (WA==0)
				WA=lg_read(GENERIC,BASIC_FSA,rfile);
			else
				break;
		}
		else if (strcmp(label,"inverses")==0){
			if (inv_of==0) {
			/* don't want to read the inverses in twice */
				read_inverse_array(rfile);
				fprintf(wfile,"inverses \{\n");
				for (i=1;i<=num_gens;i++){
					fprintf(wfile,"inv(");
					gen_print(wfile,i);
					fprintf(wfile,")=");
					gen_print(wfile,inv(i)); 
					fprintf(wfile," ");
				}
				fprintf(wfile,"\}\n");
			}
		}
		else if (strcmp(label,"words   ")==0){
			if (inv_of==0)
				default_inverse_array();
			while (getc(rfile)!='\{')
				;
			list_init(&wdiffs,WORD,ORDERED);
			while (read_next_word(&w1,rfile)){
				word2prog_word(&w1,&w2);
				list_insert(&wdiffs,(dp)&w2);
				word_reset(&w1);
				word_reset(&w2);
			}
			while (getc(rfile)!='\}')
				;
		}
		else if (readfile==1){
			strcpy(filename,gpname);
			strcat(filename,WAOP);
			if ((rfile=fopen(filename,"r"))==0)
  				{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
			readfile=2;
		}
	}
	word_clear(&w1);
	word_clear(&w2);
		
	if (rfile!=stdin){
		strcpy(prefix,gpname);
		strcat(prefix,MULTOP);
	}
	for (i=0;i<=num_gens;i++){
		if (rfile!=stdin){
			fclose(rfile);
			genstring(generator,i);
			strcpy(filename,prefix);
			strcat(filename,generator);
			if ((rfile=fopen(filename,"r"))==0)
  				{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
			while (read_next_string(label,8,rfile)){
				if (strcmp(label,"Format  ")==0)
					format_check("2.2",rfile);
				if (strcmp(label,"fsa     ")==0)
					break;
			}
		}
		Mg=lg_read(GENERIC,BASIC_FSA,rfile);
		exists=fsa_exists(Mg,2);
		if (lg_eq(exists,WA)==FALSE){
			int n;
			lg * not= fsa_not(exists);
			lg * minus=fsa_and(WA,not);
			lg * noeosminus = fsa_eosdelete(minus);
			exit_code=0;
			n = first_new_wdiff(noeosminus,i);
			(void)new_wdiffs(noeosminus,i,n+3);
			lg_clear(not); Free_dp((dp)not); not=0;
			lg_clear(minus); Free_dp((dp)minus); minus=0;
			lg_clear(noeosminus); Free_dp((dp)noeosminus); noeosminus=0;
			lg_clear(exists);
			Free_dp((dp)exists); exists=0;
			lg_clear(Mg);
			Free_dp((dp)Mg); Mg=0;
			break; 
		}
		lg_clear(exists);
		Free_dp((dp)exists); exists=0;
		lg_clear(Mg);
		Free_dp((dp)Mg); Mg=0;
	} 
	fprintf(wfile,"words \{\n");
	list_print(wfile,&wdiffs);
	fprintf(wfile,"\}\n");
	list_clear(&wdiffs);

	Free_dp((dp)label); label=0;
	lg_clear(WA);
	Free_dp((dp)WA); WA=0;
	twoafsa_clear(DIFF);
	Free_dp((dp)DIFF); DIFF=0;
	for (i=0;i<gen_array_size;++i)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name); user_gen_name=0;
	Free_dp((dp)inv_of); inv_of=0;
	assert(store_ptrs==0);
	exit(exit_code);
}

		
static boolean
new_wdiffs(FSA,i,s)
	lg * FSA;
	gen i;
	int s;
{
	int count=0;
	int totalcount=0;
	boolean ans=FALSE;
	word w;
	word w1;
	word w2;
	gen g=INVALID_GEN;
	int l=0;
	vindex * states;
	word_init(&w); 
	word_init(&w1);
	word_init(&w2);
	states = vzalloc2(vindex,s+1);
	states[0]=basept(FSA);
	if (FSA->degree>0)
		g=1;
	while ((l>0||g!=INVALID_GEN) && (count<50) && (totalcount<100000)) {
		totalcount++;
		if (l<s && g!=INVALID_GEN ) { /* move forward */
			states[l+1] = get(states[l],g);
			if (states[l+1]==UNDEFINED){
				if (g==FSA->degree)
					g=INVALID_GEN;
				else
					g++;
			}
			else {
				word_put_last(&w,g);
				l++;
				if (get_category(states[l])==ACCEPTSTATE){
					fprintf(wfile,"# ");
					word_print(wfile,&w);
					fprintf(wfile,"\n"); 
					count++;
					word_cpy(&w,&w1);
					word_cpy(&w1,&w2);
					word_put_last(&w2,i);
					diff_reduction(DIFF,&w2);
					common_prefix_erased(&w1,&w2);
						totalcount=0;
					if (new_wdiffs_from_pair(&w1,&w2)){
						ans=TRUE;
						count=0;
					}
				}
				g=1;
			}
		} 
		else {  /* backtrack */
			word_delget_last(&w,&g);
			l--;
		/* find the next generator, if there is one */
			if (g==FSA->degree)
				g=INVALID_GEN;
			else
				g++;
		}
	}
	Free_dp((dp)states); states=0;
	word_clear(&w);
	word_clear(&w1);
	word_clear(&w2);
	return ans;
}	

static boolean
new_wdiffs_from_pair(w1p,w2p)
	word * w1p;
	word * w2p;
{
	boolean ans=FALSE;
	word wdiff;
	word wdiffinv;
	gen g1,g2;
	word_centreinit(&wdiff);
	word_init(&wdiffinv);
	while (word_length(w1p)+word_length(w2p)!=0){
		if (word_delget_first(w1p,&g1))
			word_put_first(&wdiff,inv(g1));
		if (word_delget_first(w2p,&g2))
			word_put_last(&wdiff,g2);
		diff_reduction(DIFF,&wdiff);
		if (list_insert(&wdiffs,(dp)&wdiff)){
			ans=TRUE;
			fprintf(wfile,"# Differences: ");
			word_print(wfile,&wdiff);
			fprintf(wfile," ");
			word_inv(&wdiff,&wdiffinv);
			diff_reduction(DIFF,&wdiffinv);
			word_print(wfile,&wdiffinv);
			fprintf(wfile,"\n");
			(void)list_insert(&wdiffs,(dp)&wdiffinv);
		}
	}
	word_clear(&wdiff);
	word_clear(&wdiffinv);
	return ans;
}
		
/* the integer returned is the length of the word accepted by the FSA which
leads to the first new word difference */
static int
first_new_wdiff(FSA,i)
	lg * FSA;
	int i;
{
	int n;
	word w;
	word w1;
	word w2;
	gen g;
	vindex v;
	vindex vv;
	bfs_traverser tlg;
	word_init(&w);
	word_init(&w1);
	word_init(&w2);
	bfs_init(&tlg,FSA);
	while (bfs_next(&tlg,&v)){
		if (get_category(v)==ACCEPTSTATE)
			break;
	}
	bfs_clear(&tlg);
	while (is_basepoint(v)==FALSE) {
		bfs_init(&tlg,FSA);
		while (bfs_next(&tlg,&vv)){
			for (g=1;g<=num_gens;g++)
				if (get(vv,g)==v)
					break;
			if (g<=num_gens)
				break;
		}
		bfs_clear(&tlg);
		word_put_first(&w,g);
		v = vv;
	}
	/* now w is an accepted word */
	fprintf(wfile,"# ");
	word_print(wfile,&w);
	fprintf(wfile,"\n"); 
	word_cpy(&w,&w1);
	word_cpy(&w,&w2);
	word_put_last(&w2,i);
	diff_reduction(DIFF,&w2);
	common_prefix_erased(&w1,&w2);
	(void)new_wdiffs_from_pair(&w1,&w2);
	n = word_length(&w);
	word_clear(&w1);
	word_clear(&w2);
	word_clear(&w);
	return n;
}
