/* isom.d/src file abquot.c */
# include <stdio.h>
# include "defs.h"
# include "list.h"
# include "word.h"
# include "input.h"
extern word * user_gen_name;
extern int num_gens;
extern int gen_array_size;
extern gen * inv_of;
list abrels;
int * abrelinvolve=0;
int paired_gens=0;
int numrels=0;
int * pairnumber;
int * gennumber;
int m,n;
int ** A;
int ** C;
int ** R;
int shift;
int trivcount = 0;
int torsion = 0;
# define ABQUOTOP ".abquot"
FILE * rfile=stdin;
FILE * wfile=stdout;
static void diagonalise PARMS((VOID));
static void rowswap PARMS((int i,int j));
static void colswap PARMS((int i,int j));
static void rowadd PARMS((int i ,int j, int lambda));
static void coladd PARMS((int i ,int j, int lambda));
static boolean minposn PARMS((int * ip, int * jp));
static void rownegate PARMS((int i));
static void euclid PARMS((int a,int b,int * dp, int * xp, int * yp));
static void reorganise_free_gens PARMS((VOID));

main(argc,argv)
  int argc;
  char * argv[];
{
  int i,j;
  gen g,h;
  word rel;
  word abrel;
  char * label;
  char gpname[100];
  char filename[100];

  if (argc>2){
    fprintf(stderr,"Usage: abquot [gpname]\n");
    exit(2);
  }
  else if (argc==2){
/* the input and output files are being specified as gpname and gpname.abquot
*/
    strcpy(gpname,argv[1]);
    strcpy(filename,gpname);
    if ((rfile=fopen(filename,"r"))==0)
        { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
    strcat(filename,ABQUOTOP);
    wfile=fopen(filename,"w");
  }

  setbuf(stdout,(char*)0);
  setbuf(stderr,(char*)0);
  setbuf(wfile,(char *)0);
  assert(INVALID_GEN==0); 
/* initially we need the entries of |user_gen_name| and |inv_of| to be equal 
to |INVALID_GEN|, so it's important that that is equal to zero */

  list_init(&abrels,GENWT_WORD,ORDERED);
  label=vzalloc2(char,9);

  while (read_next_string(label,8,rfile)){
    if (strcmp(label,"Format  ")==0)
  		format_echocheck("2.2",rfile,wfile);
    else if (strcmp(label,"gens    ")==0 || strcmp(label,"words   ")==0)
      /* The order of the generators is being specified */
	  read_gen_name_array(rfile);
    else if (strcmp(label,"inverses")==0)
      read_inverse_array(rfile);
    else if (strcmp(label,"rels    ")==0){
      word uw1,uw2,pw2;
      int * wd;
      if (inv_of==0)
        default_inverse_array();
      while (getc(rfile)!='\{')
        ;
      wd = vzalloc2(int,num_gens+1);
      word_init(&uw1);
      word_init(&uw2);
      word_init(&pw2);
      word_init(&rel);
      word_init(&abrel);
      while (read_next_word(&uw1,rfile)){
        int c;
        word2prog_word(&uw1,&rel);
        word_reset(&uw1);
        while ((c=getc(rfile))==' '||c=='\t'||c=='\n');
        if (c=='=' || c=='>'){
          read_next_word(&uw2,rfile);
          word2prog_word(&uw2,&pw2);
          word_inv(&pw2,&pw2);
          word_append(&rel,&pw2);
          word_reset(&uw2);
          word_reset(&pw2);
        }
        else
          ungetc(c,rfile);
        while (word_delget_first(&rel,&h)){
          if (h<=inv(h))
            wd[h] += 1;
          else
            wd[inv(h)] -= 1;
        }
        word_reset(&rel);
        for (i=1;i<=num_gens;i++){
          if (wd[i]>0){
            while (wd[i]!=0){
              word_put_last(&abrel,i);
              wd[i]--;
            }
          }
          else if (wd[i]<0){
            while (wd[i]!=0){
              word_put_last(&abrel,inv(i));
              wd[i]++;
            }
          }
        }  
        if (word_length(&abrel)!=0 && list_insert(&abrels,(dp)&abrel)) 
          numrels++;
        word_reset(&abrel);
      }
      while (getc(rfile)!='\}')
        ;
      word_clear(&uw1);
      word_clear(&uw2);
      word_clear(&pw2);
      Free_dp((dp)wd); wd = 0;
      for (i=1;i<=num_gens;i++){
        if (inv(i)==i){
          word_put_last(&abrel,i);
          word_put_last(&abrel,i);
          if (list_insert(&abrels,(dp)&abrel)) 
            numrels++;
          word_reset(&abrel);
        }
      }
    } 
  }
  Free_dp((dp)label); label=0;

  pairnumber=vzalloc2(int,num_gens+1);
  for (i=1;i<=num_gens;i++){
    if (i<=inv(i)){
      paired_gens++;
      pairnumber[i]=pairnumber[inv(i)]=paired_gens;
    }
  }
  gennumber=vzalloc2(int,paired_gens+1);
  for (i=1;i<=num_gens;i++)
    if (i<=inv(i))
      gennumber[pairnumber[i]] = i;

  A=vzalloc2(int*,numrels);
  A--;
  for (i=1;i<=numrels;i++){
    A[i]=vzalloc2(int,paired_gens);
    A[i]--;
  }
  abrelinvolve=vzalloc2(int,paired_gens+1);
  for (j=1;j<=paired_gens;j++)
    abrelinvolve[j]=0;
  for (i=1;i<=numrels;i++){
    gen h;
    (void)list_delget_first(&abrels,(dp)&abrel);
    while (word_delget_first(&abrel,&g)){
      if (g<=inv(g))
        A[i][pairnumber[g]] += 1;
      else
        A[i][pairnumber[g]] -= 1;
      h = g; 
    }
    /* Now h is the highest numbered generator in the word */
    for (j=pairnumber[h];j<=paired_gens;j++)
      abrelinvolve[j]++;
    word_reset(&abrel);
  }



  R=vzalloc2(int*,numrels);
  R--;
  for (i=1;i<=numrels;i++){
    R[i]=vzalloc2(int,numrels);
    R[i]--;
  }
  for (i=1;i<=numrels;i++)
    R[i][i]=1;
  C=vzalloc2(int*,paired_gens);
  C--;
  for (i=1;i<=paired_gens;i++){
    C[i]=vzalloc2(int,paired_gens);
    C[i]--;
  }
  for (i=1;i<=paired_gens;i++)
    C[i][i]=1;
  fprintf(wfile,"abgens \{ ");
  for (j=1;j<=paired_gens;j++){
    gen_print(wfile,gennumber[j]);
    fprintf(wfile," ");
  }
  fprintf(wfile,"\}\n");
  
  fprintf(wfile,"abrels \{\n");
  for (i=1;i<=numrels;i++){
    boolean first = TRUE;
    fprintf(wfile,"\t");
    for (j=1;j<=paired_gens;j++){
      int x;
      if ((x = A[i][j])!=0){
        if (first){
          if (x==-1)
            fprintf(wfile,"-");
          else if (x!=1) 
            fprintf(wfile,"%d",x);
          first = FALSE;
        }
        else if (x==1)
            fprintf(wfile," + ");
        else if (x==-1)
            fprintf(wfile," - ");
        else if (x>0)
          fprintf(wfile," + %d",x);
        else 
          fprintf(wfile," - %d",-x);
        gen_print(wfile,gennumber[j]);
      }
    }
    fprintf(wfile,"\n");
  }
  fprintf(wfile,"\}\n");
  fprintf(wfile,"abrelinvolve { ");
  for (i=1;i<=paired_gens;i++)
    fprintf(wfile,"%d ",abrelinvolve[i]);
  fprintf(wfile,"}\n");
  diagonalise();
  for (i=1;i<=numrels && i<=paired_gens;i++){
    if (A[i][i]==1)
      trivcount++;
    else if (A[i][i]==0){
      i++;
      break;
    }
  }
  torsion = i-1;
  
  reorganise_free_gens();
  
  fprintf(wfile,"abinvariants \{ ");
  for (i=1;i<=paired_gens;i++){
    if (i<=numrels){
      if (A[i][i]!=1)
        fprintf(wfile,"%d ",A[i][i]);
    }
    else
      fprintf(wfile,"0 ");
  }
  fprintf(wfile,"\}\n");  

  
  fprintf(wfile,"abimages \{\n");
  for (i=1;i<=paired_gens;i++){
    fprintf(wfile,"\t");
    gen_print(wfile,gennumber[i]);
    fprintf(wfile,": ");
    for (j = trivcount+1;j<=paired_gens;j++)
      fprintf(wfile,"%3d ",C[i][j]);
    fprintf(wfile,"\n");
  }
  fprintf(wfile,"\}\n");
    
  for (i=1;i<=numrels;i++){
    R[i]++;
    Free_dp((dp)R[i]);
    R[i]=0;
  }
  R++;
  Free_dp((dp)R);
  R=0;
  for (i=1;i<=numrels;i++){
    A[i]++;
    Free_dp((dp)A[i]);
    A[i]=0;
  }
  A++;
  Free_dp((dp)A);
  A=0;
  for (i=1;i<=paired_gens;i++){
    C[i]++;
    Free_dp((dp)C[i]);
    C[i]=0;
  }
  C++;
  Free_dp((dp)C);
  C=0;
  for (i=0;i<gen_array_size;++i)
    word_clear(user_gen_name+i);
  Free_dp((dp)user_gen_name);
  user_gen_name=0;
  Free_dp((dp)inv_of);
  inv_of=0;
  word_clear(&rel);
  word_clear(&abrel);
  list_clear(&abrels);
  Free_dp((dp)pairnumber); pairnumber=0;
  Free_dp((dp)gennumber); gennumber=0;
  Free_dp((dp)abrelinvolve); abrelinvolve=0;
  assert(store_ptrs==0);
  exit(0);
}

static void
diagonalise()
{
  int i,j,i0,j0;
  int d,x,y;  
  m=numrels; n=paired_gens;
  shift=0;
  while (m>=0 && n>=0 & minposn(&i0,&j0)){
    boolean repeat = FALSE;
    for (i=1;i<=m;i++)
      if (i!=i0)
        rowadd(i,i0,-((A[i][j0])/(A[i0][j0])));
    for (j=1;j<=n;j++)
      if (j!=j0)
        coladd(j,j0,-((A[i0][j])/(A[i0][j0])));
    for (i=1;i<=m;i++)
      if (i!=i0 && A[i][j0]!=0){
        repeat=TRUE;
        break;
      }
    for (j=1;j<=n;j++)
      if (j!=j0 && A[i0][j]!=0){
        repeat=TRUE;
        break;
      }
    if (repeat==FALSE){
      rowswap(1,i0);
      colswap(1,j0);
      if (A[1][1]<0)
        rownegate(1);
      shift++;
      A++;
      m--;
      n--;
      for (i=1;i<=m;i++)
        A[i]++;
    }
  }
  while (m<numrels){
    for (i=1;i<=m;i++)
      A[i]--;
    m++;
    n++;
    A--;
  }
  shift=0;
  while (m>1 && n>1 & A[1][1]!=0){
    for (i=2;i<=m && i<=n;i++)
      if ((A[i][i])%(A[1][1])!=0){
    /* replace A[1][1] by the hcf of the two numbers and A[i][i] by
their least common multiple */
        int d,x,y;
        euclid(A[1][1],A[i][i],&d,&x,&y);
        rowadd(i,1,x);
        coladd(1,i,y);
        rowswap(1,i);
        rowadd(i,1,-((A[i][1])/d));
        coladd(i,1,-((A[1][i])/d));
        rownegate(i);
      }
    shift++;
    A++;
    m--;
    n--;
    for (i=1;i<=m;i++)
      A[i]++;
  }
  while (m<numrels){
    for (i=1;i<=m;i++)
      A[i]--;
    m++;
    n++;
    A--;
  }
}

static void
rowswap(i,j)
  int i,j;
{
  int * temp;
  int ii = i + shift;
  int jj = j + shift;
  temp = A[i];
  A[i] = A[j];
  A[j] = temp;
  temp = R[ii];
  R[ii] = R[jj];
  R[jj] = temp;
}
  
static void
colswap(i,j)
  int i,j;
{
  int temp;
  int k;
  int ii = i + shift;
  int jj = j + shift;
  for (k=1;k<=m;k++){
    temp = A[k][i];
    A[k][i] = A[k][j];
    A[k][j] = temp;
  }
  for (k=1;k<=paired_gens;k++){
    temp = C[k][ii];
    C[k][ii] = C[k][jj];
    C[k][jj] = temp;
  }
}

static boolean
minposn(ip,jp)
  int * ip, * jp;
{
  int smallest=0;
  int i,j;
  *ip=0;
  *jp=0;
  for (i=1;i<=m;i++)
    for (j=1;j<=n;j++){
      int x = A[i][j];
      if (x>0 && (x < smallest || smallest==0)){
        smallest = x;
        *ip = i;
        *jp = j;
      }
      else if (x<0 && (-x < smallest || smallest==0)){
        smallest = -x;
        *ip = i;
        *jp = j;
      }
    }
  if (smallest==0)
    return FALSE;
  else
    return TRUE;
} 

static void 
rowadd(i,j,lambda)
  int i,j,lambda;
{
  int k;
  int ii = i + shift;
  int jj = j + shift;
  for (k=1;k<=n;k++)
    A[i][k] = A[i][k] +lambda * A[j][k];
  for (k=1;k<=numrels;k++)
    R[ii][k] = R[ii][k] +lambda * R[jj][k];
}
      
static void 
coladd(i,j,lambda)
  int i,j,lambda;
{
  int k;
  int ii = i + shift;
  int jj = j + shift;
  for (k=1;k<=m;k++)
    A[k][i] = A[k][i] +lambda * A[k][j];
  for (k=1;k<=paired_gens;k++)
    C[k][ii] = C[k][ii] +lambda * C[k][jj];
}

static void
rownegate(i)
  int i;
{
  int k;
  int ii = i + shift;
  for (k=1;k<=n;k++)
    A[i][k] *= -1;
  for (k=1;k<=numrels;k++)
    R[ii][k] *= -1;
}

static void
euclid(a,b,dp,xp,yp)
  int a,b;
  int *dp,*xp,*yp;
{
  int a1,a2,x1,y1,x2,y2,x,y,r,q;
  if (a>b){
    a1 = a;
    a2 = b;
    x1 = 1;
    y1 = 0;
    x2 = 0;
    y2 = 1;
  }
  else {
    a1 = b;
    a2 = a;
    x1 = 0;
    y1 = 1;
    x2 = 1;
    y2 = 0;
  }
  while ((r=a1%a2)!=0){
    q = a1/a2;
    x = x1 - q*x2;
    y = y1 - q*y2;
    a1 = a2; x1 = x2; y1 = y2;
    a2 = r; x2 = x; y2 = y;
  }
  assert(x2*a + y2*b == a2);
  *dp = a2;
  *xp = x2;
  *yp = y2;
}

static void
reorganise_free_gens()
{
  int ** F;
  int r = paired_gens;
  int s = paired_gens - torsion;
  int diag=0;
  int i,j,k,temp;
  F = vzalloc2(int*,paired_gens);
  F--;
  for (i=1;i<=paired_gens;i++)
    F[i] = C[i] + torsion;
  while (diag<s && r>0){
    int smallest=0;
    boolean repeat = FALSE;
/* find the smallest entry in the current row to the right of the diagonal */
    for (j=diag+1;j<=s;j++){
      int x = F[1][j];
      if (x>0 && (x<smallest || smallest==0)){
        smallest = x;
        k = j;
      }
      else if (x<0 && (-x < smallest || smallest ==0)){
        smallest = -x;
        k = j;
      }
    }
    if (smallest==0){
/*  There are only zeroes to the right of the diagonal in this row. Move down 
  to the next row */
      F++;
      r--;
    }
    else {
  /* multiply by -1 if necessary to make the smallest entry positive */
      if (F[1][k]<0){
        for (i=1;i<=r;i++)
          F[i][k] *= -1;
      }
  /* subtract multiples of this selected  column from all columns to the 
left of it. This should result in entries >=0 everywhere earlier in the
row */
      for (j=1;j<=s;j++){
        int lambda;
        if (j!=k){
          if (F[1][j]>=0)
            lambda = -((F[1][j])/(F[1][k]));  
          else
              lambda = (-F[1][j] + F[1][k] - 1)/(F[1][k]);
          for (i=1;i<=r;i++)
            F[i][j] += lambda* F[i][k];
          if (j>diag && F[1][j]!=0)
            repeat = TRUE;
        }
      }
      if (repeat==FALSE){
  /*   move column k as far left as possible */
        for (i=1;i<=r;i++){
          temp = F[i][diag+1];
          F[i][diag+1] = F[i][k];
          F[i][k] = temp;
        }
        diag++;
        r--;
        F++;
      }
    }
  }    
  F -= paired_gens - r -1;
  Free_dp((dp)F); F=0;
}
