/* isom.d/src file ordrels.c */
#include <stdio.h>
# include <ctype.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "input.h"
# define ORDRELSOP ".ordrels"
#define DEFAULT 6
FILE * rfile=stdin;
FILE * wfile=stdout;
int maxperms=DEFAULT;
list rels;
list substrels;
int * part;
int * level;
int * genperm;
int * bestgenperm;
int * bestorder;
int * permposn;
int * relinvolve;
int * bestrelinvolve;
int * renumber;
int active_gens;
int paired_gens;
extern word * user_gen_name;
extern gen * inv_of;
extern int gen_array_size;  
extern int num_gens;
static void correct_gen_order PARMS((VOID));
static boolean substitute_for_gens PARMS((VOID));
static void sort_free_gens PARMS((VOID));
static void substitute_with PARMS((word * wp, gen g));
static void set_relinvolve PARMS((VOID));
static void reset_relinvolve PARMS((VOID));
static void partially_order_gens PARMS((VOID));
static void set_next_level PARMS((int  k, list * lp));
static boolean next_partpreserving_perm PARMS((VOID));
static void reorder_rels PARMS((VOID));
static void reorder_gens PARMS((VOID));


main(argc,argv)
  int argc;
  char * argv[];
{
  int i,j;
  gen g,h;
  word rel;
  char * label;
  boolean commandline_parameters = FALSE;
  char gpname[100];
  char filename[100];

  i=1;
    while (i<argc && argv[i][0]=='-'){
    if (argv[i][1]=='m'){
      int j=0;
      maxperms=0;
      commandline_parameters=TRUE;
      i++;
      if (i==argc){
        fprintf(stderr,"Usage: ordrels [-m posint] [gpname]\n");
        exit(2);
      }
      while (argv[i][j]!='\0') {
        if (!isdigit(argv[i][j])){
          fprintf(stderr,"Usage: ordrels [-m posint] [gpname]\n");
          exit(2);
        }
        maxperms = 10*maxperms + argv[i][j]-'0';
        j++;
      }
    }
    else {
      fprintf(stderr,"Usage: ordrels [-m posint] [gpname]\n");
      exit(2);
    }
    i++;
  }
  if (i<argc-1){
    fprintf(stderr,"Usage: ordrels [-m posint] [gpname]\n");
    exit(2);
  }
  else if (i==argc-1){
/* the input and output files are being specified as gpname and gpname.ordrels
*/
    strcpy(gpname,argv[argc -1]);
    strcpy(filename,gpname);
    if ((rfile=fopen(filename,"r"))==0)
        { fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
    strcat(filename,ORDRELSOP);
    wfile=fopen(filename,"w");
  }

  setbuf(stdout, (char*)0);
  setbuf(stderr,(char*)0);
  setbuf(wfile,(char*)0);
  assert(INVALID_GEN==0); 
/* initially we need the entries of |user_gen_name| and |inv_of| to be equal 
to |INVALID_GEN|, so it's important that that is equal to zero */

  list_init(&rels,GENWT_WORD,ORDERED);
  list_init(&substrels,GENWT_WORD,LIFO);
  label=vzalloc2(char,9);

  while (read_next_string(label,8,rfile)){
    if (strcmp(label,"Format  ")==0)
  		format_echocheck("2.2",rfile,wfile);
    else if (strcmp(label,"words   ")==0 || strcmp(label,"gens    ")==0)
      /* The order of the generators is being specified */
		read_gen_name_array(rfile);
    else if (strcmp(label,"inverses")==0)
      read_inverse_array(rfile);
    else if (strcmp(label,"rels    ")==0){
      if (inv_of==0)
        default_inverse_array();
      renumber=vzalloc2(int,num_gens+1);
      correct_gen_order();
      while (getc(rfile)!='\{')
        ;
      word_init(&rel);
	  while (read_next_rel(&rel,rfile)){
        if (word_length(&rel)>2 || (word_length(&rel)==2 &&
        word_get_last(&rel,&g)&&word_get_first(&rel,&h)&&g!=h))
            word_creduce(&rel,&rel);
		else if (g==h){ /* g is an involution */
/* if the inverse table doesn't already record g as an involution, we need
to change it. The lower numbered of the two generators g and inv(g) should
appear as the inverse of both in the inverse table. The higher numbered
generator then becomes redundant, but we won't delete it, because that would
mean rewriting all our relators. */
			if (g<inv_of[g]) {
				inv_of[g] = g;
			}
			else if (g>inv_of[g]) 
				inv_of[inv_of[g]] = inv_of[g];
		}
        if (word_length(&rel)!=0)
          list_insert(&rels,&rel);
        word_reset(&rel);
      }
      while (getc(rfile)!='\}')
        ;
      
      for (i=1;i<=num_gens;i++){
        if (inv(i)==i){
          word_put_last(&rel,i);
          word_put_last(&rel,i);
          list_insert(&rels,(dp)&rel);
          word_reset(&rel);
        }
      }
      word_clear(&rel);
    } 
    else if (strcmp(label,"paramete")==0 && commandline_parameters==FALSE){
      while (getc(rfile)!='\{')
        ;
      if (find_keyword("maxperms",rfile)){
        read_next_int(&maxperms,rfile);
      }
      while (getc(rfile)!='\}')
        ;
    }
  }
  Free_dp((dp)label); label=0;

  paired_gens=num_gens;
  for (i=1;i<=num_gens;i++)
    if (i>inv(i))
      paired_gens--; 
  active_gens=paired_gens;
  genperm=vzalloc2(int,paired_gens+1);
  permposn=vzalloc2(int,num_gens+1);
  while (substitute_for_gens())
    ;
  sort_free_gens();
  part=vzalloc2(int,active_gens+1);
  partially_order_gens();
  bestgenperm=vzalloc2(int,paired_gens+1);
  for (i=1;i<=paired_gens;i++)
    bestgenperm[i]=genperm[i];
  relinvolve=vzalloc2(int,paired_gens+1);
  set_relinvolve();
  bestrelinvolve=vzalloc2(int,paired_gens+1);
  for (i=1;i<=paired_gens;i++)
    bestrelinvolve[i]=relinvolve[i];
  while (next_partpreserving_perm()){
    reset_relinvolve();
    i=1;
    while (i<=active_gens && relinvolve[i]>=bestrelinvolve[i]){
      if (relinvolve[i]>bestrelinvolve[i]){
        while (i<=active_gens){
          bestrelinvolve[i]=relinvolve[i];
          i++;
        }
        for (i=1;i<=active_gens;i++) 
            /* the entries at the end don't change */
          bestgenperm[i]=genperm[i];
        break;
      }
      else 
        i++;
    }
  }
  Free_dp((dp)part); part=0;
  Free_dp((dp)genperm); genperm=0;
  Free_dp((dp)permposn); permposn=0;
  Free_dp((dp)relinvolve); relinvolve=0;
  for (i=2;i<=paired_gens;i++)
    bestrelinvolve[i] += bestrelinvolve[i-1]; 
  /* Replace each entry by the sum of that and all preceding entries */
  for (i=paired_gens;i>active_gens;i--){
    if (bestrelinvolve[i]>bestrelinvolve[i-1])
      bestrelinvolve[i] = -bestrelinvolve[i];
/* otherwise the generator is essentially free, and so in some sense could
be thought of as an active generator (it will be in the programme isom).
Therefore we allow its relinvolve entry to remain positive */
  }
  bestorder=vzalloc2(int,num_gens+1);
  i=1;
  j=1;
  while (i<=paired_gens){
    bestorder[j]=bestgenperm[i];
    if (inv(bestorder[j])>bestorder[j]){
      bestorder[j+1]=bestorder[j]+1;
      j=j++;
    }  
    i++;
    j++;
  }
  Free_dp((dp)bestgenperm); genperm=0;
  for (i=1;i<=num_gens;i++) renumber[i]=0;
  for (i=1;i<=num_gens;i++){
	if (bestorder[i]!=0)
    	renumber[bestorder[i]]=i;
  }
  for (i=1;i<=num_gens;i++){
        if (renumber[i]==0)
 /* this means that i is the redundant inverse of an involution */
		renumber[i] = renumber[inv(i)];
  }
  reorder_rels();
  reorder_gens();
  Free_dp((dp)renumber); renumber=0;
  Free_dp((dp)bestorder); bestorder=0;
  

  fprintf(wfile,"gens \{ ");
  for (i=1;i<=num_gens;i++)
	if (i<=inv(i)){
    	gen_print(wfile,i);
    	fprintf(wfile," ");
  	}
  fprintf(wfile,"\}\n");
  fprintf(wfile,"inverses \{\n");
  for (i=1;i<=num_gens;i++)
	if (i<=inv(i)){
    	fprintf(wfile,"inv(");
    	gen_print(wfile,i);
    	fprintf(wfile,")=");
    	gen_print(wfile,inv(i));
    	fprintf(wfile," ");
  	}
  fprintf(wfile,"\n\}\n");
  fprintf(wfile,"rels \{\n");
  list_print(wfile,&rels);
  list_print(wfile,&substrels);
  fprintf(wfile,"\}\n");
  fprintf(wfile,"relinvolve { ");
  for (i=1;i<=paired_gens;i++)
    fprintf(wfile,"%d ",bestrelinvolve[i]);
  fprintf(wfile,"\}\n");
  Free_dp((dp)bestrelinvolve); relinvolve=0;
  list_clear(&rels);
  list_clear(&substrels);
  for (i=0;i<gen_array_size;++i)
    word_clear(user_gen_name+i);
  Free_dp((dp)user_gen_name);
  user_gen_name=0;
  Free_dp((dp)inv_of);
  inv_of=0;
  assert(store_ptrs==0);
  exit(0);
}

static void
correct_gen_order()
{
  gen g;
  int shift=0;
  for (g=1;g<=num_gens;g++){
    if (renumber[g]==0)
      renumber[g]=g+shift;
    else
      shift--;
    if (inv(g)>g+1){
      renumber[inv(g)]=renumber[g]+1;
      shift++;
    }
  }
  reorder_gens();
}
  
static boolean
substitute_for_gens()
{
  boolean ans=FALSE;
  gen g,h;
  word rel;
  list_traverser trels;
  int occurrences=0;
  word_init(&rel);

 /* we run through the generators which we haven't already identified as
non-active to look for substitutions */
  for (g=num_gens;g>0;g--){
    if (permposn[g]!=0||g>inv(g)) /* in the first case
g has already been identified as non-active, so we
certainly won't find it in any of the relators left in rels */
      continue; 
    list_traverser_init(&trels,&rels);
    while(list_next(&trels,(dp)&rel)){
      word_traverser trel;
      occurrences=0;
      word_traverser_init(&trel,&rel);
      while (word_next(&trel,&h)){
        if (h==g||inv(h)==g)
          occurrences++;
      }
      word_traverser_clear(&trel);
      if (occurrences==1)
        break; /* out of while loop */
      word_reset(&rel);
    }
    list_traverser_clear(&trels);
    if (occurrences==1)
      break; /* out of for loop. Now we make the substitution, so
the list of relators will change, and we'll have to search through it again
from the beginning */
  }

  if (occurrences==1){ /*we have a substitution to make */
    list_delete(&rels,(dp)&rel);
    substitute_with(&rel,g); 
      /* rel has now changed to be in the form w*inv(g) */
    list_insert(&substrels,(dp)&rel);
    permposn[g]=permposn[inv(g)]=active_gens;
    genperm[active_gens--]=g;
    ans=TRUE;
  }
  word_clear(&rel);
  return ans;
}

static void
sort_free_gens()
{
  gen g;
  int i;
  word rel;
  list_traverser trels;
  int occurrences=0;
  boolean * seen;
  word_init(&rel);
  seen=vzalloc2(boolean,num_gens+1);
  list_traverser_init(&trels,&rels);
  while(list_next(&trels,(dp)&rel)){
    word_traverser trel;
    word_traverser_init(&trel,&rel);
    while (word_next(&trel,&g))
      seen[g]=seen[inv(g)]=TRUE;
    word_traverser_clear(&trel);
    word_reset(&rel);
  }
  list_traverser_clear(&trels);
  for (i=num_gens;i>0;i--){
    if (i<=inv(i) && seen[i]==FALSE && permposn[i]==0){
      genperm[active_gens]=i;  
      permposn[i]=permposn[inv(i)]=active_gens;
      active_gens--;
    }
  }
  word_clear(&rel);
  Free_dp((dp)seen); seen=0;
}
    
static void
substitute_with(wp,g)
  word  * wp;
  gen g;
{
  word w;
  word rel;
  word newrel;
  word subst;
  word substinv; 
  list newrels; 
  gen h,k;
  word_init(&subst);
  word_init(&substinv);
  word_init(&w);
  while (word_delget_first(wp,&h)){
    if (h==g||inv(h)==g)
      break;
    else
      word_put_last(&w,h);  
  }
  if (h==g) {
    word_concat(wp,&w,&substinv);
    word_inv(&substinv,&subst);
  }
  else {
    word_concat(wp,&w,&subst);
    word_inv(&subst,&substinv);
  }
  word_clear(&w);
  word_reset(wp);
  word_cpy(&subst,wp);
  word_put_last(wp,inv(g));
  word_init(&rel);
  word_init(&newrel);
  list_init(&newrels,GENWT_WORD,ORDERED);
  while (list_delget_first(&rels,(dp)&rel)){
    while (word_delget_first(&rel,&h)){
      if (h==g)
        word_append(&newrel,&subst);
      else if (inv(h)==g)
        word_append(&newrel,&substinv);
      else
        word_put_last(&newrel,h);
    }
    if (word_length(&newrel)>2 || (word_length(&newrel)==2 &&
        word_get_last(&newrel,&h)&&word_get_first(&newrel,&k)&&k!=h))
      word_creduce(&newrel,&newrel);
    if (word_length(&newrel)!=0)
      list_insert(&newrels,&newrel);
    word_reset(&newrel);
    word_reset(&rel);
  }
  list_cpy(&newrels,&rels);
  list_clear(&newrels);
  word_clear(&subst);
  word_clear(&substinv);
  word_clear(&rel);
  word_clear(&newrel);
}

static void
set_relinvolve()
{
  list_traverser lt;
  word rel;
  word_traverser trel;
  gen g;
  int m=0;
  for (m=1;m<=paired_gens;m++)
    relinvolve[m]=0;
  list_traverser_init(&lt,&rels);
  word_init(&rel);
  while (list_next(&lt,(dp)&rel)){
    m=0;
    word_traverser_init(&trel,&rel);
    while (word_next(&trel,&g)){
      if (permposn[inv(g)]>m) /* 
We really want permposn[g] here, but have a problem
if g has become redundant, as the inverse of a generator which was
discovered to be an involution. In that case permposn[g] would be zero.
In general, permposn is supposed to take the same value at g and inv(g). 
  */
        m=permposn[inv(g)];  
    }
    word_traverser_clear(&trel);
    relinvolve[m]++;
    word_reset(&rel);
  }
  list_traverser_clear(&lt);
  list_traverser_init(&lt,&substrels);
  while (list_next(&lt,(dp)&rel)){
    m=0;
    word_traverser_init(&trel,&rel);
    while (word_next(&trel,&g)){
      if (permposn[inv(g)]>m)
        m=permposn[inv(g)];  
    }
    word_traverser_clear(&trel);
    relinvolve[m]++;
    word_reset(&rel);
  }
  word_clear(&rel);
  list_traverser_clear(&lt);
}

static void
reset_relinvolve()
{
  list_traverser lt;
  word rel;
  int m=0;
  for (m=1;m<=active_gens;m++)
    relinvolve[m]=0;
  list_traverser_init(&lt,&rels);
  word_init(&rel);
  while (list_next(&lt,(dp)&rel)){
    word_traverser trel;
    gen g;
    m=0;
    word_traverser_init(&trel,&rel);
    while (word_next(&trel,&g)){
      if (permposn[inv(g)]>m)
        m=permposn[inv(g)];  
    }
    word_traverser_clear(&trel);
    relinvolve[m]++;
  }
  word_clear(&rel);
  list_traverser_clear(&lt);
}

static void
partially_order_gens()
{
  int m=0;
  int k=1;
  int i;
  list list1;
  list list2;
  level=vzalloc2(int,num_gens+1);
  list_init(&list1,GENWT_WORD,ORDERED);
  list_init(&list2,GENWT_WORD,ORDERED);
  list_cpy(&rels,&list1);
  for (i=1;i<=num_gens;i++)
    if (i<=inv(i) && permposn[i]==0)
      level[i]=1; 
  /* initially we put every active generator on level 1, then we gradually 
sort generators out by pushing them up onto higher levels one level at a time */
  while (active_gens-k+1>maxperms&&list_empty(&list1)==FALSE){
    word w;
    word neww;
    gen g;
    set_next_level(k,&list1); 
    part[k]=k;
  /* delete occurrences of the level k generators from the relators */
    word_init(&w);
    word_init(&neww);
    while (list_delget_first(&list1,(dp)&w)){
      while (word_delget_first(&w,&g))
        if (level[g]!=k && level[inv(g)]!=k)
          word_put_last(&neww,g);
      if (word_length(&neww)>0)
        list_insert(&list2,(dp)&neww);
      word_reset(&w);
      word_reset(&neww);
    }
    list_cpy(&list2,&list1);
    list_reset(&list2);
    word_clear(&w);
    word_clear(&neww);
    k++;
  }
  /* the remaining generators all get equal consideration */
  m=k;
  for (i=1;i<=num_gens;i++){
    if (level[i]==k){
      permposn[i]=permposn[inv(i)]=m;
      genperm[m]=i;
      part[m]=k;
      m++;
    }
  }
  Free_dp((dp)level); level=0;
  list_clear(&list1);
  list_clear(&list2);
}  
      
static void
set_next_level(k,lp)
  int k;
  list * lp;
{
  int ** wtseq;
  list_traverser lt;
  word w;
  int weight=0;
  int count=0;
  int i;
  boolean first=TRUE;
  wtseq=vzalloc2(int*,num_gens+1);
  for (i=1;i<=num_gens;i++)
    if (i<=inv(i))
      wtseq[i]=vzalloc2(int,num_gens+1);
  word_init(&w);
  list_traverser_init(&lt,lp);
  while(list_next(&lt,&w)){
    boolean * seen;
    word_traverser wt;
    gen g;
    weight=0;
    word_traverser_init(&wt,&w);
    seen=vzalloc2(boolean,num_gens+1);
    while (word_next(&wt,&g)){
      if (g<=inv(g))
        seen[g]=TRUE;
      else 
        seen[inv(g)]=TRUE;
    }
    word_traverser_clear(&wt);
    for (i=1;i<=num_gens;i++)
      if (seen[i])
        weight++;
    for (i=1;i<=num_gens;i++)
      if (seen[i])
        wtseq[i][weight]++;
    word_reset(&w);
    Free_dp((dp)seen); seen=0;
  }
  list_traverser_clear(&lt);
  weight=0;
  do {
    int max=0;
    count=0;
    do {
      weight++;
      for (i=1;i<=num_gens;i++)
        if (level[i]==k && wtseq[i][weight]!=0)
          count++;
    } while (count==0 && weight<num_gens);
    if (count>0){
      for (i=1;i<=num_gens;i++){
        if (level[i]==k){
          if (wtseq[i][weight]==0)
            level[i]=k+1;
          else if (count>1)
            if (max<wtseq[i][weight])
              max=wtseq[i][weight];
        }
      }
    }
    if (count>1){
      for (i=1;i<=num_gens;i++){
        if (level[i]==k && wtseq[i][weight]<max){
          level[i]=k+1;
          count--;
        }
      }
    }
  } while (count>1);
/* Now all the generators left on level k have identical weight sequences.
So if there is more than one generator at level k, we just choose one of 
these arbitrarily and shunt the rest up to level k+1.
*/
  for (i=1;i<=num_gens;i++){
    if (level[i]==k){
      if (first){
        permposn[i]=permposn[inv(i)]=k;
        genperm[k]=i;
        first=FALSE;
      }
      else
        level[i]=k+1;
    }
  }
  word_clear(&w);
  for (i=1;i<=num_gens;i++)
    if (i<=inv(i)){
      Free_dp((dp)wtseq[i]);
      wtseq[i]=0;
    }
  Free_dp((dp)wtseq); wtseq=0;
}






  
static boolean
next_partpreserving_perm() 
{ 
  boolean increased=FALSE;
  int m=active_gens-1;
  while (m>0 && (genperm[m]>genperm[m+1]||part[m]<part[m+1]))
    m--;
  if (m<=0)
    return FALSE;
  else {
  /*the m-th entry is smaller than its successor and in the same
part as it */
    int * temp;
    int i,j,k,r;
    temp=vzalloc2(int,active_gens+1);
    for (i=1;i<=active_gens;i++)
      temp[i]=genperm[i];
    j=i=m+1;
    while (j<active_gens && part[j+1]==part[i])
      j++;
    r=j+1; /* the beginning of the next block */
    while (i<r){
      if (temp[j]<temp[m] ||(increased)){
        k=temp[j--];
        permposn[k]=permposn[inv(k)]=i;
        genperm[i++]=k;
      }
      else { 
  /* we've found the smallest entry to the right of posn. m that
is bigger than the entry currently in that position */
        increased=TRUE;
        k=temp[m];
        permposn[k]=permposn[inv(k)]=i;
        genperm[i++]=k;
        k=temp[j--];
        permposn[k]=permposn[inv(k)]=m;
        genperm[m]=k;
      }
    }
/* now reverse the ordering in the later blocks */
    while (r<=active_gens){
      j=i=r;
      while (j<active_gens && part[j+1]==part[i])
        j++;
      r=j+1;
      while (i<r){
        k=temp[j--];
        permposn[k]=permposn[inv(k)]=i;
        genperm[i++]=k;
      }
    }
    Free_dp((dp)temp); temp=0;
    return TRUE;
  }
}


static void
reorder_rels()
{  
  word rel, newrel;  
  gen g;  
  list newrels; 
  list newsubstrels; 

  list_init(&newrels,GENWT_WORD,ORDERED); 
  word_init(&rel); 
  word_init(&newrel); 

  while (list_delget_first(&rels,(dp)&rel)) { 
    while (word_delget_first(&rel,&g))  
      word_put_last(&newrel,renumber[g]); 
    (void)list_insert(&newrels,(dp)&newrel); 
    word_reset(&rel); 
    word_reset(&newrel); 
  }  
  list_cpy(&newrels,&rels); 
  list_clear(&newrels);

  list_init(&newsubstrels,GENWT_WORD,LIFO); 
  while (list_delget_first(&substrels,(dp)&rel)) { 
    while (word_delget_first(&rel,&g))  
      word_put_last(&newrel,renumber[g]); 
    (void)list_insert(&newsubstrels,(dp)&newrel); 
    word_reset(&rel); 
    word_reset(&newrel); 
  }  
  while (list_delget_first(&newsubstrels,(dp)&rel)){
    (void)list_insert(&substrels,(dp)&rel);
    word_reset(&rel);
  }
  word_clear(&newrel); 
  word_clear(&rel); 
  list_clear(&newsubstrels); 

} 
    
static void
reorder_gens()
{
  word * tempw;
  gen * tempg;
  int i;
  int max=0;
  tempw=vzalloc2(word,num_gens+1);
  for (i=1;i<=num_gens;i++){ 
    word_init(tempw+i);
    word_cpy(user_gen_name+i,tempw+i);
  }
  for (i=1;i<=num_gens;i++) 
    if (inv_of[inv_of[i]]==i)
/* If i is the redundant inverse of an involution j=inv_of[i],
 renumber[i] = renumber[j]. The user name for j must be used for the
renumbered generator. */
      word_cpy(tempw+i,user_gen_name+renumber[i]);
  for (i=1;i<=num_gens;i++) 
    word_clear(tempw+i);
  Free_dp((dp)tempw); tempw=0;
  tempg=vzalloc2(gen,num_gens+1);
  for (i=1;i<=num_gens;i++)
    tempg[i]=inv_of[i];
  for (i=1;i<=num_gens;i++)
    if (tempg[tempg[i]]==i) /* i.e. i is not the redundant inverse of an
involution */
    	inv_of[renumber[i]]=renumber[tempg[i]];
  Free_dp((dp)tempg);
  for (i=1;i<=num_gens;i++)
  if (renumber[i]>max)
	max = renumber[i];
  num_gens = max;
}


