/* lib.d rfile input.c */
#include <stdio.h> 
#include <ctype.h>
#include "defs.h"
#include "input.h"
				
void
format_echocheck(number,rfile,wfile)
	char * number;
	FILE * rfile;
	FILE * wfile;
{
	char * string;
	string = vzalloc2(char,7);
	if (read_next_string(string,6,rfile)==FALSE){
		fprintf(stderr,"\t# Syntax error - no format version.\n");
		exit(2);
	}
	else {
		int i=0;
		int j;
		char * copy;

		fprintf(wfile,"Format %s\n",number);
		while (string[i]!='\0' && string[i]!=' ')
			i++;
/* so we see a null or blank character in position i */
		copy = vzalloc2(char,i+1);
		for (j=0;j<i;j++)
			copy[j] = string[j];
		copy[i] = '\0';
		if (strcmp(copy,number)!=0)
			fprintf(stderr,
		"\t# Warning,Expected Format %s, received Format %s\n", number,copy);
		Free_dp((dp)copy); copy=0;
	}
	Free_dp((dp)string); string=0;
}

void
format_check(number,rfile)
	char * number;
	FILE * rfile;
{
	char * string;
	string = vzalloc2(char,7);
	if (read_next_string(string,6,rfile)==FALSE){
		fprintf(stderr,"\t# Syntax error - no format version.\n");
		exit(2);
	}
	else {
		int i=0;
		int j;
		char * copy;

		while (string[i]!='\0' && string[i]!=' ')
			i++;
/* so we see a null or blank character in position i */
		copy = vzalloc2(char,i+1);
		for (j=0;j<i;j++)
			copy[j] = string[j];
		copy[i] = '\0';
		if (strcmp(copy,number)!=0)
			fprintf(stderr,
		"\t# Warning. Expected Format %s, received Format %s\n", number,copy);
		Free_dp((dp)copy); copy=0;
	}
	Free_dp((dp)string); string=0;
}
		
void
copy_to_format_check(number,rfile,wfile)
	char * number;
	FILE * rfile;
	FILE * wfile;
{
	char * string;
	string = vzalloc2(char,7);
	copy_to_next_string(rfile,wfile);
	read_next_string(string,6,rfile);
	if (strcmp(string,"Format")!=0||read_next_string(string,6,rfile)==FALSE){
		fprintf(stderr,"\t# Syntax error - no format version.\n");
		exit(2);
	}
	else {
		int i=0;
		int j;
		char * copy;

		fprintf(wfile,"Format %s\n",number);
		while (string[i]!='\0' && string[i]!=' ')
			i++;
/* so we see a null or blank character in position i */
		copy = vzalloc2(char,i+1);
		for (j=0;j<i;j++)
			copy[j] = string[j];
		copy[i] = '\0';
		if (strcmp(copy,number)!=0)
			fprintf(wfile,"\t# Expected Format %s, received Format %s\n",
																number,copy);
		Free_dp((dp)copy); copy=0;
	}
	Free_dp((dp)string); string=0;
}
		
void
bad_data()
{
	fprintf(stderr,"Bad data.\n");
	exit(2);
}


boolean
read_next_float(fp,rfile)
	float *fp;
	FILE * rfile;
{
	boolean ans=TRUE;
	int sign=1;
	int c;
	boolean fractional=FALSE;
	float multiplier=0.1;
	*fp=0;
	while ((c=getc(rfile))!=EOF && !(isdigit(c))){
		if (c=='-')
			sign = -1;
		else if (c=='}'){ 
			ungetc('}',rfile);
	/* a '}' is used to terminate the input */
			ans = FALSE;
			break;
		}
		else
			sign = 1;
	}
	if (ans==TRUE){ 
		do {
			if (c == '.' && fractional==FALSE) 
				fractional = TRUE;
			else {
				if (fractional==FALSE)
					*fp = c-'0' + 10*(*fp); 
				else {
					*fp += multiplier*(c-'0');
					multiplier *= 0.1;
				}
			}
			c=getc(rfile);
		} while ((isdigit(c))||(c=='.' && fractional==FALSE));
		ungetc(c,rfile);
	}
	if (c==EOF)  
		bad_data();
	*fp = sign * (*fp);
	return ans;
}
	
boolean read_next_int(kp,rfile)
	int * kp;
	FILE * rfile;
{
	boolean ans=TRUE;
	int sign=1;
	int c;
	*kp=0;
	while ((c=getc(rfile))!=EOF && !(isdigit(c))){
		if (c=='-')
			sign = -1;
		else if (c=='}' || c==';') {
	/* a '}' or ';' is used to terminate the input */
			ungetc(c,rfile);
			ans = FALSE;
			break;
		}
		else if (c=='#') /* comment symbol, skip to the next newline */
			while ((c=getc(rfile))!=EOF && c!='\n')
				;
		else
			sign = 1;
	}
	if (ans==TRUE) {
		do {
			if (c==EOF)
				break;
			else if (ans==FALSE)
				break;
			else
				*kp = 10*(*kp) + c - '0';
		} while (isdigit(c=getc(rfile)));
		ungetc(c,rfile);
	}
	if (c==EOF) 
		bad_data();
	*kp = sign*(*kp);
	return ans;
}
	
boolean read_next_letter(lp,rfile)
	int * lp;
	FILE * rfile;
{
	boolean ans=TRUE;
	while ((*lp=getc(rfile))!=EOF && !(isalpha(*lp)))
		if (*lp=='}') {
	/* a '}' is used to terminate the input */
			ungetc(*lp,rfile);
			ans = FALSE;
			break;
		}
	if (*lp==EOF) 
		bad_data();
	return ans;
}

/* The next complete string is read and the first n or less  non-null characters are
stored in cp. Any space between the last non-null character of the string
and 
 the terminating null character of cp is filled
with blank spaces.  Spaces, tabs and
returns, and also matched pairs {} (and all the stuff between them) are skipped 
over until other symbols are met. The string is terminated by a tab, space,
return , (,), { or } (which remains unread ).
Comments (preceded by # and terminated by a return are completely ignored.
A string beginning with } causes the function to stop
reading and return false.  The } is then returned to the buffer as if
unread.
*/
boolean
read_next_string(cp,n,rfile)
	char * cp;
	int n;
	FILE * rfile;
{
	int i=0;
	int c;
	boolean ans=TRUE;
	while ((c=getc(rfile))!=EOF){
		if (i==0){
			if ( c=='}' ) {
				ungetc(c,rfile);
				return  FALSE;
			}
			else if (c=='#') /* skip over comments */
				do {
					c=getc(rfile);
				} while (c!='\n');
			else if (c=='\{'){ /* skip over {}'s */
				int count=1;
				while (count>0){
					if  ((c=getc(rfile))=='\{')
						count++;
					else if (c=='\}')
						count--;
				}
			}
			else if (c==' '||c=='\t'||c=='\n')
				continue;
			else{
				cp[0]=c;
				i=1;
			}
		}
		else if (i>0){
	if (c==' '||c=='\t'||c=='\n'||c=='\{'||c=='\}'||c=='\('||c=='\)'||c=='#') {
					ungetc(c,rfile);
					break;
			}
			else { 
				if (i<n)
					cp[i++]=c;
			}
		}
	}
	if (c==EOF){
		ans = FALSE;
		i=0; /* if the function's returning false, we'd like to empty the
string */
	}
	while (i<n)
		cp[i++]=' ';
	cp[n]='\0';
	return ans;
}

/* we assume we're at the start of a string (assumed not to contain any
blank spaces). We read  the whole of it (as
far as the next string terminating symbol, as specified in
read_next_string) and compare it with
the given string of length n. If the first n characters match we return TRUE. Otherwise
the whole string is copied into standard output. */
boolean
copy_or_match_string(cp,number,rfile,wfile)
	char * cp;
	char * number;
	FILE * rfile;
	FILE * wfile;
{
	int i=0;
	int c;
	boolean ans=FALSE;
	char * string;
	int n=0;
	while (cp[n]!='\0')
		n++;
	if (n<6)
		n = 6;
	string = vzalloc2(char,n+1);
/* string is longer enough to read a string as long as either *cp or Format
*/
	while (i<n && (c=getc(rfile))!=EOF){
		if (c==' '||c=='\t'||c=='\n'||c=='\{'
					||c=='\}'||c=='\('||c=='\)'||c=='#') {
			ungetc(c,rfile);
			break;
		}
		else
			string[i++]=c;
	}
	string[i] = '\0';
	if (strcmp(string,cp)==0)
		ans = TRUE;
	else if (strcmp(string,"Format")==0)
		format_echocheck(number,rfile,wfile);
	else {
	/* print out what we've read so far */
		i=0;
		while (string[i]!='\0'){
			fprintf(wfile,"%c",string[i]);
			i++;
		}
/* read the rest of the string if there's any of it left to be read */
		while ((c=getc(rfile))!=EOF ){
			if (c==' '||c=='\t'||c=='\n'||c=='\{'
						||c=='\}'||c=='\('||c=='\)'||c=='#') {
				ungetc(c,rfile);
				break;
			}
			else 
				fprintf(wfile,"%c",c);
		}
	}
	Free_dp((dp)string); string=0;
		
	if (c==EOF){
/* we shouldn't reach an EOF symbol with this function */
		ans = FALSE;
		fprintf(stderr,"\t# Warning. EOF reached. I don't think that's right.\n");
	}
	return ans;
}


/* copies from rfile to standard output 
all the stuff preceding the next string that will be read by
read_next_string. Returns false if there is no such string */
boolean
copy_to_next_string(rfile,wfile)
	FILE * rfile;
	FILE * wfile;
{
	int c;
	while ((c=getc(rfile))!=EOF){
		if ( c=='}' ){ 
			ungetc(c,rfile);
			return FALSE;
		}
		else if (c=='#'){ /* skip over comments */
			fprintf(wfile,"%c",c);
			do {
				c=getc(rfile);
				fprintf(wfile,"%c",c);
			} while (c!='\n');
		}
		else if (c=='\{'){ /* skip over {}'s */
			int count=1;
			fprintf(wfile,"%c",c);
			while (count>0){
				if  ((c=getc(rfile))=='\{')
					count++;
				else if (c=='\}')
					count--;
				fprintf(wfile,"%c",c);
			}
		}
		else if (c==' '||c=='\t'||c=='\n'){
			fprintf(wfile,"%c",c);
			continue;
		}
		else{
/* we've found the start of a string. Put it back to be read again */
			ungetc(c,rfile);
			return TRUE;
		}
	}
/* we only get to this point if we reach end of rfile without meeting a
string */
	return FALSE;
}

boolean
find_keyword(label,rfile)
	char * label;
	FILE * rfile;
{
	char * string;
	boolean found=TRUE;
	int k=0;
	while (label[k]!='\0')
		k++;
	string = vzalloc2(char,k+1);
	do {
		found=TRUE;
		if (read_next_string(string,k,rfile)==FALSE){
			found = FALSE;
			break;
		}
	} while ((strcmp(string,label)!=0));
	Free_dp((dp)string); string=0;
	return found;
}

boolean
copy_to_keyword(label,number,rfile,wfile)
	char * label;
	char * number;
	FILE * rfile;
	FILE * wfile;
{
	boolean found=TRUE;
	do {
		found=TRUE;
		if (copy_to_next_string(rfile,wfile)==FALSE){
			found = FALSE;
			break;
		}
		found =  copy_or_match_string(label,number,rfile,wfile);
	} while (found == FALSE);
	return found;
}

