/*====================================================================
     Make.c   This file contains the functions that build up the face, 
  edge, and vertex structures. 
  ===================================================================*/

#include "structs.h"
#include "macros.h"

/*----------------------------------------------------------------------
       Make_structs makes a new face and two new edges between the 
  edge and the point that are passed to it. It returns a pointer to
  the new face.
 ----------------------------------------------------------------------*/
struct tface *make_structs( e, p )
struct tedge *e;
struct tvertex *p;
{
	register struct tedge *new_edge[2];
                 struct tedge *make_edge();
        register struct tface *new_face;
                 struct tface *make_face();
        register int i, j;

        for ( i=0; i < 2; ++i ) 
              if ( !( new_edge[i] = e->endpts[i]->duplicate) ) {
                 /* if the edge does not already exist, make it */
                 new_edge[i] = make_edge();
                 new_edge[i]->endpts[0] = e->endpts[i];
                 new_edge[i]->endpts[1] = p;
                 e->endpts[i]->duplicate = new_edge[i];
                 }

        /* make the new face */
        new_face = make_face();   
        new_face->edg[0] = e;
        new_face->edg[1] = new_edge[0];
        new_face->edg[2] = new_edge[1];
        make_ccw( new_face, e, p ); 
        pre_vol( new_face );
        
        /* set the adjacent face pointers */
        for ( i=0; i < 2; ++i )
              for ( j=0; j < 3; ++j )  
                    if ( !new_edge[i]->adjface[j] ) {
                          new_edge[i]->adjface[j] = new_face;
                          break;
                          }
        
        return new_face;
}

/*------------------------------------------------------------------------
      Make_ccw puts the vetices in the face structure in counter
  clockwise order.  If there is no adjacent face[1] then we know that
  we are working with the first face of the initial tetrahedron.  In this
  case we want to store the vertices in the opposite order from the 
  initial face.  Otherwise, we want to store the vertices in the same order
  as in the visible face.  The third vertex is always p.
  ------------------------------------------------------------------------*/
make_ccw( f, e, p )
struct tface *f;
struct tedge *e;
struct tvertex *p;
{
        register int i;
        register struct tface *fv;
        
        if ( !e->adjface[1] ) {
             /* if this is the initial triangle */
             fv = e->adjface[0];
        
             /* find the index of endpoint[1] */
             for ( i=0; fv->vert[i] != e->endpts[1]; ++i )
                   ;
             /* put the vertices in the opposite order of fv */
             if ( fv->vert[ (i+1) % 3 ] != e->endpts[0] ) {
                  f->vert[0] = e->endpts[1];  
                  f->vert[1] = e->endpts[0];    
                  }
             else {                               
                  f->vert[0] = e->endpts[0];   
                  f->vert[1] = e->endpts[1];      
                  }
             }
        
        else {
             /* otherwise,  set the visible face */
             if  ( e->adjface[0]->visible )      
                   fv = e->adjface[0];
             else fv = e->adjface[1];
        
             /* find the index of endpoint[1] */
             for ( i = 0; fv->vert[i] != e->endpts[1] ; ++i )  
                   ;    				
        
             /* put the vertices in the same order as fv */
             if ( fv->vert[ (i+1) % 3 ] != e->endpts[0] ) {
                  f->vert[0] = e->endpts[0];     
                  f->vert[1] = e->endpts[1];     
                  }
             else {     
                  f->vert[0] = e->endpts[1];     
                  f->vert[1] = e->endpts[0]; 
                  } 
              }
 
        f->vert[2] = p;
}
 
/*---------------------------------------------------------------------
      Make_edge creates a new cell and initializes all pointers to NULL
   and sets all flags to off.  It returns a pointer to the empty cell.
  ---------------------------------------------------------------------*/
struct tedge *make_edge()
{
	register struct tedge *new;

        ALLOCATE( new, struct tedge );
        new->adjface[0] = new->adjface[1] = new->adjface[2] = NULL;
        new->endpts[0] = new->endpts[1] = NULL;
        new->deleted = !DELETED;
        ADD_QUEUE( edges, new );
        return new;
}

/*---------------------------------------------------------------------
     Make_face creates a new face structure and initializes all of its
  flags to NULL and sets all the flags to off.  It returns a pointer
  to the empty cell.
 ----------------------------------------------------------------------*/
struct tface *make_face()
{
	register struct tface *new;
	register int i;

	ALLOCATE( new, struct tface);
	for ( i=0; i < 3; ++i ) {
    	      new->edg[i] = NULL;
    	      new->vert[i] = NULL;
    	      }
	new->visible = !VISIBLE;
	ADD_QUEUE( faces, new );
	return new;

}
