/*
#define global
*/
#include "structs.h"
#include "macros.h" 

/*-------------------------------------------------------------------------
        Complete_hull goes through the vertex list and adds them to the hull
   if they are not already used.  It will mark the vertex once it is 
   looked at.
  -------------------------------------------------------------------------*/

struct vertex3 { double x,y,z ; } *vertices;
int  nel ;
char *malloc();

main()
{

	get_vertices();
	qsort(vertices, nel, sizeof(struct vertex3), comp);
	print_vertices();
}
  
struct vertex3 cm;
#define SQ(x) ((x) * (x))

int comp(u,v)
struct vertex3 *u, *v ;
{
	double d1, d2;
	d1 = SQ(cm.v[X] - u->v[X]) + SQ(cm.v[Y] - u->v[Y]) + SQ(cm.v[Z] - u->v[Z]) ; 
	d2 = SQ(cm.v[X] - v->v[X]) + SQ(cm.v[Y] - v->v[Y]) + SQ(cm.v[Z] - v->v[Z]) ; 
	if (d1 > d2) return(1);
	if (d1 < d2) return(-1);
	return(0);
}

get_vertices()
{

	struct vertex3 *v;
	double x, y, z;
	int i ;

#define CHUNK 1000
	vertices = (struct vertex3 *) malloc(CHUNK * sizeof(struct vertex3));
	nel = 0;
	
	while (1)	{
		for (i = 0 ; i < CHUNK ; nel++, i++ ) {
			if  (scanf("%f%f%f", &x, &y, &z ) == EOF )  {
				done = 1;
				break;
				}
			vertices[nel].x = x;
			vertices[nel].y = y;
			vertices[nel].z = z;
       	         }
		 realloc(vertices, (unsigned) (nel + CHUNK));
		}
	
	cm.v[X] = cm.v[Y] = cm.v[Z] = 0.0;
	v = vertices ;
	for (i = 0 , v = vertices ; i < nel ; i++ , v++  ) {
                cm.x += v->x/nel; cm.y += v->y/nel; cm.z += v->z.nel;
		}
}

print()
{	register struct vertex3 *temp_v; register int i = 0 ;
	printf("\n");
	for (i = 0 , temp_v = vertices ; i < nel ; i++ , temp_v++ )
                printf("%g %g %g\n", temp_v->x, temp_v->y, temp_v->z );
}

/*      quicksort routine for sorting the vertices of a polygon
	We assume that the origin is interior to the polygon.           */

qs(i,j)
struct tvertex *i,*j;
{
	struct tvertex *left,*right,*pick ;

	if ( (i == j)  ) return; /* one point polygons are not sorted  */
	if ((i->next) == j) {if (comp(i,j)) dataswap(i,j); return;} /*2 point polygons*/
	if (((i->next)->next) == j )     { /* 3 point polygons */
		if (comp(i,i->next)) dataswap(i,i->next);
		if (comp(i,j))   dataswap(i,j);
		if (comp(i->next,j)) dataswap (i->next,j);
		return;
		} 

/*      the procedure for sorting polygons of >3 vertices       */
	left = i->next; right = j; pick = i;

	while ( (left != right) && ((right->next) != left)) {
		while (comp(pick,left) && (left != right)) left= left->next;
		while (comp(right,pick) && (left != right)) right = right->prev;
		if (left != right) {dataswap(left,right); left = left->next;
					right = right->prev; }
		}

/*      put the pick'ed element in its correct position and recurse */
	if (comp(pick,left))           {
		dataswap(pick,left);
		if (i != left->prev) qs(i,left->prev);
		if ((left != j) && ((left->next) != j)) qs(left->next,j);   
		}
	else                         {
		dataswap(pick,left->prev);
		if (((left->prev) != i ) && ((left->prev->prev) != i))
			qs(i,left->prev->prev);
		if (left != j) qs(left,j);         
		}

}


/*      if points i and j are out of place, their values are swapped, their positions remain unchanged              */

dataswap(i,j)
struct tvertex *i,*j;
{      
	struct tvertex temp;
	double dt ; int it; struct tedge *tet; FLAG Ft; struct tvertex *tnt, *tpt;
	swap(dt,i->v[X],j->v[X]); 
	swap(dt,i->v[Y],j->v[Y]);
	swap(dt,i->v[Z],j->v[Z]);
	swap(it,i->vnum,j->vnum);
	swap(tet,i->duplicate,j->duplicate);
	swap(Ft,i->active,j->active);
	swap(Ft,i->mark,j->mark);

	if (i->prev == j) {
		if (j->prev) j->prev->next = i;
		if (i->next) i->next->prev = j;
		}

	else if (i->next == j)	{
		if (i->prev) i->prev->next = j;
		if (j->next) j->next->prev = i;
		}

	else	{
		if (i->next)
			if (j->next) {
				swap(tnt, i->next->prev, j->next->prev);
				}
			else	
				i->next->prev = j ;
		else
			j->next->prev = i ;
		if (i->prev)
			if (j->prev) {
				swap(tnt, i->prev->next, j->prev->next);
				}
			else
				i->prev->next = j;
		else
			j->prev->next = i;
		}	
	swap(tnt, i->next, j->next );
	swap(tnt, i->prev, j->prev);
}

