#include	<stdio.h>
#include	<ctype.h>
#include	<X11/Intrinsic.h>
#include	<X11/VPaned.h>
#include	<X11/Box.h>
#include	<X11/Text.h>
#include	<X11/AsciiText.h>
#include	<X11/cursorfont.h>
#include	<Xw/Xw.h>
#include	<Xw/PButton.h>
#include	<Xw/Toggle.h>

#include	"cmap.h"

extern void	slaveWindow();	/* Forward */

Widget	spline_button, rgb_button, file_name;
char	filenamebuf[128];


void
panelMessage(fmt, p1, p2, p3, p4, p5)
    char *fmt;
    long p1, p2, p3, p4, p5;
{
    Arg arg;
    char buf[256];
    XtTextBlock xtb;

    sprintf(buf, fmt, p1, p2, p3, p4, p5);
    XtTextSetInsertionPoint(file_name, (XtTextPosition)0);
    XtTextSetLastPos(file_name, (XtTextPosition)0);
    xtb.firstPos = 0;
    xtb.length = strlen(buf);
    xtb.ptr = buf;
    xtb.format = FMT8BIT;
    XtTextReplace(file_name, (XtTextPosition)0, (XtTextPosition)0, &xtb);
    XtTextSetInsertionPoint(file_name, (XtTextPosition)0);
}

/*
 * Toggle between "spline" and "linear" modes.
 * Change our button label, redraw all boxes
 */
void
setSpline(w, client_data, call_data)
    Widget	w;
    caddr_t	client_data, call_data;
{
	Arg	arg[2];
	int	i;
	int	now = (int)client_data ? TRUE : FALSE;

	if(spline != now) {
	    spline = (int)client_data ? TRUE : FALSE;
	    XtSetArg(arg[0], XtNlabel,
		(XtArgVal) (spline ? "Spline" : "Linear"));
	    XtSetArg(arg[1], XtNset, (XtArgVal) spline);
	    XtSetValues(spline_button, arg, 2);

	    for(i = 0; i < NBOX; i++)
		redo(i, 0, cbox[i].count-1, RECALC);
	}
}

int
getPanel(w, buf, len)
    Widget	w;		/* asciiStringWidget to get name from */
    char	*buf;
    int		len;
{
    XtTextPosition firstpos, lastpos;
    char *name;

    /*
     *	Get the file name
     */
    firstpos = XtTextTopPosition(w);
    lastpos = XtTextGetInsertionPoint(w);
    name = filenamebuf;

    /* strip leading white space */
    while(firstpos < lastpos && isspace(name[firstpos]))
	firstpos++;

    if(lastpos > firstpos+len-1) {
	panelMessage("Name too long, %d chars max", len-1);
	return(-1);
    }
    memcpy(buf, name+firstpos, lastpos-firstpos);
    buf[lastpos-firstpos] = '\0';
    return(lastpos-firstpos);
}

void
fileSave(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	char fname[128];

	if(getPanel(file_name, fname, sizeof(fname)-8) < 0)
		return;
	file_save(fname, (int)client_data);
}

void
fileLoad(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	char fname[128];

	if(getPanel(file_name, fname, sizeof(fname)-8) < 0)
		return;
	file_load(fname);
}


void
initButtons(parent)
    Widget	parent;
{
    Arg		arg[10];
    Widget	fu;
    Widget	filer;

    /*
     *	File handler part
     */
    filer = XtCreateManagedWidget( "file", boxWidgetClass, parent, arg, 0 );

    /*
     *	text Box for file name 
     */
    XtSetArg(arg[0], XtNeditType, (XtArgVal) XttextEdit);
    XtSetArg(arg[1], XtNwidth, (XtArgVal) 256);
    XtSetArg(arg[2], XtNlength, (XtArgVal) 64);
    XtSetArg(arg[3], XtNstring, (XtArgVal) filenamebuf);
    XtSetArg(arg[4], XtNinsertPosition, (XtArgVal)0);
    XtSetArg(arg[4], XtNdisplayPosition, (XtArgVal)0);
    file_name = XtCreateManagedWidget("filename", asciiStringWidgetClass,
				      filer, arg, 6);

    /*
     *	File handler commands
     */
    XtSetArg(arg[0], XtNlabel, (XtArgVal)"Save");
    fu = XtCreateManagedWidget("Save", XwpushButtonWidgetClass, filer, arg, 1);
    XtAddCallback(fu, XtNselect, fileSave, (caddr_t)0);

    XtSetArg(arg[0], XtNlabel, (XtArgVal)"Save+Table");
    fu = XtCreateManagedWidget("Save+Table", XwpushButtonWidgetClass, filer, arg, 1);
    XtAddCallback(fu, XtNselect, fileSave, (caddr_t)1);

    XtSetArg(arg[0], XtNlabel, (XtArgVal)"Quit");
    fu = XtCreateManagedWidget("Quit", XwpushButtonWidgetClass, filer, arg, 1);
    XtAddCallback(fu, XtNselect, quit, (caddr_t)0);

    XtSetArg(arg[0], XtNlabel, (XtArgVal)"Load");
    fu = XtCreateManagedWidget("Load", XwpushButtonWidgetClass, filer,
			       arg, 1);
    XtAddCallback(fu, XtNselect, fileLoad, (caddr_t)0);

    XtSetArg(arg[0], XtNlabel, (XtArgVal)"Reset");
    fu = XtCreateManagedWidget("Reset", XwpushButtonWidgetClass, filer,
			       arg, 1);
    XtAddCallback(fu, XtNselect, reset_boxes, NULL);

    if(has_color) {
	XtSetArg(arg[0], XtNlabel, (XtArgVal)"Slave");
	fu = XtCreateManagedWidget("Slave", XwpushButtonWidgetClass, filer,
				   arg, 1);
	XtAddCallback(fu, XtNselect, slaveWindow, NULL);
    }

#ifndef NOPIXAR
    XtSetArg(arg[0], XtNlabel, (XtArgVal)"Pixar");
    fu = XtCreateManagedWidget("Pixar", XwtoggleWidgetClass, filer, arg, 1);
    XtAddCallback(fu, XtNselect, turnPixar, (caddr_t)1);
    XtAddCallback(fu, XtNrelease, turnPixar, (caddr_t)0);
#endif /*has PIXAR*/

    XtSetArg(arg[0], XtNlabel, (XtArgVal)schemename[0]);
    fu = XtCreateManagedWidget("Color", XwpushButtonWidgetClass, filer, arg, 1);
    XtAddCallback(fu, XtNselect, setScheme, (caddr_t)-1);
    rgb_button = fu;

#ifdef notnow
    /* We don't use linear vs. spline mode, anyway. */
    XtSetArg(arg[0], XtNlabel, (XtArgVal)"Linear");
    fu = XtCreateManagedWidget("Spline", XwtoggleWidgetClass, filer, arg, 1);
    XtAddCallback(fu, XtNselect, setSpline, (caddr_t)1);
    XtAddCallback(fu, XtNrelease, setSpline, (caddr_t)0);
    spline_button = fu;
#endif /* has linear/spline mode */

}

/*
 * Routine to let user select a window using the mouse
 * Swiped from xwininfo
 */

Window
Select_Window(dpy, screen)
    Display *dpy;
    int screen;
{
  int status;
  Cursor cursor;
  XEvent event;
  Window target_win = None;
  int buttons = 0;

  /* Make the target cursor */
  cursor = XCreateFontCursor(dpy, XC_crosshair);

  /* Grab the pointer using target cursor, letting it roam all over */
  status = XGrabPointer(dpy, RootWindow(dpy, screen), False,
			ButtonPressMask|ButtonReleaseMask, GrabModeSync,
			GrabModeAsync, None, cursor, CurrentTime);
  if (status != GrabSuccess) {
	panelMessage("Can't grab the mouse");
	return(0);
  }

  /* Let the user select a window... */
  while ((target_win == None) || (buttons != 0)) {
    /* allow one more event */
    XAllowEvents(dpy, SyncPointer, CurrentTime);
    XWindowEvent(dpy, RootWindow(dpy, screen),
		 ButtonPressMask|ButtonReleaseMask, &event);
    switch (event.type) {
    case ButtonPress:
      if (target_win == None) {
	target_win = event.xbutton.subwindow; /* window selected */
      }
      buttons++;
      break;
    case ButtonRelease:
      if (buttons > 0) /* there may have been some down before we started */
	buttons--;
       break;
    }
  } 

  XUngrabPointer(dpy, CurrentTime);      /* Done with pointer */

  return(target_win);
}

void
slaveWindow(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	Window win;
	int res;
	char msg[32];
	XWindowAttributes wa;

	if((res = getPanel(file_name, msg, sizeof(msg))) == 0 ||
			(win = strtol(msg, NULL, 16)) == 0) {
		panelMessage("Click on window to enslave to our colormap");
		win = Select_Window(XtDisplay(w), XtScreen(w));
	}
	if(win != None) {
		Window root, parent;
		Window *brats;
		int i, nbrats;

		XSetWindowColormap (XtDisplay(w), win, color_map);
		XQueryTree(XtDisplay(w), win, &root, &parent, &brats, &nbrats);
		for(i = 0; i < nbrats; i++)
			XSetWindowColormap(XtDisplay(w), brats[i], color_map);
		XFree(brats);
		XInstallColormap(XtDisplay(w), color_map);
	}
}
