/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/*************************************************************
/*
/*    file:      save.c
/*
/*    Purpose:   Save and restore surface in internal format.
*/



/****************************************************************
*
*  File: save.c
*
*  Functions: do_save(), do_restore()
*
*  Purpose: Save and restore evolver internal state.
* 
*  This version for 32 bit architectures.
*/

#include "include.h"
#define VERSIZE 50
static char version[VERSIZE] = "EVOLVER save file version 9-22-89 unseg ";

void do_save()
{
  int i,j;

  fwrite(version,sizeof(version),1,savefd);
  fwrite((char *)wulff_vector,MAXWULFF*3,sizeof(double),savefd);

  for ( i = 0 ; i < 4 ; i++ ) 
    fwrite((char *)view[i],4,sizeof(REAL),savefd);

  fwrite((char *)&web,sizeof(web),1,savefd);
  for ( i = 0 ; i < NUMELEMENTS ; i++ )
     {
       fwrite(web.skel[i].base,sizes[i],web.skel[i].maxcount,savefd);
     }
  fwrite((char *)web.inverse_periods[0],sizeof(REAL),9,savefd);

  /* save free boundary information */
  for ( i = 0 ; i < BDRYMAX ; i++ )
    { struct boundary *b = web.boundaries + i;
      if ( b->pcount )
      {
        for ( j = 0 ; j < web.space_dimension ; j++ )
          {
            fwrite((char *)b->coordf[j],b->cesize[j],1,savefd);
          }
        for ( j = 0 ; j < MAXPARAM ; j++ )
          {
            fwrite((char *)b->envect[j],b->eesize[j],1,savefd);
            fwrite((char *)b->convect[j],b->consize[j],1,savefd);
          }
      }
    }


  /* save constraint information */
  for ( i = 0 ; i < CONSTRMAX ; i++ )
    { struct constraint *b = web.constraints + i;
      if ( b->fsize )
      {
        fwrite((char *)b->formula,b->fsize,1,savefd);
        for ( j = 0 ; j < web.space_dimension ; j++ )
          {
            fwrite((char *)b->envect[j],b->evsize[j],1,savefd);
            fwrite((char *)b->convect[j],b->cvsize[j],1,savefd);
          }
      }
    }

  fclose(savefd);
}



void do_restore()
{
  int i,j;
  char fileversion[VERSIZE];

  fread(fileversion,sizeof(version),1,savefd);
  if ( strcmp(fileversion,version) != 0 )
   {    
     sprintf(msg,"File is wrong version: %s \n",fileversion);
     error(msg,RECOVERABLE);
     return;
   }
  reset_web();

  fread((char *)wulff_vector,MAXWULFF*3,sizeof(double),savefd);

  for ( i = 0 ; i < 4 ; i++ ) fread((char *)view[i],4,sizeof(REAL),savefd);

  fread((char *)&web,sizeof(web),1,savefd);
  for ( i = 0 ; i < NUMELEMENTS ; i++ )
     {
       if ( (base[i] = calloc(sizes[i],web.skel[i].maxcount)) == NULL )
         error("Cannot allocate memory\n",UNRECOVERABLE);
       web.skel[i].base = base[i];
       fread(web.skel[i].base,sizes[i],web.skel[i].maxcount,savefd);
     }
  fread((char *)web.inverse_periods[0],sizeof(REAL),9,savefd);
  vbase = web.skel[0].base;
  ebase = web.skel[1].base;
  fbase = web.skel[2].base;
  bbase = web.skel[3].base;
  febase = web.skel[4].base;

  vvbase = (struct vertex *)web.skel[0].base;
  eebase = (struct edge *)web.skel[1].base;
  ffbase = (struct facet *)web.skel[2].base;
  bbbase = (struct body *)web.skel[3].base;
  fefebase = (struct facetedge *)web.skel[4].base;

  /* get free boundary information */
  for ( i = 0 ; i < BDRYMAX ; i++ )
    { struct boundary *b = web.boundaries + i;

      if ( b->pcount )
       {
        for ( j = 0 ; j < web.space_dimension ; j++ )
          { 
            b->coordf[j] = (struct expnode *)malloc(b->cesize[j]);
            fread((char *)b->coordf[j],b->cesize[j],1,savefd);
          }
        for ( j = 0 ; j < MAXPARAM ; j++ )
          {
            b->envect[j] = (struct expnode *)malloc(b->eesize[j]);
            fread((char *)b->envect[j],b->eesize[j],1,savefd);
            b->convect[j] = (struct expnode *)malloc(b->consize[j]);
            fread((char *)b->convect[j],b->consize[j],1,savefd);
          }
       }
    }

  /* get constraint information */
  for ( i = 0 ; i < CONSTRMAX ; i++ )
    { struct constraint *b = web.constraints + i;

      if ( b->fsize )
      {
        b->formula = (struct expnode *)malloc(b->cvsize[j]);
        fread((char *)b->formula,b->cvsize[j],1,savefd);
        for ( j = 0 ; j < web.space_dimension ; j++ )
          {
            b->envect[j] = (struct expnode *)malloc(b->evsize[j]);
            fread((char *)b->envect[j],b->evsize[j],1,savefd);
            b->convect[j] = (struct expnode *)malloc(b->cvsize[j]);
            fread((char *)b->convect[j],b->cvsize[j],1,savefd);
          }
       }
    }


  fclose(savefd);
}


