/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/


/********************************************************************
*
*  File: storecpp.h     C++ version
*
*  Purpose:  Header file defining details of storage implementation.
*            All machine-dependent gory details should be here
*            (for inclusion in other source files that need to know)
*            or in storage.cpp (purely private details).
*
*     This version has element ids typed as pointers.
*     Low bit used as orientation sign.
*     Elements individually allocated.
*/

#define NUMELEMENTS 5

/* these values used for identification and as index into skeleton info */
#define  VERTEX  0
#define  EDGE    1
#define  FACET   2
#define  BODY    3
#define  FACETEDGE    4 

/* masks for fields */
#define SIGNMASK   0x00000001
#define POINTERMASK 0xFFFFFFFE

#define NULLID NULL 

/* to get type of an element */
#define id_type(id)  (elptr(id)->type)

/* to give switched orientation of first if that of second is inverted */
#define same_sign(id1,id2)    ((id1) ^ ((id2) & SIGNMASK))

/* outside storage.*, element_id structure is not visible; acts like long */    
typedef long
     element_id, vertex_id, edge_id, facet_id, body_id, facetedge_id; 

/* macros for getting structure pointer from id */
#define elptr(id)  ((struct element *)((id)&POINTERMASK))
#define vptr(v_id) ((struct vertex *)((v_id)&POINTERMASK))
#define eptr(e_id) ((struct edge   *)((e_id)&POINTERMASK))
#define fptr(f_id) ((struct facet  *)((f_id)&POINTERMASK))
#define bptr(b_id) ((struct body   *)((b_id)&POINTERMASK))
#define feptr(fe_id) ((struct facetedge *)((fe_id)&POINTERMASK))

#define edge_inverse(id)  inverse_id(id)
#define facet_inverse(id)  inverse_id(id)
#define fe_inverse(id)  inverse_id(id)
#define invert(id)     ((id) ^= SIGNMASK)
#define equal_id(a,b)  ((a)==(b))
#define equal_element(a,b)  (((a)|SIGNMASK) == ((b)|SIGNMASK))
#define valid_id(id)   ((id)&POINTERMASK)
#define inverted(id)   ((id)&SIGNMASK)
#define inverse_id(id) ((id) ^ SIGNMASK)

typedef int ORDTYPE;                /* element numbering type */

/* base structure for a skeleton of a particular dimension */
struct skeleton {
    int             type;   /* type of element, see defines above */
    long            maxcount; /* elements allocated          */
    element_id      used;   /* start of in-use elements  */
    element_id      last;   /* end of in-use chain, for adding on */
    element_id      discard; /* start of discard list */
    long            count;  /* number active             */
    element_id      current; /* current element in generation */
    ORDTYPE         max_ord; /* highest ordinal */
  } ;

#define NOFREELIST
