/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */




/*
  $Header: /usr2/gcg/grap/src/lib/oogl/libcontext/RCS/context.h,v 1.5 90/05/07 14:15:42 meuer Exp Locker: slevy $
  $Source: /usr2/gcg/grap/src/lib/oogl/libcontext/RCS/context.h,v $


  Header file for the context objects.

  Mark Meuer


  Context Object
  OOGL
  */


#ifndef	CONTEXT_HEADER
#define	CONTEXT_HEADER

/* MACROS */
#define	ERROR_STRING_SIZE	200
#ifndef	NULL
#define	NULL 			0
#endif
#define	CONTEXT_ERROR		-1
#define	VALUE_NOT_FOUND		0
#define	BUFFER_TOO_SMALL	1
#define	CONTEXT_SUCCESS		2
#define	CONTEXT_TRUE		3
#define	CONTEXT_FALSE		4

#define	MIN(a,b)		( (a) < (b) ? (a) : (b) )


/* Macros for the context type field */
#define	WINDOW_CONTEXT		0
#define	OBJECT_CONTEXT	       	1

/* TYPE DEFINTIONS */
typedef char    VOID;		/* This is because the mips c compiler doesn't handle void correctly */
typedef struct ContextField	/* One field of the object */
{
	char           *name;	/* Name of the field */
	VOID           *value;	/* Field value */
	int             value_size;	/* Size in btytes of the field value */
	struct ContextField *next_field;	/* The next field in the list */
}               ContextField;

typedef struct ContextObject	/* The context object */
{
	int             type;	/* The type of the context object. */
	ContextField   *fields;	/* Linked list of the fields */
}               ContextObject;

/* VALUE DEFINITIONS */
extern	int	TrueValue;
extern	int	FalseValue;

/* FUNCTION DECLARATIONS */
extern	ContextObject  *AddContextField( ContextObject *list, ContextField *new_field);
extern	void            FreeContextField( ContextField *field );
extern	void            FreeContextObject( ContextObject * object );
extern	int		TruthValue( ContextObject *list, char *name );
extern	ContextField   *NewContextField( int name_length, int value_length );
extern	ContextObject  *NewContextObject( int type );
extern	int             ReadContextField( ContextObject *list, char *name, VOID *target, int maximum_size );
extern	ContextObject  *WriteContextField( ContextObject *list, char *name, VOID *value, int value_size );
extern  ContextObject  *WriteContextInt( ContextObject *, char *name, int v );
extern	ContextObject  *WriteContextFloat( ContextObject *, char *name, float v );
extern	int		ReadContextInt( ContextObject *, char *, int defaultv );
extern	float		ReadContextFloat( ContextObject *, char *, float defaultv );

#define	SetFalse(list, name)	WriteContextInt(list, name, 0)
#define	SetTrue(list, name)	WriteContextInt(list, name, 1)

#endif
