


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef QUADDEFS
#define QUADDEFS


#include "oogl/geomclass.h"
#include "oogl/bbox.h"

#define QUAD_P VERT_P
#define QUAD_N VERT_N
#define QUAD_C VERT_C
#define QUAD_BINARY 0x4

typedef Point3 QuadP[4];
typedef Point3 QuadN[4];
typedef ColorA QuadC[4];

typedef struct {
    int quadflag;
    int maxquad;
    QuadP *p;
    QuadN *n;
    QuadC *c;
} Quad;

extern GeomClass *QuadMethods( void );
extern char *QuadName( void );
extern Quad *QuadPrint( Quad * );
extern Quad *QuadCopy( Quad * );
extern Quad *QuadLoad( char * );
extern Quad *QuadFLoad( FILE * );
extern Quad *QuadSave( Quad *, char * );
extern Quad *QuadFSave( Quad *, FILE * );
extern Quad *QuadDelete( Quad * );
extern BBox *QuadBound( Quad *, Transform );
extern Quad *QuadEvert( Quad * );
extern Quad *QuadDraw( Quad *, ContextObject *object_context );
extern Quad *QuadDrawIrisGl( Quad *, ContextObject *object_context );
extern Quad *QuadDrawRenderman( Quad *, ContextObject *object_context );
extern Quad *QuadDrawXWindows( Quad *, ContextObject *object_context );

#ifdef GEOM_SM
GeomRef QuadShare( );
GeomRef QuadPrivate( );
#endif

#endif
