
/*
  $Header: /usr2/meuer/Geom_utilities/Arc2list/RCS/breakarc.h,v 1.1 91/02/05 15:11:09 meuer Exp $

  Header file for the breakarc program.

  Mark Meuer
  #1267045

  */

#ifndef	BREAKARC_HEADER
#define	BREAKARC_HEADER

/* STANDARD INCLUDE FILES */
#include	<stdio.h>

/* MACROS */
#ifndef	TRUE
#define	TRUE	1
#endif
#ifndef	FALSE
#define	FALSE	0
#endif

/*
These macros are a hack to get rid of prototype argument for compilers (like the SUN) that won't allow them.
*/
#ifdef	sun
#define	ARGSLIST(x)	()
#else
#define	ARGSLIST(x)	x
#endif

#define	ERROR_STRING_LENGTH	512

/* FUNCTION PROTOTYPES */
double	ArcLength ARGSLIST( (double pnt1[3], double pnt2[3]) );
int	DivideArc ARGSLIST( (double pnt1[3], double pnt2[3], int num, double *arc) );
void	fatal_error ARGSLIST( (char *message) );
FILE	*open_file ARGSLIST( (char name[], char permissions[]) );
void	parse_command_line ARGSLIST( (int argc, char **argv, char **in_file, char **out_file, double *arc_size) );
void	process_arcs ARGSLIST( (FILE *in_file, FILE *out_file, double arc_size) );
void	usage ARGSLIST( ( char *prog_name ) );
     
#endif	/* BREAKARC_HEADER */

