
/*
  $Header: /usr4/Geom_utilities/Poly2tri/RCS/poly2tri_func.c,v 1.1 91/03/04 11:24:28 meuer Exp $
  
  Break one polygon into triangles and return them as a list of verticies.
  
  Triangles must point to an array large enough to hold the coordinates of all the resulting triangles.
  The number of triangles generated is returned.  0 is returned on error.
  
  Mark Meuer
  #1267045
  
  */
#include	"poly2tri.h"


int
poly2tri(num, poly, triangles)
     int	num;
     double	*poly;
     double	*triangles;
{
    Polygon	polygon;
    int		tris_generated = 0;
    int		order_changed;
    int		i;
    
    /* IF THERE ARE AT LEAST THREE VERTICIES IN THE TRIANGLE */
    if ( num >= 3 )
    {
	/* CREATE A POLYGON STRUCTURE */
	polygon.no_verticies = num;
	polygon.top_vertex = (Vertex *) malloc( sizeof(Vertex) * num );
	if ( polygon.top_vertex )
	{
	    for( i = 0; i < num ; i++ )
	    {
		polygon.top_vertex[i].world_coords[0] = poly[(i * 3)];
		polygon.top_vertex[i].world_coords[1] = poly[(i * 3) + 1];
		polygon.top_vertex[i].world_coords[2] = poly[(i * 3) + 2];
		if ( i != 0 )
		{
		    polygon.top_vertex[i].prev_vertex = &polygon.top_vertex[i-1];
		}
		else
		{
		    polygon.top_vertex[i].prev_vertex = &polygon.top_vertex[num-1];
		}

		if ( i != num - 1 )
		{
		    polygon.top_vertex[i].next_vertex = &polygon.top_vertex[i+1];
		}
		else
		{
		    polygon.top_vertex[i].next_vertex = &polygon.top_vertex[0];
		}
	    }
	    
	    /* PROJECT THE VERTICIES INTO THE XY PLANE IN COUNTER-CLOCKWISE ORDER. */
	    project_verticies_to_xy( &polygon );
	    
	    /* PUT THE VERTICIES IN CLOCKWISE ORDER */
	    order_changed = sort_verticies( &polygon );
	    
	    /* BREAK IT INTO TRIANGLES */
	    tris_generated = break_polygon_to_list(&polygon, triangles, order_changed);
	}
    }
    return( tris_generated );
}



int
break_polygon_to_list( poly, triangles, order_changed )
     Polygon	*poly;
     double	*triangles;
     int	order_changed;	/* TRUE if original order of verticies has been reversed. */
{
    Vertex	*convex_vert;
    Vertex	*concave_vert;
    Vertex	*triangle_vert;
    int		i;
    int		broken_off;
    int		inside_triangle;
    int		no_tris = 0;	/* Count of how many triangles are generated. */
    
    /* CLASSIFY EACH VERTEX AS CONVEX OR CONCAVE. */
    classify_verticies( poly );
    
    /* FOR EACH CONVEX VERTEX, (until a triangle is broken off) */
    convex_vert = poly->top_vertex;
    broken_off = FALSE;
    do
    {
	if ( convex_vert->type == CONVEX )
	{
	    /* SEARCH FOR A CONCAVE VERTEX LYING WITHIN TRIANGLE FORMED BY THIS VERTEX AND IT'S NEIGHBORS. */
	    inside_triangle = FALSE;
	    concave_vert = poly->top_vertex;
	    do
	    {
		if ( concave_vert->type == CONCAVE )
		{
		    inside_triangle = point_in_triangle(convex_vert->prev_vertex->plane_coords,
							convex_vert->plane_coords,
							convex_vert->next_vertex->plane_coords,
							concave_vert->plane_coords);
		}
		concave_vert = concave_vert->next_vertex;
	    } while ( (!inside_triangle) && (concave_vert != poly->top_vertex) );
	    
	    /* IF NONE ARE FOUND, */
	    if ( ! inside_triangle )
	    {
		/* BREAK THIS TRIANGLE OFF THE POLYGON AND RECLASSIFY EFFECTED VERTICIES. */
		/* Print it out */
		if ( ! order_changed )	/* Print out in same order as original polygon */
		{
		    for (i = 0, triangle_vert = convex_vert->prev_vertex ;
			 i < 3 ;
			 i++, triangle_vert = triangle_vert->next_vertex )
		    {
			*triangles = triangle_vert->world_coords[0];
			triangles++;
			*triangles = triangle_vert->world_coords[1];
			triangles++;
			*triangles = triangle_vert->world_coords[2];
			triangles++;

		    }
		}
		else
		{
		    for (i = 0, triangle_vert = convex_vert->next_vertex ;
			 i < 3 ;
			 i++, triangle_vert = triangle_vert->prev_vertex )
		    {
			*triangles = triangle_vert->world_coords[0];
			triangles++;
			*triangles = triangle_vert->world_coords[1];
			triangles++;
			*triangles = triangle_vert->world_coords[2];
			triangles++;
		    }
		    
		}
		
		/* Remove the link */
		convex_vert->prev_vertex->next_vertex = convex_vert->next_vertex;
		convex_vert->next_vertex->prev_vertex = convex_vert->prev_vertex;
		if ( poly->top_vertex == convex_vert )	/* Assign a new top vertex if necessary */
		{
		    poly->top_vertex = convex_vert->next_vertex;
		}
		poly->no_verticies--;
		broken_off = TRUE;
		no_tris += 1;
		
		/* RECURSIVELY BREAK APART THE NEW POLYGON */
		if ( poly->no_verticies >= 3 )
		{
		    no_tris += break_polygon_to_list( poly, triangles, order_changed );
		}
	    }
	}
	
	convex_vert = convex_vert->next_vertex;
    } while ( ! broken_off );

    return(no_tris);
}
