
/*
  $Header: /usr4/Geom_utilities/Tri2quad/RCS/process_triangles.c,v 1.1 91/03/12 16:44:03 meuer Exp $
  
  
  Read in a list of polygons and feed them one-by-one into the routine that will break them
  into triangles.
  
  Mark Meuer
  #1267045
  
  */

#include	"tri2quad.h"

void
process_triangles( in_file, out_file  )
     FILE 	*in_file, *out_file;
{
    int	success = 9;
    double	quad[4][3];
    int	i,j;
    
    /* WHILE NOT AT THE END OF THE LIST, */
    while( (!feof( in_file )) && (success == 9) )
    {
	/* READ A TRIANGLE */
	success = fscanf(in_file, "%lf%lf%lf", (double *) &quad[0][0], &quad[0][1], &quad[0][2] );
	success += fscanf(in_file, "%lf%lf%lf", (double *) &quad[1][0], &quad[1][1], &quad[1][2] );
	success += fscanf(in_file, "%lf%lf%lf", (double *) &quad[2][0], &quad[2][1], &quad[2][2] );
	
	/* IF SUCCESSFUL, */
	if (success == 9) 
	{
	    /* CONVERT IT TO A QUAD. */
	    quad[3][0] = quad[2][0];
	    quad[3][1] = quad[2][1];
	    quad[3][2] = quad[2][2];

	    /* WRITE IT OUT */
	    for ( i = 0; i < 4; i++ )
	    {
		for ( j = 0; j < 3; j++ )
		{
		    fprintf( out_file, "%lf ", (double) quad[i][j] );
		}
		fprintf( out_file, "   " );
	    }
	    fprintf( out_file, "\n" );
	}
	else if ( !feof( in_file ) )
	{
	    fatal_error("Non-numeric character on input!  Bye.\n");
	    exit(-1);
	}
	else if ( success != 0 )
	{
	    fatal_error("Last triangle is not complete!\n" );
	}
    }
}
