(* $Id: Demo.m,v 1.1 89/06/06 15:06:12 mbp Exp $
 *
 *  Demo.m: functions for writing Mathematica demo packages
 *
 *  Mark Phillips
 *  May 31, 1989
 *)

(************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips			*
 * 									*
 * Permission to use, copy, modify, and distribute this software and	*
 * its documentation for any purpose and without fee is hereby granted,	*
 * provided that the above copyright notice appear in all copies and	*
 * that both that copyright notice and this permission notice appear in	*
 * supporting documentation, and that the name of Mark B. Phillips or	*
 * the University of Maryland not be used in advertising or publicity	*
 * pertaining to distribution of the software without specific, written	*
 * prior permission.  This software is provided "as is" without express	*
 * or implied warranty.							*
 ************************************************************************)

BeginPackage["Demo`"]

Demo::usage = "Demo[string] causes string to be evaluated as input to
Mathematica as if the user had typed it at the keyboard; In[] and
Out[] messages are generated, and the current line number ($Line) is
incremented.  WARNING: this function does not always set the Out[]
value properly, so the use of Out[n], %, %n, etc, may not work when
referring to items set by a call to Demo[]."

Pause::usage = "Pause[] causes Mathematica wait until the user hits
the <return> key.  It displays the prompt \"Hit <return> to continue ...\"."

Vskip::usage = "Vskip[n] causes Mathematica to print n blank lines.
It is useful for spacing output produced with the Print command."

Begin["`private`"]

SetAttributes[Demo, HoldAll]
Demo[x_] :=
  Block[ {},
    Unprotect[In,Out];
      ++$Line;
      In[$Line] := ToExpression[x];
      Print[""];
      Print["In[",$Line,"]:= ", x];
      Out[$Line] = In[$Line];
      If[ Not[ TrueQ[Out[$Line] == Null] ],
	  Print[""];
	    Print["Out[",$Line,"]= ", Out[$Line]] ];
      Protect[In,Out];
      Return[Null];
      ]

Vskip[n_] := Do[ Print[""], {n} ]

Pause[] := ( Print[""]; InputString["Hit <return> to continue ..."] )
Pause[s_String] := ( Print[""]; InputString[s] )


End[]

EndPackage[]
