/*
 * buttons.c: button submodule
 */

/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include <stdio.h>
#include <device.h>
#include <get.h>
#include "glg.h"
#include "internal.h"
#include "buttons.h"

static int (*DrawWindow)() = NULL;

/*-----------------------------------------------------------------------
 * Function:	GlgButtonInit
 * Description:	initialize the button subpackage
 * Args  IN:	drawwindow: procedure for redrawing entire window.
 *		  Call syntax is just 'drawwindow()'.
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Jun  4 14:12:16 1990
 * Notes:	Call this once before processing any gadget events.
 */
int
  GlgButtonInit(drawwindow)
int (*drawwindow)();
{
  DrawWindow = drawwindow;
}

/*-----------------------------------------------------------------------
 * Function:	GlgButtonDraw
 * Description:	Draw a button
 * Args  IN:	*data: the button to draw
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Jun  4 21:57:05 1990
 */
int
  GlgButtonDraw(data)
register char *data;
{
  register GlgButton *bp = (GlgButton*)data;

  /* Draw tbe button background */

  color(*(bp->colors+bp->n));
  rectf(bp->x, bp->y, bp->x+bp->w, bp->y+bp->h);


  /* Draw the button label */
  GlgWriteString(*(bp->strings+bp->n),
		      bp->x+bp->w/2, bp->y+bp->h/2, 1, 1, 1,
		      *(bp->colors+bp->n), bp->txtcol);

  /* Draw the button outline */
  color(bp->outline);
  rect(bp->x, bp->y, bp->x+bp->w, bp->y+bp->h);
}

/*-----------------------------------------------------------------------
 * Function:	GlgButtonEvent
 * Description:	Let a button process an event
 * Args  IN:	*data: the button
 *		event: the event
 * Returns:	1 if the button acts on the event, 0 if not.
 * Author:	mbp
 * Date:	Mon Jun  4 17:26:53 1990
 */
int
  GlgButtonEvent(data, event)
register char *data;
GlgEvent event;
{
  register GlgButton *bp = (GlgButton*)data;
  long buffers;
  
  if (!GlgEventInRect(event, bp->x, bp->y, bp->w, bp->h))
    return(0);
  
  switch (event.dev) {
  case LEFTMOUSE:
    if (event.val) {
      bp->n = (bp->n + 1) % bp->nvals ;
      if (bp->proc != NULL)
	(*(bp->proc))(bp->n);
      buffers = getbuffer();
      frontbuffer(TRUE);
      GlgButtonDraw(data);
      if ( ! (buffers & FRNTBUFFER) )
	frontbuffer(FALSE);
    }
    break;
    
  case MIDDLEMOUSE:
    if (DrawWindow != NULL) {

      double xold = event.x;
      int first = 1;
      while (getbutton(event.dev)) {
	GlgGetMouseXY(&event.x,&event.y);
	if ((first) || (event.x != xold)) {
	  first = 0;
	  xold = event.x;	
	  bp->x = event.x;
	  bp->y = event.y;
	  (*DrawWindow)();
	}
      }

    }
    break;
    
  case RIGHTMOUSE:
    if (getbutton(RIGHTMOUSE))
      printf("button is at (%5.3f, %5.3f)\n", bp->x,bp->y);
    break;
    
  }
  
  return(1);
}

