/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#ifndef GLGSLIDERDEF

typedef struct {

  /* Slider value type */
  int   type;
#define S_DOUBLE 1
#define S_INT 2

  /* printf format string for slider label */
  char *format;

  /* callback procedure; gets called with slider value each
   * time the value changes */
  int	(*proc)();

  /* X,Y center in world coords */
  double xcen, ycen;

  /* X,Y lengths in world coords */
  double xsz, ysz;

  /* Min, max, current 'u' value */
  double umin, umax, u;

  /* Colors for background, bar marker, bar interior, outline, and text */
  Colorindex bgnd, barmark, inbar, outline, txtcol;

} GlgSlider;

extern int GlgSliderDraw();
extern int GlgSliderEvent();

/*-----------------------------------------------------------------------
 * MACRO:	GlgSlider
 * Description:	define a slider
 * Args:	slider: name for GlgSlider object
 *		gadget: name for corresponding GlGadget object
 *		type: slider type (S_INT or S_DOUBLE)
 *		format: slider label printf format string
 *		proc: slider callback procedure
 *		x,y: location of center
 *		w,h: width and height
 *		umin,umax,u: min, max, and initial value for slider
 *		bgnd: background
 *		barmark: bar mark color
 *		inbar: bar interior color
 *		outline: outline color
 *		txtcol: text color
 * Author:	mbp
 * Date:	Mon Jun  4 13:22:19 1990
 * Notes:	callback procedure is called with slider value
 *		  each time that value changes.  Data type of
 *		  the value is determined by slider type (int
 *		  or double).
 */

#define GLGSLIDER(slider, gadget, type, format, proc, x, y, w, h, umin, umax, u, bgnd, barmark, inbar, outline, txtcol)		\
  GlgSlider slider =					\
   { type, format, proc, x, y, w, h, umin, umax, u,	\
     bgnd, barmark, inbar, outline, txtcol };		\
  GlGadget gadget =					\
   { (char*)(&slider), GlgSliderDraw, GlgSliderEvent }

#define GLGSLIDERDEF

#endif
