/* $Id: gr.h,v 2.3 89/09/20 17:01:28 mbp Exp $
 *
 * gr.h: main header file for GR
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

/* NAMING CONVENTION: identifiers beginning with gr_ are external and
 * intended to be used by application program.  Identifiers beginning
 * with GR_ are external but are intended only for use within GR;
 * application programs should usually not use these.  Application
 * programs should avoid all names which begin with either gr_ or GR_.
 */

typedef struct gr_Opt_pair_s {
	char	*string;
	int	(*proc)();
	} gr_Opt_pair;

typedef struct gr_Menu_s {
	char	 *title;
	int	 nopts;
	gr_Opt_pair *list;
	} gr_Menu;
	
typedef unsigned int gr_Button;

#define GR_INPUT_TEXT_LENGTH 100
#define GR_MESSAGE_LENGTH 100
#define GR_COORDINATE_MESSAGE_LENGTH 100

#define GR_LEFT		0001
#define GR_MIDDLE	0002
#define GR_RIGHT	0004
#define GR_SHIFT_LEFT	0010
#define GR_SHIFT_MIDDLE	0020
#define GR_SHIFT_RIGHT	0040
#define GR_ESC		0100
#define GR_ALL_BUTTONS (GR_LEFT|GR_MIDDLE|GR_RIGHT|\
			GR_SHIFT_LEFT|GR_SHIFT_MIDDLE|GR_SHIFT_RIGHT|\
			GR_ESC)

double gr_aspect_ratio();

extern double GR_x1, GR_y1, GR_x2, GR_y2, GR_xfactor, GR_yfactor;

/* Macros for converting fp coords to integer canvas coords: */
#define GR_CANVAS_X(x) (int)(( ((x)-GR_x1)*GR_xfactor ))
#define GR_CANVAS_Y(y) (int)(( ((y)-GR_y2)*GR_yfactor ))
/*   ... and for the reverse direction: */
#define GR_SAVNAC_X(x) ( ((x)/GR_xfactor) + GR_x1)
#define GR_SAVNAC_Y(y) ( ((y)/GR_yfactor) + GR_y2)

#define gr_move(x,y) gr_canvas_move(GR_CANVAS_X(x), GR_CANVAS_Y(y))

#define gr_draw(x,y) gr_canvas_draw(GR_CANVAS_X(x), GR_CANVAS_Y(y))

#define gr_arc( xc,yc,  x1,y1,  x2,y2 )		 \
  gr_canvas_arc(GR_CANVAS_X(xc),GR_CANVAS_Y(yc), \
		GR_CANVAS_X(x1),GR_CANVAS_Y(y1), \
		GR_CANVAS_X(x2),GR_CANVAS_Y(y2) )

#define gr_show_cursor(x,y) \
  gr_show_canvas_cursor(GR_CANVAS_X(x), GR_CANVAS_Y(y))
