/* $Id: view.c,v 1.7 89/09/20 18:00:10 mbp Exp $
 *
 * view.c: view control procedures for SunView
 */

/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include <math.h>
#include <stdio.h>
#include "../lgd.h"
#include "../vector.h"
#include GR_HEADER

/*--------------------------------------------------------------*/
int
gr_horizontal_sweep(angle)
     double angle;
{
  lgd_View3 view;
  double E[3], U[3], M[3][3], E1[3];
  
  lgd_inquire_view( &view );
  LGD_sub_vec( E, view.eye, view.focus );
  LGD_sub_vec( U, view.up,  view.focus );
  LGD_compute_3d_rot_mat( M, U, -angle );
  LGD_matmul_vec( E1, M, E );
  LGD_add_vec( view.eye, view.focus, E1 );
  lgd_set_view( &view );
  lgd_update_display();
  return(0);
}

/*--------------------------------------------------------------*/
int
gr_vertical_sweep(angle)
     double angle;
{
  lgd_View3 view;
  double D[3], E[3], U[3], M[3][3], E1[3], U1[3];
  
  lgd_inquire_view( &view );
  LGD_sub_vec( E, view.eye, view.focus );
  LGD_sub_vec( U, view.up,  view.focus );
  LGD_cross_vec( D, U, E );
  LGD_compute_3d_rot_mat( M, D, angle );
  LGD_matmul_vec( E1, M, E );
  LGD_matmul_vec( U1, M, U );
  LGD_add_vec( view.eye, view.focus, E1 );
  LGD_add_vec( view.up, view.focus, U1 );
  lgd_set_view( &view );
  lgd_update_display();
  return(0);
}

/*--------------------------------------------------------------*/
int
gr_horizontal_pan(angle)
     double angle;
{
  lgd_View3 view;
  double F[3], U[3], D[3], F1[3], U1[3], M[3][3];
  
  lgd_inquire_view( &view );
  LGD_sub_vec( F, view.focus, view.eye );
  LGD_sub_vec( U, view.up, view.eye );
  LGD_sub_vec( D, view.up, view.focus );
  LGD_compute_3d_rot_mat( M, D, angle );
  LGD_matmul_vec( F1, M, F );
  LGD_matmul_vec( U1, M, U );
  LGD_add_vec( view.focus, view.eye, F1 );
  LGD_add_vec( view.up, view.eye, U1 );
  lgd_set_view( &view );
  lgd_update_display();
  return(0);
}

int
gr_vertical_pan(angle)
     double angle;
{
  lgd_View3 view;
  double F[3], U[3], D[3], F1[3], U1[3], M[3][3];
  
  lgd_inquire_view( &view );
  LGD_sub_vec( F, view.focus, view.eye );
  LGD_sub_vec( U, view.up, view.eye );
  LGD_cross_vec( D, U, F );
  LGD_compute_3d_rot_mat( M, D, angle );
  LGD_matmul_vec( U1, M, U );
  LGD_matmul_vec( F1, M, F );
  LGD_add_vec( view.focus, view.eye, F1 );
  LGD_add_vec( view.up, view.eye, U1 );
  lgd_set_view( &view );
  lgd_update_display();
  return(0);
}

int
gr_tilt(angle)
double angle;
{
  lgd_View3 view;
  double E[3], U[3], M[3][3], U1[3];
  
  lgd_inquire_view( &view );
  LGD_sub_vec( E, view.eye, view.focus );
  LGD_sub_vec( U, view.up,  view.focus );
  LGD_compute_3d_rot_mat( M, E, angle );
  LGD_matmul_vec( U1, M, U );
  LGD_add_vec( view.up, view.focus, U1 );
  lgd_set_view( &view );
  lgd_update_display();
  return(0);
}
/*--------------------------------------------------------------*/
int
gr_perspective(factor)
double factor;
{
  lgd_View3 view;
  double fdist, D[3];

  lgd_inquire_view( &view );
  fdist = factor*LGD_L2dist_vec( view.eye, view.focus );
  LGD_sub_vec( D, view.eye, view.focus );
  LGD_unit_vec( D );
  LGD_scamul_vec( D, fdist, D );
  LGD_add_vec( view.eye, view.focus, D );
  lgd_set_view( &view );
  lgd_update_display();
  return(0);
}

/*--------------------------------------------------------------
 * Function:     gr_zoom
 * Description:  changes size of view plane window
 * Arguments IN: zoom_factor
 * Returns:      nothing
 * Notes:        multiplies length and width of view plane window
 *		 by zoom_factor; keeps center of window fixed.
 */
int
gr_zoom( zoom_factor )
double zoom_factor;
{
  lgd_View3 view;
  double u_len_2, v_len_2, u_cen, v_cen;
    
  lgd_inquire_view( &view );
  u_cen = (view.u1 + view.u2) / 2;
  v_cen = (view.v1 + view.v2) / 2;
  u_len_2 = zoom_factor * (view.u2 - view.u1) / 2;
  v_len_2 = zoom_factor * (view.v2 - view.v1) / 2;
  view.u1 = u_cen - u_len_2;
  view.u2 = u_cen + u_len_2;
  view.v1 = v_cen - v_len_2;
  view.v2 = v_cen + v_len_2;
  lgd_set_view( &view );
  lgd_update_display();
  return(0);
}
  
/*-----------------------------------------------------------------------
 * Function:     gr_redraw
 * Description:  redraws the picture after reading the current values
 *               of the eye, focus, up, and vpw text fields
 * Arguments:    none
 * Returns:      nothing
 */
int
gr_redraw()
{
  lgd_View3 view;

  gr_get_eye_display( view.eye );
  gr_get_focus_display( view.focus );
  gr_get_up_display( view.up );
  gr_get_view_plane_window_display( &view.u1, &view.u2, &view.v1, &view.v2 );
  lgd_set_view( &view );
  lgd_update_display();
  return(0);
}

int
gr_reset()
{
  lgd_View3 view;

  lgd_get_default_view( &view );
  lgd_set_view( &view );
  lgd_update_display();
  return(0);
}
