#! /bin/csh -f

# $Id: HyperMath.tpl,v 1.2 90/07/11 13:07:46 mbp Exp Locker: mbp $
#TPL
#TPL	DO NOT CHANGE ANY LINE IN THIS FILE THAT BEGINS WITH '#TPL'
#TPL	
#TPL	This file is a template to be used in creating the actual
#TPL	shell script.  The makefile creates the file 'HyperMath' from
#TPL	this one by replacing the following strings in this file with
#TPL	actual values:
#TPL
#TPL		HYPERPACKAGEPATH
#TPL		INTERFACEPACKAGEPATH
#TPL		MATHDIR
#TPL		MACHDIR

#TPLWARNING

# Shell script to start Mathematica and initialize Hypercad; assumes
#   that the graphics daemon is already running on the graphics host.

# usage: HyperMath [graphicshost]

# This script:
# 	(1) starts Mathematica on the current host
# 	(2) reads in Hypercad.m
# 	(3) executes gConnect[]

if ($#argv > 0) then
  set graphicshost = $1
  shift
else
  if $?ELBOWSERVER then
    set graphicshost = $ELBOWSERVER
  else
    echo -n "Enter name of Hypercad graphics host: "
    set graphicshost = $<
    if ( "$graphicshost" == "" ) then
      echo "Null host.  HyperMath aborted."
      exit -1
    endif
  endif
endif

if ($argv > 0) then
  goto usage
endif

set hyperdir = HYPERPACKAGEPATH
set interfacedir = INTERFACEPACKAGEPATH
set mathdir = MATHDIR
set machdir = MACHDIR

if ( "$machdir" == "Bin.sun3" ) then
	set machdir = "$machdir.`$mathdir/Install/foption`"
endif
set path = ( $path $mathdir/$machdir/Display )

setenv ELBOWSERVER $graphicshost

exec $mathdir/$machdir/mathexe				\
	-pwpath '{"'$mathdir/Install'"}'		\
	-run '$Path = Join[				\
		$Path,					\
		{					\
			"~",				\
			"'$mathdir/Init'",		\
			"'$mathdir/Packages'",		\
			"'$hyperdir'",			\
			"'$interfacedir'"		\
		}					\
	]' 						\
	-run '<<Hypercad.m' 				\
	-run 'gConnect[]'				\
	"$*"

echo 'HyperMath: exec failed.'
exit -1

usage:
	echo 'usage: HyperMath [graphicshost]'
	exit -1
