(* $Id: GroupTheory.m,v 1.3 90/07/11 13:08:10 mbp Exp Locker: mbp $
 *
 * GroupTheory.m: Package for enumerating free groups and semigroups
 *)

(**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************)

BeginPackage["GroupTheory`"]

EnumerateSemiGroup::usage = "EnumerateSemiGroup[id, gens, op, wordlength]
returns a list of the distinct words up to length wordlength in the free
semigroup generated by the elements of the list gens.  id is the identity
element of the semigroup, and op is the group operation."

EnumerateGroup::usage = "EnumerateGroup[id, gens, op, inverse, wordlength]
returns a list of the distinct words up to length wordlength in the free group
generated by the elements of the list gens.  id is the identity element of the
semigroup, op is the group operation, and inverse is the group inverse
operator."

DistributeOp::usage = "DistributeOp[op, {a1,...,an}, {b1,...,bm}] distributes
the binary operation op over the 2 lists, returning the list {op[a1,b1], ...,
op[a1,bm], ..., op[an,b1], ..., op[an,bm]} of length nm."

Word::usage = "Word[g1, g2, ..., gn] represents the word g1 g2 ... gn in the
group generated by the gi.  The gi represent generators --- they can be any
expressions which can be combined with + and -.  The inverse of a generator is
represented by its negative.  The word is automatically reduced by cancelling
adjacent gi's which are negatives of each other.  Words can be multiplied
using '**' (NonCommutativeMultiply)."

Begin["`private`"]

protected = Unprotect[NonCommutativeMultiply]

Word[a___] ** Word[b___] := Word[a, b]

a_Word ** {b___Word} := Map[ (a ** #)&, {b} ]

{a___Word} ** b_Word := Map[ (# ** b)&, {a} ]

{a___Word} ** {b___Word} := Apply[ Join, Map[ (# ** {b})&, {a} ] ]

Protect[Release[protected]]

Word[a___, b_, c_, d___] := Word[a, d] /; b + c === 0

DistributeOp[op_, list1_List, list2_List] :=
  Apply[ Join, Table[ op[list1[[i]], list2[[j]]],
		      {i,1,Length[list1]},
		      {j,1,Length[list2]} ] ]

EnumerateSemiGroup[ id_, gens_List, op_, wordlength_Integer ] :=
  Block[ {list, new},
    new = {id};
    list = new;
    Do[ list = Join[list, new = DistributeOp[op, gens, new]],
        {wordlength} ];
    Return[ Union[ list ] ]
    ]

EnumerateGroup[ id_, gens_List, op_, inverse_, wordlength_Integer ] :=
  EnumerateSemiGroup[ id,
		      Join[gens, Map[inverse, gens]],
		      op,
		      wordlength ]

End[]

EndPackage[]

Null
