./" $Id: fsa.man,v 1.3 90/07/11 13:10:11 mbp Exp Locker: mbp $
./"
./" fsa.man: manual page for fsa
./"
./" by Mark B. Phillips
./"
./" ************************************************************************
./" *		Copyright (C) 1989 by Mark B. Phillips                     *
./" * 									   *
./" * Permission to use, copy, modify, and distribute this software and    *
./" * its documentation for any purpose and without fee is hereby granted, *
./" * provided that the above copyright notice appear in all copies and    *
./" * that both that copyright notice and this permission notice appear in *
./" * supporting documentation, and that the name of Mark B. Phillips or   *
./" * the University of Maryland not be used in advertising or publicity   *
./" * pertaining to distribution of the software without specific, written *
./" * prior permission.  This software is provided "as is" without express *
./" * or implied warranty.                                                 *
./" ************************************************************************
./"
.TH FSA 3 "April 18, 1989"
.SH NAME
fsa \- finite state automaton for recognizing strings
.SH SYNOPSIS
.nf

cc myprogram.c /Muse/mortals/students/mbp/lib/fsa.o
.PP
.B fsa_initialize(reject)
.B int reject;
.PP
.B fsa_install(s, v)
.B char \(**s;
.B int v;
.PP
.B fsa_parse(s)
.B char \(**s;
.PP
.SH DESCRIPTION
These procedures implement a finite state automaton (FSA) which can be
programmed at run-time to recognize a finite set of strings, called
the "acceptable strings".  The general scheme of usage is (1)
initialize the FSA, (2) specify the acceptable set, and (3) parse
strings --- i.e.  if a string is acceptable, return a corresponding
value, and if it is not acceptable, return a rejection value.

.I fsa_initialize
should be called before calling any other
.I fsa_
procedure. It initializes the FSA, clearing any current set of
acceptable strings.  
.I reject
gives the value to be returned upon parsing an unacceptable string.
.I fsa_install
adds the string 
.I s
to the set of acceptable strings, and programs the
FSA to return the value 
.I v
when 
.I s
is parsed.
.I v
should be nonzero;
.I fsa_install
returns 
.I v
if the installation was successful, or 
.I -v
if not (which means that there was not enough space left in the FSA).
.I fsa_parse
parses the string 
.I s
and returns the corresponding value, if 
.I s
is acceptable, or the value of 
.I reject
given in the most recent call to fsa_initialize if
.I s
is not acceptable.

Although in the simplest situations, all calls to fsa_install will be
performed before any calls to fsa_parse, calls to these procedures may
actually be intermixed.

.SH BUGS AND CAVEATS
There is a fixed limit (currently 300) on the number of states that
the FSA can have.  When this limit is reached, the FSA will refuse to
install more strings, and
.I fsa_install
will begin returning
.I -v
instead of
.I v.
When this happens, the string
.I s
which was passed to
.I fsa_install
on the first call which failed will probably have been only partially
installed, resulting in an undesirable acceptable string.  At present
the only way to increase the maximum number of states is to recomple
fsa.c.

.SH "Author"
Mark B. Phillips
.br
Department of Mathematics
.br
University of Maryland
.br
College Park, Maryland  20742
.br
mbp@lakisis.umd.edu
.sp1
Copyright (C) 1989 by Mark B. Phillips
.sp1
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Mark B. Phillips or
the University of Maryland not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.  This software is provided "as is" without express
or implied warranty.
