/* $Id$
 *
 * hviewpt.c
 * 
 * This module contains functions for manipulating viewport 
 * data.  These functions are primarily used for interacting
 * with the window manager.
 */

/**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************/

#include "hcore.h"
#include "hglobals.h"
#include "sunview/window.h"

/*-----------------------------------------------------------------------
 * Function:	hWindowToViewport
 * Description:	convert hWindow structure to viewport data
 * Args  IN:	*win: the hWindow
 *      OUT:	*vpx,*vpy,*vps: the viewport
 * Returns:	success status
 * Author:	lena
 * Date:	Tue Apr  3 13:28:21 1990
 * Notes:	
 */

hWindowToViewport(vpx,vpy,vps, win)
double *vpx, *vpy, *vps;
hWindow *win;
{
  double max,tmp;
  int s,t;

  max = 0.0;
  for (s=0; s<4; s++){
    for(t=0; t<2; t++){
      tmp = ABS(win->center[t] - win->corner[s][t]);
      if (max < tmp) 
         max = tmp;
    }
  }
  *vpx = win->center[0] - max;
  *vpy = win->center[1] - max;
  *vps = 2*max;
  if (max < FUDGE) return(ERROR);
  return(0);
}


/*-----------------------------------------------------------------------
 * Function:	SethWindow
 * Description:	Set the current hWindow
 * Args  IN:	*win: the new hWindow
 * Returns:	success status
 * Notes:	Updates global variables hwindow, vpx,vpy, and vps.
 */
SethWindow(win)
hWindow *win;
{
  hwindow = *win;
  hWindowToViewport(&vpx,&vpy,&vps,&hwindow);
  wSetViewport(vpx,vpy,vps,model);
  DrawPicture();
}

/*-----------------------------------------------------------------------
 * Function:	GethWindow
 * Description:	Get the current window
 * Args OUT:	*win: the window
 * Returns:	success
 * Notes:	
 */
GethWindow(win)
hWindow *win;
{
  *win = hwindow;
}

/*-----------------------------------------------------------------------
 * Function:	SetDefaulthWindow()
 * Description:	sets the current hwindow to a default value depending
 *              on the current model.
 * Args  IN:	
 *      OUT:	
 * Returns:	
 * Author:	lena
 * Date:	Tue Apr 10 13:11:24 1990
 * Notes:	
 */
SetDefaulthWindow()
{
#define L 1.1
  static hWindow klein_default_win = {0.0, 0.0,  -L,-L,  L,-L,  L,L,  -L,L};
#undef L
  hWindow win;

  switch(model) {
  case KLEIN:
    SethWindow(&klein_default_win);
    break;
  case POINCARE:
    ConverthWindow(&win, &klein_default_win, KleinToPoincare);
    SethWindow(&win);
    break;
  case UHP:
    ConverthWindow(&win, &klein_default_win, KleinToUHP);
    SethWindow(&win);
    break;
  }
}

/*-----------------------------------------------------------------------
 * Function:	SethModel
 * Description:	changes the current model, and updates the display
 * Args  IN:	model: then new model
 *      OUT:	
 * Returns:	success status
 * Author:	lena
 * Date:	Tue Apr  3 13:26:46 1990
 * Notes:	
 */
SethModel(mod)
int mod;
{
  hWindow win;
  int  (*ConvFunc)();
  
  if (model == mod) return(0);
  if ((model==POINCARE) && (mod==KLEIN)) 
    ConvFunc = PoincareToKlein;
  if ((model==POINCARE) && (mod==UHP))   
    ConvFunc = PoincareToUHP;
  if ((model==KLEIN) && (mod==POINCARE)) 
    ConvFunc = KleinToPoincare;
  if ((model==KLEIN) && (mod==UHP))      
    ConvFunc = KleinToUHP;
  if ((model==UHP) && (mod==KLEIN))      
    ConvFunc = UHPToKlein;
  if ((model==UHP) && (mod==POINCARE))      
    ConvFunc = UHPToPoincare;

  model = mod;
  ConverthWindow(&win, &hwindow, ConvFunc);
  SethWindow(&win);  /* SethWindow erases and redraws the screen */
  return(0);
}

ConverthWindow(newwin, oldwin, convfunc)
hWindow *newwin, *oldwin;
int (*convfunc)();
{
  int t;

  (*convfunc)(newwin->center, oldwin->center);
  for(t=0; t<4; t++){
    (*convfunc)(newwin->corner[t], oldwin->corner[t]);
  }
}


/*-----------------------------------------------------------------------
 * Function:	GethModel
 * Description:	returns the current model
 * Args  IN:	*mod: the request variable
 *      OUT:	
 * Returns:	success status
 * Author:	lena
 * Date:	Tue Apr 10 13:17:36 1990
 * Notes:	
 */
GethModel(mod)
int *mod;
{
  *mod = model;
  return(0);
}







