./" $Id: strtokq.man,v 1.2 90/07/11 13:10:50 mbp Exp Locker: mbp $
./"
./" strtokq.man: manual page for strtokq
./"
.TH STRTOKQ 3 "August 17, 1989"
.SH NAME
strtokq \- parse string into tokens maybe containing quoted substrings
.SH SYNOPSIS
.nf

.B char \(**strtok();
.PP
.B strtokq(string, seps, quotes)
.B char \(**string, \(**seps, \**quotes;
.fi

.SH DESCRIPTION
.I strtokq
is a generalized version of
.I strtok(3)
which allows for the tokens in
.I string
to contain quoted substrings.  A quoted substring is defined as a
string delimited by chars of the string
.I quotes.
The ending delimiter does not have to be the same as the beginning
delimiter.  Quoted substrings may contain separator characters.
The quote characters are removed from the token string during parsing.

.PP
See
.I strtok(3)
for more details.

.SH CAVEAT
.I strtokq
overwrites
.I string,
and even after all tokens have been returned, the original contents of
.I string
may be lost.

.SH "Author"
Mark B. Phillips
.br
Department of Mathematics
.br
University of Maryland
.br
College Park, Maryland  20742
.br
mbp@lakisis.umd.edu
.sp1
Copyright (C) 1989 by Mark B. Phillips
.sp1
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Mark B. Phillips or
the University of Maryland not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.  This software is provided "as is" without express
or implied warranty.
