#include "extern.h"

/* These functions handle the drawing of the curve that
assigns relative border radii */

getbdry()
/* get the mouse-drawn boundary */
{
	int			mousex, mousey, oldx, oldy, button1down;
	int			i, firstx, firsty, mymask, tempw, temph;
	XEvent			myevent;

	printf ("Draw a curve representing the bdry radius function defined on [-PI, PI]\n");
	printf ("Button1 DRAWS.\n");
	printf ("Button2 ERASES.\n");
	printf("Button3 PROCEEDS.\n");
	/* Loop to get the region as drawn by the mouse */
	StartDrawingLoop:;

	/* Draw cross-hatching in window */
	XSetLineAttributes(dpy, gc, 1, LineDoubleDash, CapNotLast, JoinMiter);
	temph = DRAWHEIGHT/2.0;
	tempw = DRAWWIDTH/2.0;
	XDrawLine(dpy, drawwin, gc, 0, temph, DRAWWIDTH, temph);
	XDrawLine(dpy, drawwin, gc, tempw, 0, tempw, DRAWHEIGHT);
	temph = DRAWHEIGHT/4.0;
	tempw = DRAWWIDTH/4.0;
	XDrawLine(dpy, drawwin, gc, 0, temph, DRAWWIDTH, temph);
	XDrawLine(dpy, drawwin, gc, tempw, 0, tempw, DRAWHEIGHT);
	temph *= 3;
	tempw *= 3;
	XDrawLine(dpy, drawwin, gc, 0, temph, DRAWWIDTH, temph);
	XDrawLine(dpy, drawwin, gc, tempw, 0, tempw, DRAWHEIGHT);

	XSetLineAttributes(dpy, gc, 2, LineSolid, CapNotLast, JoinMiter);
	mymask = (ButtonPressMask | ButtonReleaseMask | ButtonMotionMask);
	normpoints = 0;
	for(i=0; i<500; ++i)
		mypoint[i].x = mypoint[i].y = 0;

	/* Initialize bounding rectangle of curve */
	xmin = ymin = 9999;
	xmax = ymax = 0;
	oldx = -9999;
	button1down = FALSE;
    	XSelectInput(dpy, drawwin, mymask);
    	while(1)	{
		XNextEvent(dpy, &myevent);
		/* allow motion draws after button1 is down */
		if ((myevent.type == ButtonPress) && (myevent.xbutton.button == 1))	{
			XSelectInput(dpy, drawwin, (mymask | PointerMotionMask));
			button1down = TRUE;
		}
		else
		if (button1down && (myevent.type == MotionNotify )) {
		/* Get mouse pointer coordinates */
			mousex = myevent.xmotion.x;
			mousey = myevent.xmotion.y;
			mypoint[normpoints].x = mousex;
			mypoint[normpoints].y = mousey;
			++normpoints;

			/* Check memory */
			if (normpoints > 499)	{
				fprintf (stderr, "The memory allocation for the array mypoint[] has been exceeded.\n");
				exit(1);
			}
			if(oldx<0) {
			/* Just starting to draw; draw a point */
				firstx = mousex;
				firsty = mousey;
	    			XDrawLine(dpy, drawwin, gc, mousex, mousey,mousex, mousey);
				oldx = mousex;
				oldy = mousey;
			}
			else	{
			/* Continuing draw; draw a line segment */
	    			XDrawLine(dpy, drawwin, gc, oldx, oldy,  mousex, mousey);
				oldx = mousex;
				oldy = mousey;
			}

			/* Update bounding rectangle of curve */
			if (xmin > mousex)	xmin = mousex;
			if (ymin > mousey)	ymin = mousey;
			if (xmax < mousex)	xmax = mousex;
			if (ymax < mousey)	ymax = mousey;
		}
		else
		/* end curve when button1 released */
		if ((myevent.type == ButtonRelease) && (myevent.xbutton.button == 1)) {
    			XSelectInput(dpy, drawwin, mymask);
			button1down = FALSE;
			oldx = -9999;
		}
		else
		/* Erase on button2 press */
		if ((myevent.type == ButtonPress) && (myevent.xbutton.button == 2)) 	{
			XClearWindow(dpy, drawwin);
			goto StartDrawingLoop;
		}
		else
		/* Exit drawing on button3 press*/
		if ((myevent.type == ButtonPress) && (myevent.xbutton.button == 3)) 	
			break;
 	}
} /*getbdry*/
				
assignrad()		
/* Assign bdry radii from the height of the curve mypoint[].
Then make a constant interior initial radius guess.
Note: One might choose to modify this code so that the 
fixed border radii are assigned in some other way than by mouse-drawn curve. */

{
	double 		initialguess, x, y, hscale;
	int 		i, indx;
	
	for (i=0; i<hw; ++i) 
    		if (DCirc[i].state == OUTERBDRY)	{
		/* Assign fixed border radii */
			x = DCirc[i].x-250.0;
			y = -(DCirc[i].y-250.0);
			hscale = (atan2(y, x)+PI)/(2.0*PI);
			indx = (1.0-hscale)*normpoints;
			indx = indx%normpoints;
			DCirc[i].r = ymax-mypoint[indx].y+3.0;
		}
	initialguess = 3.0+(ymax-ymin)/2.0;
	/*	Make constant initial guess.	*/
	for (i=0; i<N; ++i) 
    		DCirc[innerindex[i]].r = initialguess;
} /*assignrad*/
	
