/*					    */
/***** kali.c - Nina Amenta, Aug. 1989 ******/
/*					    */
#include <stdio.h>
#include <math.h>
#include <gl.h>
#include <device.h>
#include "symmetry.h"

typedef long WINDOW;
typedef long EVENT;
typedef long MENU;

#define DRAW 1
#define CUT 2
#define PICK 3
#define TRANSFORM 4
#define NAMESTACKSIZE 50

WINDOW MakeButtonWindow();
LINE *NewLine();
LINE *ThrowAwayLines();
LINE *DropLine();
LINE *GrabLine();
LINE *MakeCurrentObject();
LINE *ReadPattern();
void DrawLine();
void PickLine();
char *KeyboardIO();
void ChangeRatio();
void ChangeScale();
void ChangeAngle();
void ChangeRotation();

main()
{
  WINDOW win;
  RECTANGLE win_rect,sym_rect;
  EVENT ev;
  int i,j;
  int mode=0;
  POINT *sym_pts=NULL;
  int count;
  int ref;
  SYMMETRY *sym;
  XFORM xforms[5];
  LINE *Lines=NULL,*cur;
  FILE *pat;
  int sym_index = 0;
  POINT tmp;
  int dev_data;
  MENU sym_menu,main_menu,x_menu;
  short namestack[NAMESTACKSIZE];
  short scaled_pick;
  int hits;
  char *filename;
  float dummy;
  float scale=1.0;
  int old;
  void (*xformfnc) ();

  foreground();
  win = MakeWindow(&win_rect);
  SetUpOperatorInterface(&sym_menu,&main_menu,&x_menu);
  sym = &(SYMTAB[sym_index]);
  DefineSymWindow(&sym_rect,sym,&win_rect,scale);
/*   ortho2(0.0,scale*win_rect.width,0.0,scale*win_rect.height); */
  count = SetUpSymmetry(sym,&sym_pts,xforms,&sym_rect);
  DrawCurrent(&sym_rect,Lines,sym,sym_pts,xforms,count,DrawLine);
  swapbuffers();

  for (;;)
   {
     if ((mode != DRAW) && (mode != TRANSFORM)) ev = qread(&dev_data);
     
     /* mouse handler */
     else {
       while ((mode == DRAW) && (ev=qtest())==0) 
       {
	 GetCursor(&tmp,&win_rect,scale);
	 if (RectIncludesPoint(sym_rect,tmp))
	    {
	     tmp.x -= sym_pts[ref].x;
	     tmp.y -= sym_pts[ref].y;
	     VectorMatrixMult(&tmp,xforms[4],&tmp);
	     Lines->m[EX]=tmp.x;
	     Lines->m[EY]=tmp.y;
	     DrawCurrent(&sym_rect,Lines,sym,
		sym_pts,xforms,count,DrawLine);
	     swapbuffers();
    	   }
       }
       while ((mode == TRANSFORM) && (getbutton(LEFTMOUSE)) && 
	      ((ev=qtest())==0))
	 {
	   int new;
	   new = getvaluator(MOUSEX);
	   if (new>(old+1)) xformfnc(1,sym,&scale);
	   else if (new<(old-1)) xformfnc(-1,sym,&scale);
	   old = new;
	   DefineSymWindow(&sym_rect,sym,&win_rect,scale);
/*	   ortho2(0.0,scale*win_rect.width,0.0,scale*win_rect.height); */
	   count = SetUpSymmetry(sym,&sym_pts,xforms,&sym_rect);
	   DrawCurrent(&sym_rect,Lines,sym,sym_pts,xforms,count,DrawLine);
	   swapbuffers();
	 }

     ev = qread(&dev_data);
     }
	if (ev==REDRAW)
	    {
		reshapeviewport();
		AdjustWindowRectangle(&win_rect);
		DefineSymWindow(&sym_rect,sym,&win_rect,scale);
/* 		ortho2(0.0,scale*win_rect.width,0.0,scale*win_rect.height); */
		count = SetUpSymmetry(sym,&sym_pts,xforms,&sym_rect);
		DrawCurrent(&sym_rect,Lines,sym,sym_pts,xforms,count,DrawLine);
		swapbuffers();
	    }

    /* button handlers */

	     if (ev==LEFTMOUSE)
	       {
		 if (!dev_data) continue;
		 if (mode == TRANSFORM) {
		   old = getvaluator(MOUSEX);
		   continue;
		 }
		 GetCursor(&tmp,&win_rect,scale);
		 if ((mode == 0) || (mode == DRAW))
		    {
		    if (mode == DRAW)
			{
			  POINT p;
			  /* Reference to closest center of symmetry */
			  p.x = tmp.x-sym_pts[ref].x;
			  p.y = tmp.y-sym_pts[ref].y;
			  /* Convert to standard basis */
			  VectorMatrixMult(&p,xforms[4],&p);
			  Lines->m[EX]=p.x;
			  Lines->m[EY]=p.y;
		 
/*			    Lines->m[EX]=tmp.x-sym_pts[ref].x;
			    Lines->m[EY]=tmp.y-sym_pts[ref].y;
*/
			}
		    mode = DRAW;
		    DrawCurrent(&sym_rect,Lines,sym,
			sym_pts,xforms,count,DrawLine);
		    swapbuffers();
		    ref = closest(&tmp,sym_pts,count);
		    Lines = NewLine(Lines);
		    NewId(Lines);
		    /* Reference to closest center of symmetry */
		    tmp.x -= sym_pts[ref].x;
		    tmp.y -= sym_pts[ref].y;
		    /* Convert to standard basis */
		    VectorMatrixMult(&tmp,xforms[4],&tmp);
		    Lines->m[EX]=Lines->m[SX]=tmp.x;
		    Lines->m[EY]=Lines->m[SY]=tmp.y;
/*
		    Lines->m[EX]=Lines->m[SX]=tmp.x-sym_pts[ref].x;
		    Lines->m[EY]=Lines->m[SY]=tmp.y-sym_pts[ref].y;
*/
		    }
		else /* mode == PICK or CUT */
		    {
			scaled_pick = scale*10+1;
			picksize(scaled_pick,scaled_pick);
			pick(namestack,NAMESTACKSIZE);
			ortho2(0.0,scale*win_rect.width,0.0,
				scale*win_rect.height);
			initnames();
			pushname(-1);
			DrawCurrent(&sym_rect,Lines,sym,
			    sym_pts,xforms,count,PickLine);
			hits = endpick(namestack);
			ortho2(0.0,scale*win_rect.width,0.0,
				scale*win_rect.height);

			if (hits == 2)
			    {
				Lines = GrabLine(namestack[4],Lines);
				DrawCurrent(&sym_rect,Lines,sym,
				    sym_pts,xforms,count,DrawLine);
				HighLiteLine(&sym_rect,Lines,sym,
				    sym_pts,xforms,count);
				swapbuffers();
				mode = CUT;
			    }
		    }
	       }

	     else if (ev==MIDDLEMOUSE)
	       {
		 if (!dev_data) continue;
		 if ((Lines != NULL) && ((mode == DRAW) || (mode ==CUT)))
		    {
		     Lines = DropLine(Lines);
		     DrawCurrent(&sym_rect,Lines,sym,
			   sym_pts,xforms,count,DrawLine);
		     swapbuffers();
		    }
		 if ((mode == DRAW) || (mode == 0)) mode = 0;
		 else mode = PICK;
	       }
	    else if (ev==RIGHTMOUSE)
		{
	            if (!dev_data) continue;
		    if (mode == TRANSFORM) mode = 0;
		    i = dopup(main_menu);
		    if ((i>0) && (i<18)) 
			{
			sym_index = i-1;
			sym = &(SYMTAB[sym_index]);
			Lines = ThrowAwayLines(Lines);
			mode = 0;
			DefineSymWindow(&sym_rect,sym,&win_rect,scale);
			count = SetUpSymmetry(sym,&sym_pts,xforms,&sym_rect);
			DrawCurrent(&sym_rect,Lines,sym,
			    sym_pts,xforms,count,DrawLine);
		        swapbuffers();
			}
		    else switch (i)
		    {
			case 18:
			{
			    DrawCurrent(&sym_rect,Lines,sym,
					sym_pts,xforms,count,DrawLine);
			    swapbuffers();
			    mode = 0;
			    break;
			}
			case 19:
			{
			 if ((mode == DRAW) && (Lines != NULL))
			    {
			     Lines = DropLine(Lines);
			     DrawCurrent(&sym_rect,Lines,sym,
					sym_pts,xforms,count,DrawLine);
			     swapbuffers();
	    		    }
			mode=PICK;
			break;
			}

			case 20:
			{
			filename = KeyboardIO(20,20.0,
					win_rect.height-20.0,
					"File:",scale);
			pat = fopen(filename,"w");
			if (pat == NULL) complain(&win_rect,scale);
			else
			{
			    KeyboardIO(0,20.0,win_rect.height-20.0,
					"writing file",scale);
			    sleep(2);
			    fprintf(pat,"%d\n",sym_index);
			    fprintf(pat,"%6.3f %6.3f\n",
				    sym_rect.width,sym_rect.height);
			    fprintf(pat,"%6.3f %6.3f\n",
				    sym->v1.x,sym->v1.y);
			    fprintf(pat,"%6.3f %6.3f\n",
				    sym->v2.x,sym->v2.y);
			    fprintf(pat,"%6.3f \n",
				    scale);
			    for (cur=Lines; cur != NULL; cur=cur->next)
			    fprintf(pat,"%6.3f %6.3f %6.3f %6.3f\n",
				cur->m[0],cur->m[1],cur->m[2],cur->m[3]);
			    fclose(pat);
			}
			DrawCurrent(&sym_rect,Lines,sym,
				sym_pts,xforms,count,DrawLine);
			swapbuffers();
			break;
			}

			case 21:
			{
			filename = KeyboardIO(20,20.0,
					win_rect.height-20.0,"File:",scale);
			pat = fopen(filename,"r");
			if (pat == NULL) complain(&win_rect,scale);
			else
			{
			    fscanf(pat,"%d\n",&sym_index);
			    fscanf(pat,"%f %f\n",&dummy,&dummy);
			    sym = &(SYMTAB[sym_index]);
			    fscanf(pat,"%f %f\n",
				    &(sym->v1.x),&(sym->v1.y));
			    fscanf(pat,"%f %f\n",
				    &(sym->v2.x),&(sym->v2.y));
			    fscanf(pat,"%f \n",
				    &scale);
			    DefineSymWindow(&sym_rect,sym,&win_rect,scale);
/*			    ortho2(0.0,scale*win_rect.width,0.0,
				   scale*win_rect.height); */
			    count = SetUpSymmetry(sym,&sym_pts,
				    xforms,&sym_rect);
			    Lines = ThrowAwayLines(Lines);
			    Lines = ReadPattern(Lines,pat);
			}
			DrawCurrent(&sym_rect,Lines,sym,
			    sym_pts,xforms,count,DrawLine);
		        swapbuffers();
			mode = 0;
			break;
			}

			case 22:
			{
			  mode = TRANSFORM; 
			  xformfnc = ChangeScale;
			  break;
			}

			case 23:
			{
			  mode = TRANSFORM; 
			  xformfnc = ChangeRotation;
			  break;
			}

		      case 24:
			{
			  if (sym->dof & RAT) {
			    mode = TRANSFORM; 
			    xformfnc = ChangeRatio;
			  }
			  break;
			}

		      case 25:
			{
			  if (sym->dof & ANG) {
			    mode = TRANSFORM; 
			    xformfnc = ChangeAngle;
			  }
			  break;
			}
		    }
		}
	   }
}
    

void ChangeScale(direction,sym,scale)
int direction;
SYMMETRY *sym;
float *scale;
{
  if (direction == 1) *scale *= 0.95;
  else *scale *= 1.05;
}

void ChangeRotation(direction,sym,scale)
int direction;
SYMMETRY *sym;
float *scale;
{
  double angle;
  XFORM rotation;

  if (direction == 1) angle = M_PI / 180;
  else angle = - M_PI / 180;
  SetUpRot(angle,rotation);
  VectorMatrixMult(&(sym->v1),rotation,&(sym->v1));
  VectorMatrixMult(&(sym->v2),rotation,&(sym->v2));
}

void ChangeRatio(direction,sym,scale)
int direction;
SYMMETRY *sym;
float *scale;
{
  if (direction == 1) VectorScalarMult(&sym->v1,1.1);
  else VectorScalarMult(&sym->v1,0.95);
}

void ChangeAngle(direction,sym,scale)
int direction;
SYMMETRY *sym;
float *scale;
{
  double angle;
  XFORM rotation;

  if (direction == 1) angle = M_PI / 360;
  else angle = - M_PI / 360;
  SetUpRot(angle,rotation);
  VectorMatrixMult(&(sym->v1),rotation,&(sym->v1));
  /* modify rotation matrix for opposite angle */
  rotation[1] = -rotation[1];
  rotation[2] = -rotation[2];
  VectorMatrixMult(&(sym->v2),rotation,&(sym->v2));
}


LINE *GrabLine(i,first)
short i;
LINE *first;
{
LINE *cur,*last;

    last = NULL;
    for (cur=first; cur != NULL; cur=cur->next)
      {
	if (cur->id == i)
	    {
		if (last != NULL) 
		    {
			last->next = cur->next;
			cur->next = first;
		    }
		break;
	    }
	last = cur;	  
      }
    return(cur);
}


LINE *DropLine(L)
LINE *L;
{
LINE *cur;
     cur = L->next;
     free(L);
     return(cur);
}


SetUpOperatorInterface(s_menu,m_menu,x_menu)
long *s_menu,*m_menu,*x_menu;
{
  qdevice(LEFTMOUSE);
  qdevice(MIDDLEMOUSE);
  qdevice(RIGHTMOUSE);
  *s_menu = defpup("SYMMETRIES %t|\
p3 - 3-way rotation|\
p2 - 2-way rotation|\
p1 - translation|\
pg - glide reflection|\
pgg - 2 glide reflections|\
pmg - glide reflection, 2-way rotation|\
pm - lattice reflection|\
cm - off-lattice reflection|\
pmm - lattice reflection, 2-way rotation|\
cmm - off-lattice reflection, 2-way rotation|\
p31m - lattice reflection, 3-way rotation|\
p3m1 - off-lattice reflection, 3-way rotation|\
p4 - 4-way rotation|\
p4g - glide reflection, 4-way rotation|\
p4m - lattice reflection, 4-way rotation|\
p6 - 6-way rotation|\
p6m - lattice reflection, 6-way rotation");
  *x_menu = defpup("TRANSFORMATIONS %t|\
scale %x22|rotate %x23|\
axis ratio %x24|axis angle %x25");
      *m_menu = defpup(" |enter lines %x18|delete lines %x19|symmetries %m|write out %x20|read in %x21|transformations %m",
    *s_menu,*x_menu);
}


GetCursor(p,r,scale)
POINT *p;
RECTANGLE *r;
float scale;
{
  p->x = (getvaluator(MOUSEX)-r->x)*scale;
  p->y = (getvaluator(MOUSEY)-r->y)*scale;
}



DrawCurrent(rect,Lines,sym,pts,xforms,count,drawing_routine)
RECTANGLE *rect;
LINE *Lines;
SYMMETRY *sym;
POINT *pts;
XFORM *xforms;
int count;
void (*drawing_routine) ();
{
  LINE *obj;
  RECTANGLE bounds;

  obj = MakeCurrentObject(Lines,sym,xforms,&bounds);
  color(WHITE);
  clear();
  color(BLACK);
  DrawPoints(pts,count);
  color(BLUE);
  ReplicateObject
    (rect,obj,pts,count,&bounds,&(sym->v1),&(sym->v2),drawing_routine);
  FreeObject(obj);
}

HighLiteLine(rect,Lines,sym,pts,xforms,count)
RECTANGLE *rect;
LINE *Lines;
SYMMETRY *sym;
POINT *pts;
XFORM *xforms;
int count;
{
    LINE *obj,*temp;
    RECTANGLE bounds;

    temp = Lines->next;
    Lines->next = NULL;
    obj = MakeCurrentObject(Lines,sym,xforms,&bounds);
    Lines->next = temp;
    color(MAGENTA);
    ReplicateObject
      (rect,obj,pts,count,&bounds,&(sym->v1),&(sym->v2),DrawLine);
    FreeObject(obj);
}



LINE* ThrowAwayLines(Lines)
LINE *Lines;
{
  LINE *cur;
  for (cur=Lines; cur!=NULL; cur=cur->next)
    free(cur);
  return(NULL);
}


WINDOW MakeWindow(r)
RECTANGLE *r;
{
  WINDOW rwin;

    rwin = winopen("kali");
    AdjustWindowRectangle(r);
    doublebuffer();
    gconfig();
    return(rwin);
}

AdjustWindowRectangle(r)
RECTANGLE *r;
{
  long x,y;

    getorigin(&x,&y);
    r->x = x; r->y = y;
    getsize(&x,&y);
    r->width = x; 
    r->height = y;
}


  
int closest(new_pt,pts,maxpts)
POINT *new_pt;
POINT *pts;
int maxpts;
{
  int i,min_i;
  float dist,min=HUGE;
 
  for (i=0; i<maxpts; i++)
    {
      dist = sqrt((new_pt->x-pts[i].x)*(new_pt->x-pts[i].x) +
	              (new_pt->y-pts[i].y)*(new_pt->y-pts[i].y));
      if (dist < min) {	min = dist; min_i = i; }
    }
  return(min_i);
}

PrintLine(l)
LINE* l;
{
int i;
    printf("%x ",l);
    for (i=0;i<4;i++)   printf("%6.3f ",l->m[i]);
    printf("%d %x \n",l->id,l->next);
}

DumpLines(Lines)
LINE* Lines;
{
  LINE* cur;    
  int i;
  i = 0;
  for (cur=Lines; cur != NULL; cur=cur->next)
    {
    printf("Line %d  ",i++);
    PrintLine(cur);
    }
}

complain(win_rect,scale)
RECTANGLE *win_rect;
float scale;
{
   KeyboardIO(0,20.0,win_rect->height-20.0,
		"Bogus file name!",scale);
   sleep(3);
}
