/*
### handle event from the combined space windows ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>

void aux_handle_event(canvas,event,arg)
Canvas          canvas;
Event          *event;
caddr_t         arg;
{
	static int r_x, r_y, r_xnew, r_ynew, r_tmp;
	int i,e_id, e_down,e_ctrl_down,e_shift_down,e_x, e_y;
	double aux_xsize, aux_ysize,x_scaled, y_scaled;
	extern Canvas *aux_canvas;
	extern Menu aux_menu;
	extern int aux_win_i;
	extern int func_on,region_index,n_stored_data2,my_colormap_size,var_dim,param_dim,full_dim;
	extern int aux_max;
	extern int **aux_cur_index;
	extern int *aux_rescale,*aux_win_mode;
	extern int aux_xcanvas,aux_ycanvas,aux_l_margin,aux_b_margin,aux_xwidth,aux_ywidth;
	extern double **aux_x_max,**aux_x_min,*win_var_i,*param,*t_va;
	extern char string[];
	extern int *data0_color,*data1_color,*data2_color;
	extern double **data0_x,**data1_x,**data2_x;
	e_id = event_id(event);
	e_x = event_x(event);
	e_y = event_y(event);
	e_down = event_is_down(event);
	e_ctrl_down = event_ctrl_is_down(event);
	e_shift_down = event_shift_is_down(event);

	if(e_down){
		for(i=0;i<=aux_max;i++){
			if(canvas == aux_canvas[i]){
				aux_win_i = i;
				break;
			}
		}
		/* if aux_win_mode is on, choose the aux box data
		whenever the event is down on the auxilieary window
		otherwise keep a current data selection from the main window */
		if(aux_win_mode[aux_win_i]){
			region_index = 2;
			if(e_id == MS_LEFT || e_id == MS_MIDDLE || e_id == MS_RIGHT){
				sprintf(string,"aux space and aux window [%d] selected!",aux_win_i);
				system_mess_proc(0,string);
			}
		}
	}
	else {
		return;
	}

	if(!aux_rescale[aux_win_i] && e_ctrl_down && !e_shift_down && e_id == MS_MIDDLE && e_down){ 
		(void) aux_clear_region(aux_win_i);
	}
	if(!aux_rescale[aux_win_i] && !e_ctrl_down && e_id == MS_LEFT && e_down) {
		if (e_x >= aux_l_margin && e_x <= aux_l_margin + aux_xwidth) {
			if (e_y <= aux_ycanvas - aux_b_margin && e_y >= aux_ycanvas - aux_b_margin - aux_ywidth) {
				/* THere is a bug here. System crashes */
				x_scaled = (e_x - aux_l_margin) / (double) aux_xwidth;
				y_scaled = ((aux_ycanvas - e_y) - aux_b_margin) / (double) aux_ywidth;
				t_va[aux_cur_index[aux_win_i][0]] = aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i] 
					+ x_scaled * (aux_x_max[aux_cur_index[aux_win_i][0]][aux_win_i] - aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i]);
				t_va[aux_cur_index[aux_win_i][1]] = aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i] 
					+ y_scaled * (aux_x_max[aux_cur_index[aux_win_i][1]][aux_win_i] - aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i]);
				if(aux_cur_index[aux_win_i][0] < full_dim ){
					win_var_i[aux_cur_index[aux_win_i][0]]=t_va[aux_cur_index[aux_win_i][0]];
				}
				else{ 
					param[aux_cur_index[aux_win_i][0]-full_dim]=t_va[aux_cur_index[aux_win_i][0]];
				}
				if(aux_cur_index[aux_win_i][1] < full_dim ){
					win_var_i[aux_cur_index[aux_win_i][1]]=t_va[aux_cur_index[aux_win_i][1]];
				}
				else{ 
					param[aux_cur_index[aux_win_i][1]-full_dim]=t_va[aux_cur_index[aux_win_i][1]];
				}
			}
			all_refresh();
		}
	}

	if (!aux_rescale[aux_win_i] && !e_ctrl_down && e_shift_down && e_id == MS_MIDDLE && e_down) {
		aux_redisplay_data(aux_win_i);
		all_refresh();
	}
	/* enter a rescaling mode */
	if ((aux_rescale[aux_win_i] || e_ctrl_down) && e_id == MS_LEFT && e_down) {
		if(e_ctrl_down)
			aux_rescale[aux_win_i] = 1- aux_rescale[aux_win_i];
		aux_rubber_box(aux_win_i,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1);
		r_x = e_x;
		r_y = e_y;
		r_xnew = r_x;
		r_ynew = r_y;
		aux_rubber_box(aux_win_i,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1);
	}
	/* show the rubberband box for the rescaled region */
	if (aux_rescale[aux_win_i] && e_id == LOC_DRAG) {
		aux_rubber_box(aux_win_i,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1);
		r_xnew = e_x;
		r_ynew = e_y;
		aux_rubber_box(aux_win_i,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size - 1);
	}
	/* rescaling action and exit rescaling mode */
	if (aux_rescale[aux_win_i] && e_id == MS_MIDDLE && e_down) {
		if (r_x > r_xnew) {
			r_tmp = r_xnew;
			r_xnew = r_x;
			r_x = r_tmp;
		}
		if (r_y < r_ynew) {
			r_tmp = r_ynew;
			r_ynew = r_y;
			r_y = r_tmp;
				if(!e_shift_down) {
					aux_xsize = aux_x_max[aux_cur_index[aux_win_i][0]][aux_win_i] - aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i];
					aux_ysize = aux_x_max[aux_cur_index[aux_win_i][1]][aux_win_i] - aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i];
					aux_x_max[aux_cur_index[aux_win_i][0]][aux_win_i] = aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i] 
					+ aux_xsize * (r_xnew - aux_l_margin) / (double) aux_xwidth;
					aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i] += aux_xsize * (r_x - aux_l_margin) / (double) aux_xwidth;
					aux_x_max[aux_cur_index[aux_win_i][1]][aux_win_i] = aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i] 
					+ aux_ysize * ((aux_ycanvas - r_ynew) - aux_b_margin) / (double) aux_ywidth;
					aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i] += aux_ysize * ((aux_ycanvas - r_y) - aux_b_margin) / (double) aux_ywidth;
				}
				else {
					aux_xsize = aux_x_max[aux_cur_index[aux_win_i][0]][aux_win_i]  - aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i];
					aux_ysize = aux_x_max[aux_cur_index[aux_win_i][1]][aux_win_i] - aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i];
					aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i] -= aux_xsize * (r_x - aux_l_margin) / (r_xnew - r_x);
					aux_x_max[aux_cur_index[aux_win_i][0]][aux_win_i] = aux_x_min[aux_cur_index[aux_win_i][0]][aux_win_i] 
					+ aux_xsize * aux_xwidth / (r_xnew - r_x);
					aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i] -= aux_ysize * ((aux_ycanvas - r_y) - aux_b_margin) / (r_y - r_ynew);
					aux_x_max[aux_cur_index[aux_win_i][1]][aux_win_i] = aux_x_min[aux_cur_index[aux_win_i][1]][aux_win_i] 
					+ aux_ysize * aux_ywidth / (r_y - r_ynew);
				}
		}
		all_refresh();
		aux_redisplay_data(aux_win_i);
		aux_rescale[aux_win_i] = 0;
		r_xnew = r_x;
		r_ynew = r_y;
	}
	if (!aux_rescale[aux_win_i] && !e_ctrl_down && !e_shift_down && e_id == MS_RIGHT && e_down) {
		menu_show(aux_menu,aux_canvas[aux_win_i],event,0);
	}
}
