/*
### create a lyapunov window ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>

void create_lyap_windows()
{
	void lyap_quit_proc(),lyap_go_proc();
	void lyap_algorithm_option_proc();
	int i,ipanel_row=0,px,py;
	extern Frame frame,lyap_frame,tser_frame;
	extern Panel lyap_panel;
	extern Pixfont *boldfont;
	extern Panel_item lyap_quit_item,lyap_go_item;
	extern Panel_item lyap_algorithm_option_item;
	extern short lyap_panel_show,tser_panel_show;
	extern int panel_colormap_on;
	extern int lyap_algorithm_option;
	extern char string[];
	
	/* Turn on the flag */	
	if(lyap_panel_show){
		window_set(lyap_frame,WIN_SHOW,TRUE,0);	
		return;
	}
	else
		lyap_panel_show = 1;

	if(tser_panel_show){
		px = (int) window_get(tser_frame,WIN_X);
		py = (int) window_get(tser_frame,WIN_Y) + (int) window_get(tser_frame,WIN_HEIGHT) + 50;
	}
	else {
		px = (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH)/2;
		py = (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT) /2 + 50;
	}
	/* Create tser frame */
	lyap_frame = window_create(frame,FRAME,
		FRAME_NO_CONFIRM,       TRUE,
		FRAME_LABEL,    "Lyapunov",
		FRAME_SHOW_LABEL,       TRUE,
		WIN_SHOW,       TRUE,
		WIN_X,  px,
		WIN_Y,  py,
		WIN_FONT, boldfont,
		0);
	if(lyap_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		lyap_panel_show = 0;
		return;
	}
	/* Create Panel */
	lyap_panel = window_create(lyap_frame, PANEL,
		WIN_X, 0,
		WIN_Y, 0,
		WIN_FONT, boldfont,
		0);
	if(lyap_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_lyap_windows();
		return;
	}
	/* Create panel items */
	lyap_quit_item= panel_create_item(lyap_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(lyap_panel, "Quit", 5, boldfont),
		PANEL_NOTIFY_PROC, lyap_quit_proc,
		0);
	lyap_go_item= panel_create_item(lyap_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(lyap_panel, "Go", 5, boldfont),
		PANEL_NOTIFY_PROC, lyap_go_proc,
		0);
	lyap_algorithm_option_item= panel_create_item(lyap_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Algorithm: ",
		PANEL_CHOICE_STRINGS,
			"Wolf's",
			"User algorithm A",
			"User algorithm B",
			0,
		PANEL_VALUE, lyap_algorithm_option,
		PANEL_NOTIFY_PROC, lyap_algorithm_option_proc,
		0);

	window_fit(lyap_panel);
	window_fit(lyap_frame);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(lyap_panel,WIN_PIXWIN),"lyap_panel_cms");
}
