/* util.c: file containing public and private utility routines */

#include <stdio.h>
#include <X11/Xlib.h>
#include "box_types.h"
#include "box_global.h"

ClearBox(gnrc,bx)

BoxStatus *gnrc;
BoxList *bx;

{
  GC gc;

  if(bx->state == BOX_YES)
     gc = gnrc->gc;  /* If bx "on" reverse colors */
  else
     gc = gnrc->reverse_gc;

  XFillRectangle(dpy,gnrc->TopWindow,gc,bx->x,bx->y,bx->width,bx->height);
}

DrawBox(gnrc,bx)

BoxStatus *gnrc;
BoxList *bx;

{
  TextList *txt;
  GC gc;
  BoxAttributeList *attr;
  int x,y,width,height;

  if(bx == &(gnrc->box)) return(0);
  if(bx->visible == BOX_NO && bx->always_visible == BOX_NO) return(0);

  x = bx->x; y = bx->y;
  if(bx->state == BOX_YES) {
     XFillRectangle(dpy,gnrc->TopWindow,gnrc->gc,x,y,
                bx->width,bx->height);
    }
  else {
     XFillRectangle(dpy,gnrc->TopWindow,gnrc->reverse_gc,x,y,
                bx->width,bx->height);
    }

  if(bx->border) {   /* Draw borders */
     XDrawRectangle(dpy,gnrc->TopWindow,gnrc->gc,x,y,
                                                 bx->width,bx->height);
    }
  txt = bx->txt.next;
  while(txt != NULL) {
     attr = txt->attr;
     if(bx->state == BOX_YES) gc = attr->reverse_gc;
     else gc = attr->gc;
     BoxDrawText(gnrc,bx,txt,gc);
     txt = txt->next;
    }

  /* Type specific drawing */
  switch(bx->type) {
     case BOX_TEXT_ENTRY:
       txt = &(bx->prompt); attr = txt->attr;
       if(bx->state == BOX_YES) gc = attr->reverse_gc;
       else gc = attr->gc;
       BoxDrawText(gnrc,bx,txt,gc);

       txt = &(bx->dflt); attr = txt->attr;
       if(bx->state == BOX_YES) gc = attr->reverse_gc;
       else gc = attr->gc;
       BoxDrawText(gnrc,bx,txt,gc);

       if(bx->state == BOX_YES) {
          /* place cursor */
          x = bx->x + BOX_PAD + bx->dflt.x + 
               XTextWidth(attr->fontstruct,txt->text,strlen(txt->text));
          y = bx->y + bx->dflt.y - attr->fth;
          XDrawLine(dpy,gnrc->TopWindow,gc,x,y,x,y+attr->fth);
         }
       break;

      case BOX_HORIZONTAL_SLIDER:
        x = bx->x; y = bx->y;
        height = bx->height; width = (int) (bx->value * (double) bx->width);
        XFillRectangle(dpy,gnrc->TopWindow,gnrc->gc,x,y,width,height);
        break;

      case BOX_VERTICAL_SLIDER:
        width = bx->width; height = (int) (bx->value * (double) bx->height);
        x = bx->x; y = bx->y + bx->height - height;
        XFillRectangle(dpy,gnrc->TopWindow,gnrc->gc,x,y,width,height);
        break;
    }
}

BoxDrawText(gnrc,bx,txt,gc)

BoxStatus *gnrc; BoxList *bx;
TextList *txt; GC gc;
{
  XDrawString(dpy,gnrc->TopWindow,gc,bx->x + txt->x,bx->y + txt->y,
                 txt->text,strlen(txt->text));
}


BoxList *FindBoxByPosition(gnrc,x,y)

BoxStatus *gnrc;
int x,y;

/*********** Check box lists for hits: a hit occurs if (x,y) is in box, 
  box->type != BOX_FOR_SHOW, and box->visible = BOX_YES.
  And: BoxIsValidChoice(gnrc,bx) returns 1 *****************/

{
  BoxList *bx,*rtrn;
  int generation;
  
  bx = gnrc->box.next;
  rtrn = &(gnrc->box);
  generation = -1;

  while(bx != NULL) {

     if(x >= bx->x && x <= bx->x + bx->width && y >= bx->y &&
        y <= bx->y + bx->height && bx->type != BOX_FOR_SHOW &&
        (bx->visible == BOX_YES || bx->always_visible == BOX_YES)) {

         if(BoxIsValidChoice(gnrc,bx)) {
            if(bx->parent == gnrc->current_box) { rtrn = bx; break; }
            if(bx->generation > generation) {
               generation = bx->generation;
               rtrn = bx;
              }
           }
        }
     bx = bx->next;
    }
  return(rtrn);
}

BoxList *FindBoxByID(gnrc,id)

BoxStatus *gnrc;
int id;

{

  BoxList *bx;
  
  bx = &(gnrc->box);
  while(bx != NULL && bx->id != id) {
     bx = bx->next;
    }
  return(bx);
}

PrintBoxInfo(fp,gnrc,bx)

FILE *fp;
BoxStatus *gnrc;
BoxList *bx;

{
  double x_mm,y_mm,width_mm,height_mm;
  TextList *txt;

  if(bx == &(gnrc->box)) {
    fprintf(fp,"Top Level box.\n");
    return(0);
   }

  x_mm = (double) bx->x /xppmm;
  y_mm = (double) bx->y /yppmm;
  width_mm = (double) bx->width/xppmm;
  height_mm = (double) bx->height/yppmm;
  fprintf(fp,"Box %d\n",bx->id);
  fprintf(fp,"  type %d\n",bx->type);
  fprintf(fp,"  position  %.2lf %.2lf\n",x_mm,y_mm);
  fprintf(fp,"  size  %.2lf %.2lf\n",width_mm,height_mm);
  if(bx->key != '\0')
       fprintf(fp,"  key %c\n",bx->key);
  fprintf(fp,"End\n");

  /* Text */
  txt = bx->txt.next;
  while(txt != NULL && txt->text[0] != '\0') {
     x_mm = (double) (txt->x) / xppmm; y_mm = (double) (txt->y) / yppmm;
     fprintf(fp,"Text %d %.2lf %.2lf \"%s\" %d\n",bx->id,x_mm,y_mm,
                                            txt->text,txt->attr->id);
     txt = txt->next;
    }
  if(bx->parent != &(gnrc->box))
     fprintf(fp,"Child %d %d\n",bx->id,bx->parent->id);

  /* Flags */
  if(bx->exclusive == BOX_YES) fprintf(fp,"Exclusive %d\n",bx->id);
  if(bx->always_visible == BOX_YES)
     fprintf(fp,"AlwaysVisible %d\n",bx->id);

  /* Type specific info */
  switch(bx->type) {
     case BOX_TEXT_ENTRY:
       txt = &(bx->prompt);
       if(txt->text[0] != '\0') {
          fprintf(fp,"Prompt %d \"%s\" %d\n",bx->id,txt->text,txt->attr->id);
         }
       txt = &(bx->dflt);
       if(txt->text[0] != '\0') {
          fprintf(fp,"Default %d \"%s\" %d\n",bx->id,txt->text,txt->attr->id);
         }
       break;

     case BOX_HORIZONTAL_SLIDER:
     case BOX_VERTICAL_SLIDER:
       fprintf(fp,"Value %d %.4lf\n",bx->id,bx->value);
       break;
    }
  fprintf(fp,"\n");
}

BoxAttributeList *FindBoxAttributeByID(gnrc,id)

BoxStatus *gnrc;
int id;

{
  BoxAttributeList *attr;
  attr = &(gnrc->attribute);
  while(attr != NULL && attr->id != id) { attr = attr->next; }
  return(attr);
}

BoxIsADescendent(gnrc,child,parent)

BoxStatus *gnrc;
BoxList *child,*parent;  

/* Routine returns 1 if child is a descendent of parent, 0 otherwise */

{
  BoxList *bx;
  bx = child;
  while(bx != &(gnrc->box) && bx->parent != parent) bx = bx->parent;
  if(bx == &(gnrc->box)) return(0);
  else return(1);
}
 
BoxIsASibling(gnrc,bx,sibling)

BoxStatus *gnrc;
BoxList *bx,*sibling;

{

  if(bx->parent == sibling->parent) return(1);
  else return(0); 
}
