#include <stdio.h>
#include <X11/Xlib.h>
#include "link_types.h"
#include "link_global.h"


LinkEvent(gnrc,event)

LinkStatus *gnrc;
XEvent *event;

{
  XWindowAttributes xwa;
  XWindowChanges xwc;
  int i;

  switch(event->type) {

     case Expose:

       if(event->xexpose.count > 0) {
          break;
         }
       if(event->xexpose.window == gnrc->TitleWindow) {
          ReDrawLinkTitleWindow(gnrc);
          break;
         }

       if(event->xexpose.window == gnrc->MessageWindow) {
          ReDrawLinkMessageWindow(gnrc);
          break;
         }

       if(event->xexpose.window == gnrc->TopWindow) {
          ReDrawLinkTopWindow(gnrc);
          break;
         }

       break;

     case ButtonPress:
       if(event->xbutton.window == gnrc->TopWindow) {
          LinkButtonPress(gnrc,event);
          break;
         }

       break;

     case ConfigureNotify:
       if(event->xconfigure.window == gnrc->TopWindow) {
          ReDrawLinkMessageWindow(gnrc);
          ReDrawLinkTitleWindow(gnrc);
         }
  
       break;

     default:
       break;
    }

}


LinkUrgentWindowDialogue(gnrc,prompt_string,return_string)

LinkStatus *gnrc;
char *prompt_string,*return_string;

/* Routine returns the length of the dialogue string */

{

  int x,y,pstn;
  char chrctr[2];
  XFontStruct *fontstruct;
  XEvent event;
  XWindowAttributes xwa;
  XWindowChanges xwc;

  if(gnrc->UrgentWindow == (Window) 0) return(0);

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);
  xwc.width = xwa.width;
  xwc.y = xwa.height/2;

  XConfigureWindow(dpy,gnrc->UrgentWindow,(CWWidth|CWY),&xwc);

  XMapRaised(dpy,gnrc->UrgentWindow);

  XGrabKeyboard(dpy,gnrc->UrgentWindow,False,
                GrabModeAsync,GrabModeAsync,
                CurrentTime);

  XDrawString(dpy,gnrc->UrgentWindow,gnrc->gc,
              LINK_PAD,LINK_PAD+gnrc->fth,prompt_string,
              strlen(prompt_string));

  /* Edit the filename */

  fontstruct = gnrc->fontstruct;

  pstn = 0;
  chrctr[0] = 0;
  chrctr[1] = 0;   /* for string manipulation */

  y = LINK_PAD + gnrc->fth;
  x = LINK_PAD + XTextWidth(fontstruct,prompt_string,strlen(prompt_string));


  while(chrctr[0] != '\r') {

     if((chrctr[0] >= 32) && (chrctr[0] <= 126)) {

        XDrawString(dpy,gnrc->UrgentWindow,
                    gnrc->gc,x,y,chrctr,1);

        x += XTextWidth(fontstruct,chrctr,1);

        return_string[pstn] = chrctr[0];
        pstn++;

       }

     if((chrctr[0] == 8) || (chrctr[0] == 127)) {

        if(pstn > 0) {
           pstn--;
           x -= XTextWidth(fontstruct,&(return_string[pstn]),1);
           XDrawImageString(dpy,gnrc->UrgentWindow,
                            gnrc->gc,x,y," ",1);
          }

       }

     XMaskEvent(dpy,KeyPressMask,&event);
     if(XLookupString(&(event.xkey),chrctr,1,NULL,NULL) == 0) {
        chrctr[0] = 0;
       }
    }

  return_string[pstn] = 0;

  XUngrabKeyboard(dpy,CurrentTime);
  XUnmapWindow(dpy,gnrc->UrgentWindow);

  return(pstn);

}
