/* rd.c: File containing all the redrawing routines */


#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include "link_types.h"
#include "link_global.h"

ReDrawLinkTitleWindow(gnrc)

LinkStatus *gnrc;

{
  XWindowAttributes xwa;
  XWindowChanges xwc;
  int x,y;

  if(gnrc->TitleWindow == (Window) 0) return(0);

  /* Redraw title */
  /* Get information on TopWindow */

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  /* Change size of Title Bar to conform to new Top Window size */

  xwc.width = xwa.width;

  XConfigureWindow(dpy,gnrc->TitleWindow,(CWWidth),&xwc);

  x = (xwa.width - XTextWidth(gnrc->fontstruct,
                                gnrc->title,strlen(gnrc->title)))/2;
  y = LINK_PAD + gnrc->fth;

  XDrawString(dpy,gnrc->TitleWindow,
              gnrc->gc,x,y,gnrc->title,strlen(gnrc->title));


}

ReDrawLinkMessageWindow(gnrc)

LinkStatus *gnrc;

{

  XWindowAttributes xwa;
  XWindowChanges xwc;
  int x,y;

  if(gnrc->MessageWindow == (Window) 0) return(0);

  /* Get information on TopWindow */
  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  /* Change size of Message Bar to conform to new Top Window size */

  xwc.width = xwa.width;

  XConfigureWindow(dpy,gnrc->MessageWindow,(CWWidth),&xwc);

  x = LINK_PAD;
  y = LINK_PAD + gnrc->fth;

  XDrawString(dpy,gnrc->MessageWindow,gnrc->reverse_gc,
              x,y,gnrc->message,strlen(gnrc->message));

}

LinkPrintMessage(gnrc,s)

LinkStatus *gnrc;
char *s;

{
  fprintf(stderr,"%s\n",s);
  if(gnrc->MessageWindow == (Window) 0) return(0);
  strcpy(gnrc->message,s);
  XClearWindow(dpy,gnrc->MessageWindow);

  XDrawString(dpy,gnrc->MessageWindow,gnrc->reverse_gc,
              LINK_PAD,LINK_PAD+gnrc->fth,s,strlen(s));
}

ReDrawLinkTopWindow(gnrc)

LinkStatus *gnrc;

{
  LinkList *lnk;
  LinkPointList *pnt,sample;
  int width,dcx,dcy;
  char strng[20];
  GC gc;

  if(gnrc->axes == LINK_SHOW) {
     dcx = gnrc->origin.dcx;
     dcy = gnrc->origin.dcy;
     XDrawLine(dpy,gnrc->TopWindow,gnrc->gc,dcx,0,dcx,gnrc->height);
     XDrawLine(dpy,gnrc->TopWindow,gnrc->gc,0,dcy,gnrc->width,dcy);
    }

  if(gnrc->xruler == LINK_SHOW) {
     dcx = sample.dcx = gnrc->hash_space/2; 
     sample.dcy = 0;
     if(gnrc->MessageWindow == (Window) 0) dcy = gnrc->height;
     else dcy = gnrc->height - gnrc->fth - 2* LINK_PAD;

     while(dcx < gnrc->width) {
        LinkComputePointWorldCoords(gnrc,&sample); 
        sprintf(strng,"%+.3g",sample.x);
        width = XTextWidth(gnrc->data_fontstruct,strng,strlen(strng));
        XDrawString(dpy,gnrc->TopWindow,
              gnrc->data_gc,dcx-width/2,dcy-gnrc->hash_height-LINK_PAD,
              strng,strlen(strng));

        XDrawLine(dpy,gnrc->TopWindow,gnrc->data_gc,dcx,dcy,dcx,
                           dcy-gnrc->hash_height);
        dcx += gnrc->hash_space/2;

        XDrawLine(dpy,gnrc->TopWindow,gnrc->data_gc,dcx,dcy,dcx,
                           dcy-gnrc->hash_height/2);
        dcx += gnrc->hash_space/2;
        sample.dcx = dcx;
       }
    }

  if(gnrc->yruler == LINK_SHOW) {
     if(gnrc->MessageWindow == (Window) 0) 
          dcy = sample.dcy = gnrc->height-gnrc->hash_height;
     else dcy = sample.dcy = 
            gnrc->height-gnrc->hash_space/2-gnrc->fth-2*LINK_PAD;
     sample.dcx = 0;
     dcx = 0; 

     while(dcy > 0) {
        LinkComputePointWorldCoords(gnrc,&sample);
        sprintf(strng,"%+.3g",sample.y);
        XDrawString(dpy,gnrc->TopWindow,
              gnrc->data_gc,dcx,dcy-LINK_PAD,strng,strlen(strng));

        XDrawLine(dpy,gnrc->TopWindow,gnrc->data_gc,dcx,dcy,
                           dcx+gnrc->hash_height, dcy);
                          
        dcy -= gnrc->hash_space/2;

        XDrawLine(dpy,gnrc->TopWindow,gnrc->data_gc,dcx,dcy,
                           dcx+gnrc->hash_height/2, dcy);
                          
        dcy -= gnrc->hash_space/2;
        sample.dcy = dcy;
       }
    }
  lnk = gnrc->link.next;
  while(lnk != NULL) {
     LinkDrawLink(gnrc,lnk);
     lnk = lnk->next;
    }
}

LinkDrawLink(gnrc,lnk)
LinkStatus *gnrc; LinkList *lnk;

{
  GC gc;
  LinkPointList *pnt;
  int dcx,dcy;

  if(lnk->visible == LINK_HIDE) return;

  if(lnk == gnrc->current_link && gnrc->color_ok == 0){  /* Double point size */
     gc = gnrc->data_gc;
     if(gnrc->vertices == LINK_SHOW) {  /* Display vertices */
        pnt = lnk->point.next;
        while(pnt != NULL) {
           dcx = pnt->dcx - LINK_POINT_X_SIZE;
           dcy = pnt->dcy - LINK_POINT_Y_SIZE;
           XFillRectangle(dpy,gnrc->TopWindow,gc,
                      dcx,dcy,2*LINK_POINT_X_SIZE,2*LINK_POINT_Y_SIZE);
           pnt = pnt->next;
          }
       }
    }

  else {
     if(lnk == gnrc->current_link) gc = gnrc->reverse_data_gc;
     else gc = gnrc->data_gc;
     if(gnrc->vertices == LINK_SHOW) {  /* Display vertices */
        pnt = lnk->point.next;
        while(pnt != NULL) {
           dcx = pnt->dcx - LINK_POINT_X_SIZE/2;
           dcy = pnt->dcy - LINK_POINT_Y_SIZE/2;
           XFillRectangle(dpy,gnrc->TopWindow,gc,
                      dcx,dcy,LINK_POINT_X_SIZE,LINK_POINT_Y_SIZE);
           pnt = pnt->next;
          }
       }
    }

  pnt = lnk->point.next;
  while(pnt != NULL) {
     LinkDrawEdge(gnrc,lnk,pnt);
     pnt = pnt->next;
    }
}

LinkDrawPoint(gnrc,lnk,pnt)
LinkStatus *gnrc; LinkList *lnk; LinkPointList *pnt;
{
  GC gc;
  int dcx,dcy;

  if(gnrc->vertices != LINK_SHOW) return;
 
  if(lnk == gnrc->current_link && gnrc->color_ok == 0){  /* Double point size */
     gc = gnrc->data_gc;
     dcx = pnt->dcx - LINK_POINT_X_SIZE;
     dcy = pnt->dcy - LINK_POINT_Y_SIZE;
     XFillRectangle(dpy,gnrc->TopWindow,gc,
                   dcx,dcy,2*LINK_POINT_X_SIZE,2*LINK_POINT_Y_SIZE);
    }

  else {
     if(lnk == gnrc->current_link) gc = gnrc->reverse_data_gc;
     else gc = gnrc->data_gc;
     dcx = pnt->dcx - LINK_POINT_X_SIZE/2;
     dcy = pnt->dcy - LINK_POINT_Y_SIZE/2;
     XFillRectangle(dpy,gnrc->TopWindow,gc,
                dcx,dcy,LINK_POINT_X_SIZE,LINK_POINT_Y_SIZE);
    }
}

LinkDrawEdge(gnrc,lnk,pnt)
LinkStatus *gnrc;LinkList *lnk;LinkPointList *pnt;

{
  GC gc;
  LinkPointList *nxt;
  LinkCrossingList *crossing;
  int x0,y0,x1,y1;

  if(pnt == NULL) return(0);
  if(pnt->next == NULL && lnk->closed == LINK_NO) return(0);

  if((nxt = pnt->next) == NULL) nxt =lnk->point.next;

  if(gnrc->color_ok && lnk == gnrc->current_link) 
     gc = gnrc->reverse_data_gc;
  else 
     gc = gnrc->data_gc;

  if(gnrc->arrows) { /* Draw arrow */
     x0 = pnt->dcx; y0 = pnt->dcy;
     x1 = nxt->dcx; y1 = nxt->dcy;
     LinkDrawArrow(gnrc,gc,(9*x0+x1)/10,(9*y0+y1)/10,x1-x0,y1-y0);
    }
     
  if((crossing = pnt->crossing.next) == NULL) {
       XDrawLine(dpy,gnrc->TopWindow,gc,pnt->dcx,pnt->dcy,
                  nxt->dcx,nxt->dcy);
    }
  else {
     int dcx,dcy,delta_x,delta_y;
     double param,gamma,tmp_x,tmp_y;

     /* Compute crossing gap vector */
     tmp_x = (double) (nxt->dcx - pnt->dcx)/xppmm;
     tmp_y = (double) (nxt->dcy - pnt->dcy)/yppmm;
     /* gamma = half fraction of total length devoted to each gap */
     gamma = 0.5*LINK_GAP/sqrt(tmp_x*tmp_x + tmp_y*tmp_y);
     delta_x = (int) (gamma * (double) (nxt->dcx - pnt->dcx));
     delta_y = (int) (gamma * (double) (nxt->dcy - pnt->dcy));

     dcx = pnt->dcx; dcy = pnt->dcy;
     param = 0;
     while(crossing != NULL) {
        if(crossing->z < 0) {
           if(param < crossing->param - gamma) {
              XDrawLine(dpy,gnrc->TopWindow,gc,dcx,dcy,
                  crossing->dcx - delta_x,crossing->dcy - delta_y);
             }
           if((param = crossing->param + gamma) > 1.0) {
              param = 1.0;
              dcx = nxt->dcx; dcy = nxt->dcy;
             }
           else {
              dcx = crossing->dcx + delta_x;dcy = crossing->dcy + delta_y;
             }
          }
        crossing = crossing->next;
       }

     /* Draw final part */
     if(param < 1.0) {
        XDrawLine(dpy,gnrc->TopWindow,gc,dcx,dcy,nxt->dcx,nxt->dcy);
       }
    }
}

LinkDrawArrow(gnrc,gc,x,y,dx,dy)
LinkStatus *gnrc;
GC gc;
int x,y,dx,dy;

/* Draw arrow at x,y in direction dx,dy */
{
  XPoint pnts[3];     /* The endpoints */
  double norm,cs,sn;

  /* Compute the endpoints */

  norm = sqrt((double) (dx*dx + dy*dy));

  if(norm < 0.5) {    /* dx = dy = 0 */
     return(0);
    }

  cs = ((double) dx)/norm;
  sn = ((double) dy)/norm;

  pnts[0].x = (short) x + (short) (LINK_ARROW_SIZE * cs *xppmm);
  pnts[0].y = (short) y + (short) (LINK_ARROW_SIZE * sn *yppmm);;

  pnts[1].x = (short) x + (short) (0.5*LINK_ARROW_SIZE*(-sn)*xppmm);
  pnts[1].y = (short) y + (short) (0.5*LINK_ARROW_SIZE*(cs)*yppmm);

  pnts[2].x = (short) x + (short) (0.5*LINK_ARROW_SIZE*(sn)*xppmm);
  pnts[2].y = (short) y + (short) (0.5*LINK_ARROW_SIZE*(-cs)*yppmm); 


  XFillPolygon(dpy,gnrc->TopWindow,
               gc,pnts,
               3,Convex,CoordModeOrigin);

  return(0);
}

